/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Script;

import gorsat.Commands.CommandParseUtilities;
import gorsat.Script.ExecutionBlock;
import gorsat.Script.VirtualFileEntry;
import gorsat.Utilities.MacroUtilities;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gorpipe.exceptions.GorParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.immutable.List;

public class VirtualFileManager {
    private static final Logger log = LoggerFactory.getLogger(VirtualFileManager.class);
    private final Map<String, VirtualFileEntry> virtualFileMap = new LinkedHashMap<String, VirtualFileEntry>();
    private final Pattern externalVirtualSearchPattern = Pattern.compile("\\[.+?:(?!//).+?]");

    public VirtualFileEntry add(String name) {
        if (name == null || name.isEmpty()) {
            throw new GorParsingException("Supplied virtual file entry name is empty: $name");
        }
        String groupName = MacroUtilities.getVirtualFileGroupName(name);
        return this.virtualFileMap.computeIfAbsent(groupName, x -> {
            VirtualFileEntry entry = new VirtualFileEntry("[" + groupName + "]");
            Object virtualName = name.startsWith("[") ? name : "[" + name + "]";
            entry.isExternal = this.isExternalVirtualFile((String)virtualName);
            return entry;
        });
    }

    public int size() {
        return this.virtualFileMap.size();
    }

    public VirtualFileEntry get(String name) {
        String groupName = MacroUtilities.getVirtualFileGroupName(name);
        return this.virtualFileMap.get(groupName);
    }

    public synchronized void addRange(Map<String, ExecutionBlock> executionBlocks) {
        executionBlocks.values().forEach(this::add);
    }

    public void add(ExecutionBlock executionBlock) {
        this.add(executionBlock.groupName());
        this.addQuery(executionBlock.query());
    }

    public void addQuery(String query) {
        List<String> virtualFiles = MacroUtilities.virtualFiles(query);
        virtualFiles.foreach(this::add);
    }

    public VirtualFileEntry[] getUnusedVirtualFileEntries() {
        return (VirtualFileEntry[])this.virtualFileMap.values().stream().filter(x -> x.isOriginal).filter(y -> y.fileName == null || y.fileName.isEmpty()).toArray(VirtualFileEntry[]::new);
    }

    public void updateCreatedFile(String name, String fileName) {
        VirtualFileEntry x = this.get(name);
        if (x != null) {
            if (fileName == null || fileName.isEmpty()) {
                throw new GorParsingException("Supplied virtual file name is empty: $fileName, for file entry: $name");
            }
        } else {
            throw new GorParsingException("Unable to locate virtual file entry $name for file: $fileName");
        }
        x.fileName = fileName;
    }

    public String replaceVirtualFiles(String query) {
        List<String> virtualFileList = MacroUtilities.virtualFiles(query);
        String outStr = query;
        for (int i = 0; i < virtualFileList.length(); ++i) {
            String virtualFile = (String)virtualFileList.apply(i);
            String name = MacroUtilities.getVirtualFileGroupName(virtualFile);
            VirtualFileEntry x = this.virtualFileMap.get(name);
            if (x != null) {
                if (x.fileName == null) continue;
                outStr = CommandParseUtilities.quoteSafeReplace((String)outStr, (String)virtualFile, (String)x.fileName);
                continue;
            }
            log.warn("There was no reference to create statement '{}' in replaceVirtualFiles", virtualFileList);
        }
        return outStr;
    }

    public Map<String, String> getCreatedFiles() {
        return this.virtualFileMap.values().stream().filter(y -> y.fileName != null && !y.fileName.isEmpty()).collect(Collectors.toMap(x -> x.name, x -> x.fileName));
    }

    public VirtualFileEntry[] getExternalVirtualFiles() {
        return (VirtualFileEntry[])this.virtualFileMap.values().stream().filter(x -> x.isExternal).toArray(VirtualFileEntry[]::new);
    }

    public boolean areDependenciesReady(String[] dependencies) {
        return Arrays.stream(dependencies).filter(x -> this.get((String)x) != null && this.get((String)x).fileName != null).count() == (long)dependencies.length;
    }

    public void setAllAsOriginal() {
        this.virtualFileMap.values().forEach(x -> {
            x.isOriginal = true;
        });
    }

    private boolean isExternalVirtualFile(String virtualFileName) {
        return this.externalVirtualSearchPattern.matcher(virtualFileName).find();
    }
}

