/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.gava;

import java.util.List;
import org.gorpipe.gor.gava.CollapsedCounts;
import org.gorpipe.gor.gava.GavaLogLikelihood;

public class RegularLogLikelihood
extends GavaLogLikelihood {
    @Override
    public double computeLogLikelihood(List<CollapsedCounts> collapsedCounts, int[] perm, boolean debug) {
        int numSubjects = perm.length;
        assert (numSubjects == this.numCases + this.numControls);
        double logSum = 0.0;
        for (CollapsedCounts counts : collapsedCounts) {
            int caseCopies = 0;
            int controlCopies = 0;
            for (int i = 0; i < numSubjects; ++i) {
                if (i < this.numControls) {
                    controlCopies += counts.callCounts[perm[i]];
                    continue;
                }
                caseCopies += counts.callCounts[perm[i]];
            }
            int allCopies = caseCopies + controlCopies;
            int groupSize = counts.numVariants;
            double p = (double)allCopies / (double)(2 * groupSize * numSubjects);
            double pA = (double)caseCopies / (double)(2 * groupSize * this.numCases);
            double pU = Math.min((double)controlCopies / (double)(2 * groupSize * this.numControls), this.upperFreqThreshold);
            if (this.includeProtective || pA > pU) {
                double logDiff = Math.log(counts.nullScore) - Math.log(counts.altScore);
                if (p > 0.0 && p < 1.0) {
                    logDiff += (double)allCopies * Math.log(p) + (double)(2 * groupSize * numSubjects - allCopies) * Math.log(1.0 - p);
                }
                if (pA > 0.0 && pA < 1.0) {
                    logDiff -= (double)caseCopies * Math.log(pA) + (double)(2 * groupSize * this.numCases - caseCopies) * Math.log(1.0 - pA);
                }
                if (pU > 0.0 && pU < 1.0) {
                    logDiff -= (double)controlCopies * Math.log(pU) + (double)(2 * groupSize * this.numControls - controlCopies) * Math.log(1.0 - pU);
                }
                if (logDiff < 0.0) {
                    logSum += logDiff;
                }
            }
            if (!debug) continue;
            String prefix = this.includeProtective || pA > pU ? "incl" : "excl";
            System.err.println(prefix + "\t" + caseCopies + "\t" + controlCopies + "\t" + pA + "\t" + pU + "\t" + -2.0 * logSum);
        }
        return logSum;
    }
}

