/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs;

import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gorpipe.exceptions.GorResourceException;
import org.gorpipe.gor.model.Constants;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.QueryEvaluator;
import org.gorpipe.querydialogs.AbstractListBean;
import org.gorpipe.querydialogs.Argument;
import org.gorpipe.querydialogs.ChartDataType;
import org.gorpipe.querydialogs.DialogDescription;
import org.gorpipe.querydialogs.DialogType;
import org.gorpipe.querydialogs.templating.DialogArgumentWrapper;
import org.gorpipe.querydialogs.templating.NetworkTemplateLoader;
import org.gorpipe.querydialogs.templating.QueryEvalMethodModel;
import org.gorpipe.querydialogs.templating.SkipFirstMethodModel;
import org.gorpipe.util.collection.extract.Extract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dialog
extends AbstractListBean {
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_BASE_QUERY = "baseQuery";
    public static final String PROPERTY_BASE_CHARTSCRIPT = "baseChartScript";
    public static final String PROPERTY_BASE_CHARTEXEC = "baseChartExec";
    public static final String PROPERTY_BASE_CHARTCOLUMNS = "baseChartColumns";
    public static final String PROPERTY_BASE_CHARTDF = "baseChartDF";
    public static final String PROPERTY_QUERY = "query";
    public static final String PROPERTY_CHART = "chart";
    public static final String PROPERTY_EXECUTABLE = "executable";
    private static final String ERROR_MSG_TEMPLATE_NAME_SUFFIX = "_error_message_";
    private static final String LONG_RUNNING_QUERY_TEMPLATE_NAME_SUFFIX = "_long_running_query_";
    private static final Logger logger = LoggerFactory.getLogger(Dialog.class);
    private StringTemplateLoader DIALOG_TEMPLATE_LOADER;
    private Configuration TEMPLATE_CONFIG;
    private String projectName;
    public final DialogDescription dialogDescription;
    protected final String errorMsgTemplate;
    protected final String longRunningQueryTemplate;
    protected final String version;
    protected final String packageVersion;
    protected final String gitSHA;
    protected final Map<String, Argument> argumentMap;
    private final PropertyChangeListener argumentListener;
    private final List<String> arguments;
    public Map<String, ? extends Object> attributes;
    protected boolean executable;
    private DialogType type;
    private String baseQuery;
    private String baseQueryMd5Digest;
    private String baseChartMd5Digest;
    private String baseChartExec;
    private String baseChartScript;
    private String baseChartColumns;
    private ChartDataType baseChartDF;
    private String interpolatedQuery;
    private String interpolatedChart;
    private String[] chartColumns;
    private boolean advancedArgumentsVisible;
    private boolean hasErrorMsgTemplate = false;
    private boolean hasLongRunningQuery = false;
    private final FileReader fileResolver;
    private final QueryEvaluator queryEval;
    private boolean deferUpdates;

    public Dialog(Map<String, ? extends Object> attributes, FileReader fileResolver, QueryEvaluator queryEval, DialogDescription dialogDescription, DialogType type, String query, String chartScript, String chartExec, String chartColumns, ChartDataType chartDF, List<Argument> arguments, String errorMsgTemplate, String longRunningQueryTemplate, String version, String packageVersion, String gitSHA) throws TemplateException {
        this.fileResolver = fileResolver;
        this.queryEval = queryEval;
        this.setConfig();
        this.attributes = attributes;
        this.dialogDescription = dialogDescription;
        this.arguments = new ArrayList<String>();
        this.errorMsgTemplate = errorMsgTemplate;
        this.longRunningQueryTemplate = longRunningQueryTemplate;
        this.version = version;
        this.packageVersion = packageVersion;
        this.gitSHA = gitSHA;
        this.argumentMap = new HashMap<String, Argument>();
        for (Argument a : arguments) {
            this.argumentMap.put(a.getName(), a);
            this.arguments.add(a.getName());
        }
        this.argumentListener = new ArgumentListener();
        for (Argument a : this.argumentMap.values()) {
            a.addPropertyChangeListener(this.argumentListener);
        }
        this.setType(type);
        this.setBaseQuery(query);
        this.setBaseChartScript(chartScript);
        this.setBaseChartExec(chartExec);
        this.setBaseChartColumns(chartColumns);
        this.setBaseChartDF(chartDF);
        this.loadErrorMessageTemplate();
        this.loadLongRunningQueryTemplate();
    }

    private void initializeTemplateConfig(FileReader fileResolver, QueryEvaluator queryEval) {
        this.TEMPLATE_CONFIG = new Configuration();
        this.TEMPLATE_CONFIG.setLocalizedLookup(false);
        this.DIALOG_TEMPLATE_LOADER = new StringTemplateLoader();
        String macroPath = System.getProperty("dialog.macrodir", null);
        if (macroPath != null) {
            NetworkTemplateLoader netLoader = new NetworkTemplateLoader(macroPath, fileResolver);
            this.TEMPLATE_CONFIG.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(new TemplateLoader[]{this.DIALOG_TEMPLATE_LOADER, netLoader}));
        } else {
            this.TEMPLATE_CONFIG.setTemplateLoader((TemplateLoader)this.DIALOG_TEMPLATE_LOADER);
        }
        this.TEMPLATE_CONFIG.setObjectWrapper((ObjectWrapper)new DialogArgumentWrapper());
        this.TEMPLATE_CONFIG.setTemplateExceptionHandler((TemplateExceptionHandler)new DialogTemplateExceptionHandler());
        this.TEMPLATE_CONFIG.setSharedVariable("skip", (TemplateModel)new SkipFirstMethodModel());
        this.TEMPLATE_CONFIG.setSharedVariable("br", (TemplateModel)new SimpleScalar("\\n"));
        this.TEMPLATE_CONFIG.setLocale(Locale.ENGLISH);
        this.TEMPLATE_CONFIG.setSharedVariable("gor", (TemplateModel)new QueryEvalMethodModel(queryEval));
    }

    public FileReader getFileResolver() {
        return this.fileResolver;
    }

    public QueryEvaluator getQueryEval() {
        return this.queryEval;
    }

    public String getName() {
        return this.dialogDescription.name;
    }

    private String getBaseQueryNameAndDigest() {
        if (this.baseQueryMd5Digest == null || this.baseQueryMd5Digest.length() == 0) {
            this.baseQueryMd5Digest = Extract.md5((String)this.baseQuery);
        }
        return this.getName() + "_" + this.baseQueryMd5Digest;
    }

    private String getBaseChartNameAndDigest() {
        if (this.baseChartMd5Digest == null || this.baseChartMd5Digest.length() == 0) {
            this.baseChartMd5Digest = Extract.md5((String)this.baseChartExec);
        }
        return this.getName() + "_" + this.baseChartMd5Digest;
    }

    public String getShortName() {
        int i;
        char[] name = this.getName().toCharArray();
        int upperCnt = 0;
        for (i = name.length - 1; i > 0 && upperCnt < 2 && name[i] != '_'; --i) {
            if (!Character.isUpperCase(name[i]) || !Character.isLowerCase(name[i - 1])) continue;
            ++upperCnt;
        }
        if (i > 0 || name[0] == '_') {
            ++i;
        }
        return new String(name, i, name.length - i);
    }

    public String getDescription() {
        return this.dialogDescription.detailedDescr;
    }

    public String getHelpLink() {
        return this.dialogDescription.helpLink;
    }

    public String getListDescription() {
        return this.dialogDescription.shortDescr;
    }

    public DialogType getType() {
        return this.type;
    }

    public void setType(DialogType type) {
        DialogType oldType = this.type;
        this.type = type;
        this.firePropertyChange(PROPERTY_TYPE, (Object)oldType, (Object)type);
    }

    public String getBaseQuery() {
        return this.baseQuery;
    }

    public void setBaseQuery(String query) throws TemplateException {
        String oldQuery = this.baseQuery;
        this.baseQuery = query;
        this.baseQueryMd5Digest = Extract.md5((String)this.baseQuery);
        this.firePropertyChange(PROPERTY_BASE_QUERY, oldQuery, query);
        if (query == null || !query.equals(oldQuery)) {
            this.DIALOG_TEMPLATE_LOADER.putTemplate(this.getBaseQueryNameAndDigest(), query);
            this.updateInterpolatedQuery();
        }
    }

    public String getBaseChartExec() {
        return this.baseChartExec;
    }

    public void setBaseChartExec(String chartExec) throws TemplateException {
        if (chartExec != null) {
            String oldChartExec = this.baseChartExec;
            this.baseChartExec = chartExec;
            this.baseChartMd5Digest = Extract.md5((String)this.baseChartExec);
            this.firePropertyChange(PROPERTY_BASE_CHARTEXEC, oldChartExec, chartExec);
            if (chartExec == null || !chartExec.equals(oldChartExec)) {
                this.DIALOG_TEMPLATE_LOADER.putTemplate(this.getBaseChartNameAndDigest(), chartExec);
                this.updateInterpolatedChart();
            }
        }
    }

    public String getBaseChartScript() {
        return this.baseChartScript;
    }

    public void setBaseChartScript(String chartScript) {
        String oldChartScript = this.baseChartScript;
        this.baseChartScript = chartScript;
        this.firePropertyChange(PROPERTY_BASE_CHARTSCRIPT, oldChartScript, chartScript);
    }

    public ChartDataType getBaseChartDF() {
        return this.baseChartDF;
    }

    public void setBaseChartDF(ChartDataType chartDF) {
        ChartDataType oldChartDF = this.baseChartDF;
        this.baseChartDF = chartDF;
        this.firePropertyChange(PROPERTY_BASE_CHARTDF, (Object)oldChartDF, (Object)chartDF);
    }

    public String getBaseChartColumns() {
        return this.baseChartColumns;
    }

    public void setBaseChartColumns(String chartColumns) {
        String oldChartColumns = this.baseChartColumns;
        if (chartColumns != null) {
            this.baseChartColumns = chartColumns;
            this.chartColumns = this.baseChartColumns.trim().split(",");
            this.firePropertyChange(PROPERTY_BASE_CHARTCOLUMNS, oldChartColumns, chartColumns);
        }
    }

    public void setDeferUpdates(boolean deferUpdates) {
        this.deferUpdates = deferUpdates;
    }

    public boolean advancedArgumentsVisible() {
        return this.advancedArgumentsVisible;
    }

    public void setAdvancedArgumentsVisible(boolean visible) {
        this.advancedArgumentsVisible = visible;
    }

    protected void loadQuery(String queryName, String query) {
        this.DIALOG_TEMPLATE_LOADER.putTemplate(queryName, query);
    }

    protected String interpolateQuery(String templateName) throws TemplateException, IOException {
        SkipFirstMethodModel sf = (SkipFirstMethodModel)this.TEMPLATE_CONFIG.getSharedVariable("skip");
        sf.reset();
        Template template = this.TEMPLATE_CONFIG.getTemplate(templateName);
        StringWriter writer = new StringWriter();
        template.process(this.argumentMap, (Writer)writer);
        return writer.toString().trim().replaceAll("\\\\n", "\n");
    }

    protected String interpolateChart(String templateName) throws TemplateException, IOException {
        SkipFirstMethodModel sf = (SkipFirstMethodModel)this.TEMPLATE_CONFIG.getSharedVariable("skip");
        sf.reset();
        Template template = this.TEMPLATE_CONFIG.getTemplate(templateName);
        StringWriter writer = new StringWriter();
        template.process(this.argumentMap, (Writer)writer);
        return writer.toString().trim().replaceAll("\\\\n", "\n");
    }

    private void updateInterpolatedQuery() throws TemplateException {
        if (this.deferUpdates) {
            this.interpolatedQuery = null;
        } else {
            this.calcInterpolatedQuery();
        }
    }

    public void calcInterpolatedQuery() throws TemplateException {
        String oldQuery = this.interpolatedQuery;
        if (this.baseQuery == null) {
            this.interpolatedQuery = null;
            this.firePropertyChange(PROPERTY_QUERY, oldQuery, null);
            this.updateExecutable(false);
        } else {
            try {
                DialogTemplateExceptionHandler validator = (DialogTemplateExceptionHandler)this.TEMPLATE_CONFIG.getTemplateExceptionHandler();
                validator.reset(this);
                this.interpolatedQuery = this.interpolateQuery(this.getBaseQueryNameAndDigest());
                this.firePropertyChange(PROPERTY_QUERY, oldQuery, this.interpolatedQuery);
                boolean someMandatoryUnset = false;
                for (String key : this.argumentMap.keySet()) {
                    Argument a = this.argumentMap.get(key);
                    someMandatoryUnset = someMandatoryUnset || !a.isOptional() && a.isEmpty();
                }
                boolean isExecutable = validator.isValid() && !someMandatoryUnset && !this.interpolatedQuery.isEmpty();
                this.updateExecutable(isExecutable);
            }
            catch (ParseException e) {
                throw new RuntimeException("Invalid query template", e);
            }
            catch (IOException e) {
                throw new GorResourceException("Error on String(Reader/Writer) io", this.baseQuery, (Throwable)e);
            }
        }
    }

    private void updateInterpolatedChart() throws TemplateException {
        String oldChart = this.interpolatedChart;
        if (this.baseChartExec == null) {
            this.interpolatedChart = null;
            this.firePropertyChange(PROPERTY_CHART, oldChart, null);
            this.updateExecutable(false);
        } else {
            try {
                DialogTemplateExceptionHandler validator = (DialogTemplateExceptionHandler)this.TEMPLATE_CONFIG.getTemplateExceptionHandler();
                validator.reset(this);
                this.interpolatedChart = this.interpolateChart(this.getBaseChartNameAndDigest());
                this.firePropertyChange(PROPERTY_CHART, oldChart, this.interpolatedChart);
                this.updateExecutable(validator.isValid() && !this.interpolatedChart.isEmpty());
            }
            catch (ParseException e) {
                throw new RuntimeException("Invalid chart template", e);
            }
            catch (IOException e) {
                logger.error("Error on String(Reader/Writer) io", (Throwable)e);
            }
        }
    }

    public String getInterpolatedQuery() {
        if (this.interpolatedQuery == null) {
            try {
                this.calcInterpolatedQuery();
            }
            catch (TemplateException e) {
                throw new RuntimeException(e);
            }
        }
        return this.interpolatedQuery;
    }

    public String getInterpolatedChart() {
        return this.interpolatedChart;
    }

    public String getQuery() {
        return this.getInterpolatedQuery();
    }

    public String getChart() {
        return this.getInterpolatedChart();
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public String getGitSha() {
        return this.gitSHA;
    }

    private void loadErrorMessageTemplate() {
        if (this.errorMsgTemplate != null && this.errorMsgTemplate.length() > 0) {
            this.loadQuery(this.getErrorMessageTemplateName(), this.errorMsgTemplate);
            this.hasErrorMsgTemplate = true;
        }
    }

    private void loadLongRunningQueryTemplate() {
        if (this.longRunningQueryTemplate != null && this.longRunningQueryTemplate.length() > 0) {
            this.loadQuery(this.getLongRunningQueryTemplateName(), this.longRunningQueryTemplate);
            this.hasLongRunningQuery = true;
        }
    }

    private String getLongRunningQueryTemplateName() {
        return this.getName() + LONG_RUNNING_QUERY_TEMPLATE_NAME_SUFFIX + Extract.md5((String)this.longRunningQueryTemplate);
    }

    private String getErrorMessageTemplateName() {
        return this.getName() + ERROR_MSG_TEMPLATE_NAME_SUFFIX + Extract.md5((String)this.errorMsgTemplate);
    }

    public String getErrorMessage() {
        String interpolatedErrorMsg = "";
        if (this.hasErrorMsgTemplate) {
            try {
                interpolatedErrorMsg = this.interpolateQuery(this.getErrorMessageTemplateName());
            }
            catch (TemplateException | IOException e) {
                logger.warn("Could not interpolate query template: " + e.getMessage());
            }
        }
        return interpolatedErrorMsg;
    }

    public String determineLongRunningQuery() {
        String longRunningQueryMsg = "";
        if (this.hasLongRunningQuery) {
            try {
                longRunningQueryMsg = this.interpolateQuery(this.getLongRunningQueryTemplateName());
            }
            catch (TemplateException | IOException e) {
                logger.warn("Could not interpolate long running query template: " + e.getMessage());
            }
        }
        return longRunningQueryMsg;
    }

    public List<Argument> copyArguments() {
        ArrayList<Argument> argumentCopies = new ArrayList<Argument>();
        for (String argument : this.arguments) {
            argumentCopies.add(this.argumentMap.get(argument).copyArgument());
        }
        return argumentCopies;
    }

    private void updateExecutable(boolean isExecutable) {
        boolean wasExecutable = this.executable;
        this.executable = isExecutable;
        this.firePropertyChange(PROPERTY_EXECUTABLE, wasExecutable, isExecutable);
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public Argument getArgument(String argumentName) {
        return this.argumentMap.get(argumentName);
    }

    public boolean hasArgument(String argumentName) {
        return this.argumentMap.containsKey(argumentName);
    }

    public void setArgument(String argumentName, Argument arg) {
        this.argumentMap.put(argumentName, arg);
    }

    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public Object getElementAt(int index) {
        return this.argumentMap.get(this.arguments.get(index));
    }

    @Override
    public int getSize() {
        return this.arguments.size();
    }

    public String toString() {
        return this.getName();
    }

    private void setConfig() {
        if (Constants.isSet()) {
            String constantsProjectName = Constants.get().projectName();
            if (!constantsProjectName.equals(this.projectName)) {
                this.initializeTemplateConfig(this.fileResolver, this.queryEval);
                this.projectName = constantsProjectName;
            }
        } else if (this.TEMPLATE_CONFIG == null) {
            this.initializeTemplateConfig(this.fileResolver, this.queryEval);
        }
    }

    static {
        try {
            freemarker.log.Logger.selectLoggerLibrary((int)0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private final class ArgumentListener
    implements PropertyChangeListener {
        private ArgumentListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("value") || evt.getPropertyName().equals("operator")) {
                try {
                    Dialog.this.updateInterpolatedQuery();
                }
                catch (TemplateException ex) {
                    logger.warn("Could not interpolate query template", (Throwable)ex);
                }
            }
        }
    }

    private static final class DialogTemplateExceptionHandler
    implements TemplateExceptionHandler {
        static final Pattern MESSAGE_PATTERN = Pattern.compile("^Expression (.+)\\.(.+) is undefined on.*");
        int count = 0;
        Dialog dialog;

        private DialogTemplateExceptionHandler() {
        }

        void reset(Dialog d) {
            this.count = 0;
            this.dialog = d;
        }

        boolean isValid() {
            return this.count == 0;
        }

        public void handleTemplateException(TemplateException te, Environment env, Writer out) throws TemplateException {
            block4: {
                try {
                    Matcher m = MESSAGE_PATTERN.matcher(te.getMessage());
                    if (m.matches() && m.group(2).startsWith("val")) {
                        if (!this.dialog.getArgument(m.group(1)).isOptional()) {
                            ++this.count;
                            out.write("REQUIRED(" + m.group(1) + ")");
                        }
                        break block4;
                    }
                    throw te;
                }
                catch (IOException e) {
                    throw new TemplateException("Failed to write required argument. Cause: " + e, env);
                }
            }
        }
    }
}

