/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Commands;

import gorsat.Commands.Analysis;
import gorsat.Commands.CommandArguments;
import gorsat.Commands.CommandArguments$;
import gorsat.Commands.CommandInfo;
import gorsat.Commands.CommandInfo$;
import gorsat.Commands.CommandOptions;
import gorsat.Commands.CommandOptions$;
import gorsat.Commands.CommandParseUtilities$;
import gorsat.Commands.CommandParsingResult;
import gorsat.Commands.CommandParsingResult$;
import gorsat.Commands.CommandRuntime;
import gorsat.external.plink.PlinkArguments;
import gorsat.external.plink.PlinkProcessAdaptor;
import gorsat.external.plink.PlinkVcfProcessAdaptor;
import gorsat.process.GorJavaUtilities;
import java.io.Serializable;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.gor.session.GorContext;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U3A\u0001B\u0003\u0001\u0015!)q\u0002\u0001C\u0001!!)!\u0003\u0001C!'!)\u0001\n\u0001C\u0005\u0013\ny\u0001\u000b\\5oWJ+wM]3tg&|gN\u0003\u0002\u0007\u000f\u0005A1i\\7nC:$7OC\u0001\t\u0003\u00199wN]:bi\u000e\u00011C\u0001\u0001\f!\taQ\"D\u0001\u0006\u0013\tqQAA\u0006D_6l\u0017M\u001c3J]\u001a|\u0017A\u0002\u001fj]&$h\bF\u0001\u0012!\ta\u0001!\u0001\tqe>\u001cWm]:Be\u001e,X.\u001a8ugRAAcF\u00135uq\n5\t\u0005\u0002\r+%\u0011a#\u0002\u0002\u0015\u0007>lW.\u00198e!\u0006\u00148/\u001b8h%\u0016\u001cX\u000f\u001c;\t\u000ba\u0011\u0001\u0019A\r\u0002\u000f\r|g\u000e^3yiB\u0011!dI\u0007\u00027)\u0011A$H\u0001\bg\u0016\u001c8/[8o\u0015\tqr$A\u0002h_JT!\u0001I\u0011\u0002\u000f\u001d|'\u000f]5qK*\t!%A\u0002pe\u001eL!\u0001J\u000e\u0003\u0015\u001d{'oQ8oi\u0016DH\u000fC\u0003'\u0005\u0001\u0007q%A\u0005be\u001e\u001cFO]5oOB\u0011\u0001&\r\b\u0003S=\u0002\"AK\u0017\u000e\u0003-R!\u0001L\u0005\u0002\rq\u0012xn\u001c;?\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Aj\u0003\"B\u001b\u0003\u0001\u00041\u0014!B5be\u001e\u001c\bcA\u001c9O5\tQ&\u0003\u0002:[\t)\u0011I\u001d:bs\")1H\u0001a\u0001m\u0005!\u0011M]4t\u0011\u0015i$\u00011\u0001?\u0003))\u00070Z2vi\u0016tuN\u001d\t\u0003o}J!\u0001Q\u0017\u0003\u000f\t{w\u000e\\3b]\")!I\u0001a\u0001O\u0005\tbm\u001c:dK\u0012Le\u000e];u\u0011\u0016\fG-\u001a:\t\u000f\u0011\u0013\u0001\u0013!a\u0001\u000b\u0006q1m\\7nC:$'+\u001e8uS6,\u0007C\u0001\u0007G\u0013\t9UA\u0001\bD_6l\u0017M\u001c3Sk:$\u0018.\\3\u0002!\u001d,GoQ8mk6t\u0017J\u001c3jG\u0016\u001cHc\u0001&O!B\u0019q\u0007O&\u0011\u0005]b\u0015BA'.\u0005\rIe\u000e\u001e\u0005\u0006\u001f\u000e\u0001\rAN\u0001\tS:DU-\u00193fe\")\u0011k\u0001a\u0001%\u0006!1m\u001c7t!\r94kJ\u0005\u0003)6\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?\u0001")
public class PlinkRegression
extends CommandInfo {
    public CommandParsingResult processArguments(GorContext context, String argString, String[] iargs, String[] args, boolean executeNor, String forcedInputHeader, CommandRuntime commandRuntime) {
        int[] colIndices;
        String hideCovarOption = "-hc";
        String firthOption = "-firth";
        String impOption = "-imp";
        String domOption = "-dom";
        String recOption = "-rec";
        String cvsOption = "-cvs";
        String vsOption = "-vs";
        String qnOption = "-qn";
        String vcfOption = "-vcf";
        String covarOption = "-covar";
        String thresholdOption = "-threshold";
        String hweOption = "-hwe";
        String genoOption = "-geno";
        String mafOption = "-maf";
        boolean firth = CommandParseUtilities$.MODULE$.hasOption(args, firthOption);
        boolean imputed = CommandParseUtilities$.MODULE$.hasOption(args, impOption);
        boolean thresholdSet = CommandParseUtilities$.MODULE$.hasOption(args, thresholdOption);
        boolean dom = CommandParseUtilities$.MODULE$.hasOption(args, domOption);
        boolean rec = CommandParseUtilities$.MODULE$.hasOption(args, recOption);
        boolean cvs = CommandParseUtilities$.MODULE$.hasOption(args, cvsOption);
        boolean vs = CommandParseUtilities$.MODULE$.hasOption(args, vsOption);
        boolean qn = CommandParseUtilities$.MODULE$.hasOption(args, qnOption);
        boolean hc = CommandParseUtilities$.MODULE$.hasOption(args, hideCovarOption);
        boolean vcf = CommandParseUtilities$.MODULE$.hasOption(args, vcfOption);
        if (!imputed && thresholdSet) {
            throw new GorParsingException("The -threshold option is only allowed together with the -imp option.");
        }
        String pheno = iargs[0];
        String covar = CommandParseUtilities$.MODULE$.stringValueOfOptionWithDefault(args, covarOption, null);
        float threshold = (float)CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck(args, thresholdOption, 0.9, 0.0, 1.0);
        float hwe = (float)CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck(args, hweOption, -1.0, CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck$default$4(), CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck$default$5());
        float geno = (float)CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck(args, genoOption, -1.0, CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck$default$4(), CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck$default$5());
        float maf = (float)CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck(args, mafOption, -1.0, CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck$default$4(), CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck$default$5());
        PlinkArguments plinkArguments = new PlinkArguments(pheno, covar, firth, hc, dom, rec, vs, qn, cvs, hwe, geno, maf);
        String[] inHeaderCols = new StringOps(Predef$.MODULE$.augmentString(forcedInputHeader)).split('\t');
        int[] nArray = colIndices = vcf ? this.getColumnIndices(inHeaderCols, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(RS|ID).*", "REF.*", "ALT.*"})) : this.getColumnIndices(inHeaderCols, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(RS|ID).*", "REF.*", "ALT.*", "VALUE.*"}));
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(colIndices)).tail())).contains((Object)BoxesRunTime.boxToInteger((int)-1))) {
            throw new GorParsingException("There must be a reference allele column, alternative allele column and value column.");
        }
        GorJavaUtilities.Phenotypes phenotype = GorJavaUtilities.getPhenotype(pheno);
        scala.collection.mutable.StringBuilder headerBuilder = new scala.collection.mutable.StringBuilder();
        headerBuilder.append(inHeaderCols[0]);
        headerBuilder.append('\t');
        headerBuilder.append(inHeaderCols[1]);
        headerBuilder.append('\t');
        scala.collection.mutable.StringBuilder stringBuilder = colIndices[0] == -1 ? headerBuilder.append("ID") : headerBuilder.append(inHeaderCols[colIndices[0]]);
        headerBuilder.append('\t');
        headerBuilder.append(inHeaderCols[colIndices[1]]);
        headerBuilder.append('\t');
        headerBuilder.append(inHeaderCols[colIndices[2]]);
        headerBuilder.append('\t');
        scala.collection.mutable.StringBuilder stringBuilder2 = phenotype.equals((Object)GorJavaUtilities.Phenotypes.BINARY) ? headerBuilder.append("A1\tFIRTH\tTEST\tOBS_CT\tOR\tLOG_OR_SE\tZ_STAT\tP\tERRCODE\tPHENO") : (phenotype.equals((Object)GorJavaUtilities.Phenotypes.MIXED) ? headerBuilder.append("A1\tFIRTH?\tTEST\tOBS_CT\tOR\tLOG(OR)_SE\tZ_STAT\tP\tERRCODE\tPHENO") : headerBuilder.append("A1\tTEST\tOBS_CT\tBETA\tSE\tT_STAT\tP\tERRCODE\tPHENO"));
        String header = headerBuilder.toString();
        PlinkProcessAdaptor pip = vcf ? new PlinkVcfProcessAdaptor(context.getSession(), plinkArguments, colIndices[1], colIndices[2], colIndices[0], colIndices.length == 4 ? colIndices[3] : -1, !imputed, threshold, vcf, forcedInputHeader, header) : new PlinkProcessAdaptor(context.getSession(), plinkArguments, colIndices[1], colIndices[2], colIndices[0], colIndices.length == 4 ? colIndices[3] : -1, !imputed, threshold, vcf, header);
        return new CommandParsingResult((Analysis)pip, header, CommandParsingResult$.MODULE$.apply$default$3(), CommandParsingResult$.MODULE$.apply$default$4());
    }

    private int[] getColumnIndices(String[] inHeader, Seq<String> cols) {
        String[] inHeaderToUpper = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inHeader)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toUpperCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        if (!cols.forall((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToBoolean((boolean)PlinkRegression.$anonfun$getColumnIndices$2(inHeaderToUpper, col)))) {
            throw new GorParsingException(new StringBuilder(34).append("Ambiguous column names in header:\t").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inHeader)).mkString("\t")).toString());
        }
        return (int[])((TraversableOnce)cols.map((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToInteger((int)PlinkRegression.$anonfun$getColumnIndices$4(inHeaderToUpper, col)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public static final /* synthetic */ boolean $anonfun$getColumnIndices$2(String[] inHeaderToUpper$1, String col) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inHeaderToUpper$1)).count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.matches(col))) <= 1;
    }

    public static final /* synthetic */ int $anonfun$getColumnIndices$4(String[] inHeaderToUpper$1, String col) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inHeaderToUpper$1)).indexWhere((Function1 & Serializable & scala.Serializable)in -> BoxesRunTime.boxToBoolean((boolean)in.matches(col)));
    }

    public PlinkRegression() {
        super("PLINKREGRESSION", new CommandArguments("-hc -firth -imp -dom -rec -cvs -vs -qn -vcf", "-covar -threshold -hwe -geno -maf", 1, 1, CommandArguments$.MODULE$.apply$default$5()), new CommandOptions(true, true, CommandOptions$.MODULE$.apply$default$3(), CommandOptions$.MODULE$.apply$default$4(), CommandOptions$.MODULE$.apply$default$5(), CommandOptions$.MODULE$.apply$default$6()), CommandInfo$.MODULE$.$lessinit$greater$default$4());
    }
}

