/*
 * Decompiled with CFR 0.152.
 */
package gorsat.external.plink;

import gorsat.external.plink.GORLine;
import gorsat.external.plink.PlinkArguments;
import gorsat.external.plink.PlinkProcessAdaptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.gorpipe.exceptions.GorResourceException;

class PlinkThread
implements Callable<Boolean> {
    private final List<String> plinkArgList = new ArrayList<String>();
    private final File projectRoot;
    private final Path tmpPath;
    private final boolean first;
    private final PlinkProcessAdaptor ppa;
    private final String pgenPath;
    private final Instant processStart = Instant.now().truncatedTo(ChronoUnit.SECONDS);

    PlinkThread(File projectRoot, Path writeDir, String[] plinkExecutable, String pgenPath, String sampleFile, boolean first, PlinkProcessAdaptor ppa, PlinkArguments args, boolean vcf) {
        this.tmpPath = writeDir;
        this.projectRoot = projectRoot;
        this.first = first;
        this.ppa = ppa;
        this.plinkArgList.addAll(Arrays.asList(plinkExecutable));
        this.plinkArgList.add("--threads");
        this.plinkArgList.add("2");
        this.plinkArgList.add("--memory");
        this.plinkArgList.add("1600");
        if (vcf) {
            this.plinkArgList.add("--vcf");
            this.plinkArgList.add(pgenPath + ".vcf");
            this.plinkArgList.add("--pheno");
            this.plinkArgList.add(args.pheno);
        } else {
            this.plinkArgList.add("--pgen");
            this.plinkArgList.add(pgenPath + ".pgen");
            this.plinkArgList.add("--pvar");
            this.plinkArgList.add(pgenPath + ".pvar");
            this.plinkArgList.add("--psam");
            this.plinkArgList.add(sampleFile);
        }
        if (args.mafThreshold != -1.0f) {
            this.plinkArgList.add("--maf");
            this.plinkArgList.add(String.valueOf(args.mafThreshold));
        }
        if (args.hweThreshold != -1.0f) {
            this.plinkArgList.add("--hwe");
            this.plinkArgList.add(String.valueOf(args.hweThreshold));
        }
        if (args.genoThreshold != -1.0f) {
            this.plinkArgList.add("--geno");
            this.plinkArgList.add(String.valueOf(args.genoThreshold));
        }
        this.plinkArgList.add("--glm");
        if (args.firth) {
            this.plinkArgList.add("firth-fallback");
        }
        if (args.hideCovar) {
            this.plinkArgList.add("hide-covar");
        }
        if (args.dom) {
            this.plinkArgList.add("dominant");
        }
        if (args.rec) {
            this.plinkArgList.add("recessive");
        }
        if (args.covar != null) {
            this.plinkArgList.add("--covar");
            this.plinkArgList.add(args.covar);
            if (args.cvs) {
                this.plinkArgList.add("--covar-variance-standardize");
            }
        } else {
            this.plinkArgList.add("allow-no-covars");
        }
        if (args.vs) {
            this.plinkArgList.add("--variance-standardize");
        }
        if (args.qn) {
            this.plinkArgList.add("--quantile-normalize");
        }
        this.plinkArgList.add("--out");
        this.plinkArgList.add(pgenPath);
        this.pgenPath = pgenPath;
    }

    private Thread sendProcessErrorStreamToStdErr(InputStream es, StringWriter stringWriter) {
        Thread t = new Thread(() -> {
            try {
                int r = es.read();
                while (r != -1) {
                    stringWriter.append((char)r);
                    r = es.read();
                }
                es.close();
            }
            catch (IOException e) {
                PrintWriter pw = new PrintWriter(stringWriter);
                e.printStackTrace(pw);
            }
        });
        t.start();
        return t;
    }

    private void cleanupCoreDump() {
        try {
            Files.list(this.projectRoot.toPath()).filter(path -> path.getFileName().toString().startsWith("core.")).filter(path -> {
                try {
                    BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                    int cmp = attr.creationTime().toInstant().compareTo(this.processStart);
                    return cmp >= 0;
                }
                catch (IOException iOException) {
                    return false;
                }
            }).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Boolean call() throws Exception {
        String[] reslines;
        ProcessBuilder pb = new ProcessBuilder(this.plinkArgList);
        pb.directory(this.projectRoot);
        Process p = pb.start();
        StringWriter processError = new StringWriter();
        try (InputStream is = p.getInputStream();){
            Thread esThread = this.sendProcessErrorStreamToStdErr(p.getErrorStream(), processError);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            reslines = (String[])br.lines().filter(l -> l.contains("Results written to")).map(l -> l.split(" ")[3].trim()).toArray(String[]::new);
            esThread.join(20000L);
        }
        boolean exited = p.waitFor(60L, TimeUnit.SECONDS);
        if (exited && p.exitValue() != 0) {
            this.cleanupCoreDump();
            String errorString = processError.getBuffer().toString();
            if (!errorString.contains("No variants")) {
                throw new GorResourceException(errorString, "plink2 exited with value " + p.exitValue());
            }
        }
        return this.writeResult(reslines, this.pgenPath);
    }

    private boolean writeResult(String[] reslines, String pgenPath) throws IOException {
        Path logpath;
        File pgenFile = new File(pgenPath + ".pgen");
        File pvarFile = new File(pgenPath + ".pvar");
        pgenFile.delete();
        pvarFile.delete();
        if (reslines.length > 0) {
            PriorityQueue<GORLine> pql = new PriorityQueue<GORLine>();
            for (String result : reslines) {
                Path p = Paths.get(result, new String[0]);
                String filename = p.getFileName().toString();
                int u = filename.indexOf(46);
                String phenotype = filename.substring(u + 1, filename.indexOf(46, u + 1));
                GORLine gl = new GORLine(phenotype, p);
                pql.add(gl);
            }
            for (String result : reslines) {
                Path path = Paths.get(result, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    Files.delete(path);
                }
                if (!Files.exists(path = Paths.get(result + ".id", new String[0]), new LinkOption[0])) continue;
                Files.delete(path);
            }
            this.ppa.sendLine(pql);
        }
        if (Files.exists(logpath = this.tmpPath.resolve(this.pgenPath + ".log"), new LinkOption[0])) {
            Files.delete(logpath);
        }
        return this.first;
    }
}

