/*
 * Decompiled with CFR 0.152.
 */
package gorsat.parser;

import gorsat.parser.CalcLambdaDouble;
import gorsat.parser.CalcLambdaDoubleConstant;
import gorsat.parser.CalcLambdaInteger;
import gorsat.parser.CalcLambdaLong;
import gorsat.parser.CalcLambdaLongConstant;
import gorsat.parser.CalcLambdaNumeric;
import gorsat.parser.CalcLambdaString;
import gorsat.parser.CalcLambdaVariable;
import gorsat.parser.Constant;
import gorsat.parser.FunctionTypes;
import gorsat.parser.IntegerType;
import gorsat.parser.Numeric;
import gorsat.parser.TypedCalcLambda;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.gor.model.ColumnValueProvider;

public class CalcLambdaIntegerConstant
extends CalcLambdaNumeric
implements IntegerType,
Constant {
    private int value;

    CalcLambdaIntegerConstant(int i) {
        this.value = i;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String getType() {
        return FunctionTypes.IntFun();
    }

    @Override
    public int evaluateInt(ColumnValueProvider columnValueProvider) {
        return this.value;
    }

    @Override
    public long evaluateLong(ColumnValueProvider cvp) {
        return this.value;
    }

    @Override
    public String evaluateString(ColumnValueProvider cvp) {
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public double evaluateDouble(ColumnValueProvider cvp) {
        return this.value;
    }

    @Override
    public boolean evaluateBoolean(ColumnValueProvider cvp) {
        throw new GorParsingException("Can't cast number to boolean");
    }

    @Override
    public TypedCalcLambda addedTo(TypedCalcLambda left) {
        return left.add(this.value);
    }

    @Override
    public TypedCalcLambda add(int other) {
        this.value += other;
        return this;
    }

    @Override
    public TypedCalcLambda add(long other) {
        return new CalcLambdaLongConstant((long)this.value + other);
    }

    @Override
    public TypedCalcLambda add(double other) {
        return new CalcLambdaDoubleConstant((double)this.value + other);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaVariable other) {
        return other.toLambda().addedTo(this);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaString other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda add(String other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda add(CalcLambdaInteger other) {
        return new CalcLambdaInteger(cvp -> this.value + other.evaluateInt(cvp));
    }

    @Override
    public TypedCalcLambda add(CalcLambdaLong other) {
        return new CalcLambdaLong(cvp -> (long)this.value + other.evaluateLong(cvp));
    }

    @Override
    public TypedCalcLambda add(CalcLambdaDouble other) {
        return new CalcLambdaDouble(cvp -> (double)this.value + other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda subtractedFrom(TypedCalcLambda other) {
        return other.subtract(this.value);
    }

    @Override
    public TypedCalcLambda subtract(int other) {
        this.value -= other;
        return this;
    }

    @Override
    public TypedCalcLambda subtract(long other) {
        return new CalcLambdaLongConstant((long)this.value - other);
    }

    @Override
    public TypedCalcLambda subtract(double other) {
        return new CalcLambdaDoubleConstant((double)this.value - other);
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaVariable other) {
        return other.toLambda().subtractedFrom(this);
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaInteger other) {
        return new CalcLambdaInteger(cvp -> this.value - other.evaluateInt(cvp));
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaLong other) {
        return new CalcLambdaLong(cvp -> (long)this.value - other.evaluateLong(cvp));
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaDouble other) {
        return new CalcLambdaDouble(cvp -> (double)this.value - other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda multipliedWith(TypedCalcLambda left) {
        return left.multiply(this.value);
    }

    @Override
    public TypedCalcLambda multiply(int other) {
        this.value *= other;
        return this;
    }

    @Override
    public TypedCalcLambda multiply(long other) {
        return new CalcLambdaLongConstant((long)this.value * other);
    }

    @Override
    public TypedCalcLambda multiply(double other) {
        return new CalcLambdaDoubleConstant((double)this.value * other);
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaVariable other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaInteger other) {
        return new CalcLambdaInteger(cvp -> this.value * other.evaluateInt(cvp));
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaLong other) {
        return new CalcLambdaLong(cvp -> (long)this.value * other.evaluateLong(cvp));
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaDouble other) {
        return new CalcLambdaDouble(cvp -> (double)this.value * other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda dividedInto(TypedCalcLambda left) {
        return left.divide(this.value);
    }

    @Override
    public TypedCalcLambda divide(int other) {
        if (this.value % other == 0) {
            this.value /= other;
            return this;
        }
        return new CalcLambdaDoubleConstant((double)this.value / (double)other);
    }

    @Override
    public TypedCalcLambda divide(long other) {
        return new CalcLambdaDoubleConstant((double)this.value / (double)other);
    }

    @Override
    public TypedCalcLambda divide(double other) {
        return new CalcLambdaDoubleConstant((double)this.value / other);
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaVariable other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaInteger other) {
        return new CalcLambdaDouble(cvp -> (double)this.value / other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaLong other) {
        return new CalcLambdaDouble(cvp -> (double)this.value / other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaDouble other) {
        return new CalcLambdaDouble(cvp -> (double)this.value / other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda pow(TypedCalcLambda o) {
        TypedCalcLambda other = o.toLambda();
        if (!(other instanceof Numeric)) {
            throw new GorParsingException("Number expected for ^ operator");
        }
        if (other instanceof CalcLambdaIntegerConstant) {
            this.value = (int)Math.pow(this.value, other.evaluateInt(null));
            return this;
        }
        if (other instanceof CalcLambdaLongConstant) {
            return new CalcLambdaLongConstant((long)Math.pow(this.value, other.evaluateLong(null)));
        }
        if (other instanceof CalcLambdaDoubleConstant) {
            return new CalcLambdaDoubleConstant(Math.pow(this.value, other.evaluateDouble(null)));
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda negate() {
        this.value = -this.value;
        return this;
    }
}

