/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.Iterators.SingleIteratorSource;
import gorsat.process.BaseStreamIterator;
import gorsat.process.GorStreamIterator;
import gorsat.process.NorStreamIterator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.driver.providers.db.DbScope;
import org.gorpipe.gor.model.DbSource;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.model.gor.iterators.RowSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GorJavaUtilities {
    private static final Logger log = LoggerFactory.getLogger(GorJavaUtilities.class);
    public static DecimalFormat fd3 = new DecimalFormat("#.###", DecimalFormatSymbols.getInstance(Locale.ROOT));
    public static double[] pArray = IntStream.range(0, 128).mapToDouble(qual -> 1.0 - (double)(qual - 33) / 93.0).toArray();
    public static String[] prArray = (String[])Arrays.stream(pArray).mapToObj(p -> fd3.format(p)).toArray(String[]::new);
    public static PRPRValue prprFunction = new PRPRValue();
    public static PRPRPRValue prprprFunction = new PRPRPRValue();

    public static Phenotypes getPhenotype(String pheno) throws IOException {
        Path p;
        Phenotypes pt = Phenotypes.BINARY;
        if (pheno != null && pheno.length() > 0 && Files.exists(p = Paths.get(pheno, new String[0]), new LinkOption[0])) {
            String[] common = Files.lines(p).skip(1L).map(s -> s.split("\t")).map(s -> Arrays.copyOfRange(s, 1, ((String[])s).length)).reduce((r1, r2) -> {
                for (int i = 0; i < ((String[])r1).length; ++i) {
                    try {
                        Integer.parseInt(r1[i]);
                        r1[i] = r2[i];
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return r1;
            }).get();
            pt = null;
            for (int i = 0; i < common.length; ++i) {
                try {
                    Integer.parseInt(common[i]);
                    if (pt == null) {
                        pt = Phenotypes.BINARY;
                        continue;
                    }
                    if (!pt.equals((Object)Phenotypes.QUANTITATIVE)) continue;
                    pt = Phenotypes.MIXED;
                    continue;
                }
                catch (NumberFormatException e) {
                    if (pt == null) {
                        pt = Phenotypes.QUANTITATIVE;
                        continue;
                    }
                    if (!pt.equals((Object)Phenotypes.BINARY)) continue;
                    pt = Phenotypes.MIXED;
                }
            }
        }
        return pt;
    }

    public static String clearHints(String query) {
        int i = query.indexOf("/*+");
        if (i != -1) {
            return query.substring(0, i) + query.substring(query.indexOf("*/", i + 3) + 2, query.length());
        }
        return query;
    }

    public static String[] splitResourceHints(String query, String validStart) {
        int i = ((String)query).indexOf("/*+");
        String[] ret = new String[]{query, null};
        if (i != -1) {
            int e = ((String)query).indexOf("*/", i + 3);
            String hints = ((String)query).substring(i + 3, e).trim();
            ArrayList resourceHints = new ArrayList();
            ArrayList sqlHints = new ArrayList();
            String[] hintSplit = hints.split("[ ]+");
            Arrays.asList(hintSplit).forEach(hint -> {
                if (hint.startsWith(validStart)) {
                    resourceHints.add(hint);
                } else {
                    sqlHints.add(hint);
                }
            });
            if (resourceHints.size() > 0) {
                ret[1] = String.join((CharSequence)" ", resourceHints);
            }
            query = sqlHints.size() == 0 ? ((String)query).substring(0, i) + ((String)query).substring(e + 2) : ((String)query).substring(0, i + 3) + String.join((CharSequence)" ", sqlHints) + ((String)query).substring(e);
            ret[0] = query;
        }
        return ret;
    }

    public static String createMapString(Map<String, String> createMap) {
        return createMap.entrySet().stream().map(e -> "create " + (String)e.getKey() + " = " + (String)e.getValue()).collect(Collectors.joining("; ", "", ""));
    }

    public static List<Row> stream2RowList(Stream<Row> str) {
        return str.collect(Collectors.toList());
    }

    public static String seekReplacement(String myCommand, String chr, int start, int stop) {
        int sPos = ((String)myCommand).indexOf("#(S:");
        if (sPos != -1) {
            int sEnd = ((String)myCommand).indexOf(41, sPos + 1);
            Object seek = "";
            if (chr != null) {
                seek = ((String)myCommand).substring(sPos + 4, sEnd).replace("chr", chr);
                int pos = ((String)seek).indexOf("pos-end");
                if (pos != -1) {
                    seek = ((String)seek).replace("pos", "" + (start + 1)).replace("end", "" + stop);
                } else if (((String)seek).contains("pos")) {
                    pos = ((String)seek).indexOf("pos-");
                    seek = stop == -1 ? ((String)seek).replace("pos", "" + start) : (start == stop && pos != -1 ? ((String)seek).replace("pos-", "" + start) : ((String)seek).replace("pos", start + "-") + stop);
                }
            }
            myCommand = ((String)myCommand).substring(0, sPos) + (String)seek + ((String)myCommand).substring(sEnd + 1);
        }
        return myCommand;
    }

    public static String projectReplacement(String myCommand, GorSession session) throws IOException {
        String projectRoot = session.getProjectContext().getRealProjectRoot();
        String requestId = session.getRequestId();
        String securityContext = session.getProjectContext().getFileReader().getSecurityContext();
        return GorJavaUtilities.projectReplacement(myCommand, projectRoot, requestId, securityContext);
    }

    public static String projectReplacement(String myCommand, String projectRoot, String requestId, String securityContext) throws IOException {
        myCommand = GorJavaUtilities.projectDataReplacement(projectRoot, myCommand);
        myCommand = GorJavaUtilities.requestIdReplacement(requestId, myCommand);
        myCommand = GorJavaUtilities.projectIdReplacement(securityContext, myCommand);
        return myCommand;
    }

    public static String projectDataReplacement(String projectRoot, String myCommand) throws IOException {
        Path rootPath;
        if (projectRoot != null && projectRoot.length() > 0 && Files.exists(rootPath = Paths.get(projectRoot, new String[0]), new LinkOption[0])) {
            Path dataPath;
            Path rootRealPath = rootPath.toRealPath(new LinkOption[0]);
            myCommand = myCommand.replace("#{projectroot}", rootRealPath.toString());
            Path cachePath = rootRealPath.resolve("cache/result_cache");
            if (Files.exists(cachePath, new LinkOption[0])) {
                Path cacheRealPath = cachePath.toRealPath(new LinkOption[0]).getParent();
                myCommand = myCommand.replace("#{projectcache}", cacheRealPath.toString());
            }
            if (Files.exists(dataPath = rootRealPath.resolve("source"), new LinkOption[0])) {
                Path dataRealPath = dataPath.toRealPath(new LinkOption[0]).getParent();
                myCommand = myCommand.replace("#{projectdata}", dataRealPath.toString());
            }
        }
        return myCommand;
    }

    private static String requestIdReplacement(String requestId, String myCommand) {
        if (requestId != null) {
            myCommand = myCommand.replace("#{requestid}", requestId);
        }
        return myCommand;
    }

    static String projectIdReplacement(String securityContext, String myCommand) {
        if (securityContext != null) {
            List dbScopes = DbScope.parse((String)securityContext);
            Integer projectIdValue = null;
            for (DbScope dbScope : dbScopes) {
                if (!dbScope.getColumn().equals("project_id")) continue;
                projectIdValue = (Integer)dbScope.getValue();
            }
            if (projectIdValue != null) {
                myCommand = myCommand.replace("#{projectid}", projectIdValue.toString());
            }
        }
        return myCommand;
    }

    public static RowSource getDbIteratorSource(String sqlQuery, boolean gortable, String source, boolean scoping) {
        Supplier<Stream<String>> streamSupplier = () -> DbSource.getDBLinkStream((String)("//db:" + sqlQuery), (Object[])new Object[0], (String)source);
        BaseStreamIterator its = gortable ? new GorStreamIterator(streamSupplier, scoping) : new NorStreamIterator(streamSupplier);
        return new SingleIteratorSource(its, "dbit");
    }

    public static Stream<String> wrapObjectArrayIterator(final Iterator<Object[]> iterator) {
        Iterator<String> theIterator = new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                Object[] data = (Object[])iterator.next();
                return Arrays.stream(data).map(x$0 -> GorJavaUtilities.nullSafeToString(x$0)).collect(Collectors.joining("\t"));
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(theIterator, 1024), false);
    }

    private static String nullSafeToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static Map<String, CmdParams> readWhiteList(Path cmdConfigPath) {
        HashMap<String, CmdParams> allowedCmds = new HashMap<String, CmdParams>();
        try {
            if (cmdConfigPath != null && Files.exists(cmdConfigPath, new LinkOption[0])) {
                List<String> lines = Files.readAllLines(cmdConfigPath);
                for (String line : lines) {
                    String[] split = line.split("\t");
                    if (split.length == 1) {
                        String[] stringArray;
                        int i = line.indexOf(91);
                        if (i > 0) {
                            String[] stringArray2 = new String[2];
                            stringArray2[0] = line.substring(0, i).trim();
                            stringArray = stringArray2;
                            stringArray2[1] = line.substring(i);
                        } else {
                            stringArray = split = null;
                        }
                    }
                    if (split == null) continue;
                    String cmd = split[1].substring(1, split[1].length() - 1);
                    CmdParams cmdParams = new CmdParams(split[0].split("[ ]+"), cmd);
                    allowedCmds.put(cmdParams.getAliasName(), cmdParams);
                }
            }
        }
        catch (IOException ioe) {
            throw new GorSystemException("Failed to load white listed commands.", (Throwable)ioe);
        }
        return allowedCmds;
    }

    public static Map<String, CmdParams> readWhiteList(String cmdConfigFile) throws IOException {
        if (cmdConfigFile != null) {
            Path p = Paths.get(cmdConfigFile, new String[0]);
            return GorJavaUtilities.readWhiteList(p);
        }
        return new HashMap<String, CmdParams>();
    }

    public static Path resolveWhiteListFilePath(String whiteListFile, Path projectRoot) {
        if (whiteListFile == null || whiteListFile.isEmpty()) {
            throw new GorSystemException("Can not resolve empty white list file path", null);
        }
        Path whiteListPath = Paths.get(whiteListFile, new String[0]);
        if (whiteListPath.isAbsolute()) {
            return whiteListPath;
        }
        if (projectRoot != null) {
            return projectRoot.resolve(whiteListFile);
        }
        log.warn("Whitelist file {} is relative but no project root is defined!", (Object)whiteListFile);
        return whiteListPath;
    }

    public static Optional<String> getIgnoreCase(Collection<String> c, String str) {
        return c.stream().filter(s -> s.equalsIgnoreCase(str)).findFirst();
    }

    public static String[] toUppercase(Collection<String> c) {
        return (String[])c.stream().map(String::toUpperCase).toArray(String[]::new);
    }

    public static String[] mergeArrays(String[] array1, String[] array2) {
        return (String[])Stream.concat(Arrays.stream(array1), Arrays.stream(array2)).toArray(String[]::new);
    }

    public static class CmdParams {
        String[] cmdParams;
        String command;

        CmdParams(String[] cmdParams, String command) {
            this.cmdParams = cmdParams;
            this.command = command;
        }

        public String getAliasName() {
            return this.cmdParams[0];
        }

        public String getCmdPath() {
            return this.command.split("[ ]+")[0];
        }

        public String getCommand() {
            return this.command;
        }

        public Optional<String> getType() {
            return Arrays.stream(this.cmdParams).skip(1L).filter(e -> e.startsWith("-s")).map(e -> e.substring(2)).findFirst();
        }

        public boolean isNor() {
            return Arrays.stream(this.cmdParams).skip(1L).anyMatch(e -> e.equals("-n"));
        }

        public boolean isFormula() {
            return Arrays.stream(this.cmdParams).skip(1L).anyMatch(e -> e.equals("-c"));
        }

        public boolean skipHeader() {
            return Arrays.stream(this.cmdParams).skip(1L).anyMatch(e -> e.equals("-h"));
        }

        public boolean useProcessMethod() {
            return Arrays.stream(this.cmdParams).skip(1L).anyMatch(e -> e.equals("-p"));
        }

        public boolean useHttpServer() {
            return Arrays.stream(this.cmdParams).skip(1L).anyMatch(e -> e.equals("-u"));
        }

        public Optional<String> skipLines() {
            return Arrays.stream(this.cmdParams).skip(1L).filter(p -> p.startsWith("-s")).findFirst().map(p -> p.substring(2));
        }

        public boolean allowError() {
            return Arrays.stream(this.cmdParams).skip(1L).anyMatch(e -> e.equals("-e"));
        }
    }

    public static class VCFValue
    extends PRPRValue {
        double threshold;

        public VCFValue(double threshold) {
            super(',');
            this.threshold = threshold;
        }

        private String getGT(int c1, int c2) {
            double p1 = pArray[c1];
            double p2 = pArray[c2];
            double p0 = Math.abs(1.0 - p1 - p2);
            String gp = prprprFunction.get(c1, c2);
            if (p0 > this.threshold) {
                return "\t0/0:" + gp;
            }
            if (p1 > this.threshold) {
                return "\t0/1:" + gp;
            }
            if (p2 > this.threshold) {
                return "\t1/1:" + gp;
            }
            return "\t./.:" + gp;
        }

        @Override
        public String get(int c1, int c2) {
            if (c1 == 32) {
                return "\t./.:0" + this.sep + "0" + this.sep + "0";
            }
            if (this.prprArray == null) {
                this.prprArray = (String[][])IntStream.range(0, 128).mapToObj(i -> (String[])IntStream.range(0, 128).mapToObj(k -> this.getGT(i, k)).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
            }
            return this.prprArray[c1][c2];
        }
    }

    public static class PRPRPRValue
    extends PRPRValue {
        PRPRPRValue() {
        }

        @Override
        public String get(int c1, int c2) {
            if (this.prprArray == null) {
                this.prprArray = (String[][])IntStream.range(0, 128).mapToObj(i -> (String[])IntStream.range(0, 128).mapToObj(k -> fd3.format(Math.abs(1.0 - pArray[i] - pArray[k])) + this.sep + prArray[i] + this.sep + prArray[k]).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
            }
            return this.prprArray[c1][c2];
        }
    }

    public static enum Phenotypes {
        BINARY,
        QUANTITATIVE,
        MIXED;

    }

    public static class PRPRValue {
        String[][] prprArray;
        char sep;

        PRPRValue() {
            this(';');
        }

        PRPRValue(char sep) {
            this.sep = sep;
        }

        public String get(int c1, int c2) {
            if (this.prprArray == null) {
                this.prprArray = (String[][])IntStream.range(0, 128).mapToObj(i -> (String[])IntStream.range(0, 128).mapToObj(k -> prArray[i] + this.sep + prArray[k]).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
            }
            return this.prprArray[c1][c2];
        }
    }
}

