/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.Commands.Analysis;
import gorsat.Commands.CommandParseUtilities;
import gorsat.process.PipeInstance;
import gorsat.process.ProcessRowSource;
import io.kubernetes.client.openapi.ApiException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gorpipe.exceptions.GorDataException;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.session.GorContext;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.model.gor.RowObj;
import org.gorpipe.model.gor.iterators.RowSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessIteratorAdaptor
extends RowSource
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ProcessIteratorAdaptor.class);
    private static final Pattern pattern = Pattern.compile("'(?:[^']|'')+'|[^ ]+");
    static String norprefix = "chrN\t0\t";
    static String norheaderprefix = "ChromNOR\tPosNOR\t";
    static int norprefixlength = norprefix.length();
    static int norheaderprefixlength = norheaderprefix.length();
    private boolean mustReCheck = true;
    private boolean myHasNext = true;
    private final BufferedReader breader;
    private final Process proc;
    final InputStream is;
    private final boolean skipheader;
    private final boolean nor;
    private String processName;
    private final StringBuilder errorStr = new StringBuilder();
    private final boolean allowerror;
    private final Iterator<Row> rowSource;
    private final OutThread outThread;
    private String line;

    public ProcessIteratorAdaptor(GorContext context, String cmd, String alias, Iterator<Row> rs, Analysis an, String header, boolean skipheader, Optional<String> skip, boolean allowerror, boolean nor) throws IOException, ApiException {
        ProcessAdaptor processPipeStep;
        ProcessAdaptor processAdaptor;
        this.skipheader = skipheader;
        this.nor = nor;
        this.allowerror = allowerror;
        this.rowSource = rs;
        this.setHeader(header);
        ArrayList<String> commands = new ArrayList<String>();
        Path fileRoot = ProcessIteratorAdaptor.getFileRoot(context.getSession());
        List<String> splitcmd = ProcessIteratorAdaptor.commandSplit(fileRoot, cmd);
        for (String scmd : splitcmd) {
            String ncmd = ProcessRowSource.checkNested(scmd, context.getSession(), this.errorStr);
            commands.add(ncmd);
        }
        this.processName = alias + ": [" + String.join((CharSequence)" ", commands) + "]";
        ProcessBuilder pb = new ProcessBuilder(commands);
        if (fileRoot != null) {
            pb.directory(fileRoot.toFile());
        }
        this.proc = pb.start();
        InputStream es = this.proc.getErrorStream();
        this.startReadStdErrThread(es);
        this.is = this.proc.getInputStream();
        this.breader = new BufferedReader(new InputStreamReader(this.is));
        OutputStream os = this.proc.getOutputStream();
        ProcessAdaptor processAdaptor2 = processAdaptor = nor ? new NorProcessAdaptor(os) : new ProcessAdaptor(os);
        if (an != null) {
            an = PipeInstance.injectTypeInferral(an, false);
            processPipeStep = an.$bar((Analysis)processAdaptor);
        } else {
            processPipeStep = processAdaptor;
        }
        processAdaptor.setProcessPipeStep(processPipeStep);
        processPipeStep.securedSetup(null);
        this.outThread = new OutThread(rs, processPipeStep, os, header);
        this.outThread.start();
        if (skip.isPresent()) {
            String skipstr = skip.get();
            try {
                int skipnum = Integer.parseInt(skipstr);
                for (int i = 0; i < skipnum; ++i) {
                    this.breader.readLine();
                }
            }
            catch (NumberFormatException e) {
                String line = this.breader.readLine();
                while (line != null && line.startsWith(skipstr)) {
                    line = this.breader.readLine();
                }
                this.mustReCheck = false;
                boolean bl = this.myHasNext = line != null;
            }
        }
        if (!skipheader) {
            this.processHeader(nor, os);
        }
    }

    private void processHeader(boolean nor, OutputStream os) throws IOException {
        this.setHeader(this.line != null ? this.line : this.breader.readLine());
        while (this.getHeader() != null && (this.getHeader().length() == 0 || this.getHeader().startsWith("WARNING"))) {
            this.setHeader(this.breader.readLine());
        }
        if (this.getHeader() == null) {
            String newline = this.breader.readLine();
            this.proc.destroy();
            Exception ie = null;
            try {
                this.breader.close();
                os.close();
                this.proc.waitFor();
            }
            catch (Exception e) {
                ie = e;
            }
            String error = "newline " + newline + "; " + this.errorStr + "; exitValue=" + this.proc.exitValue();
            if (ie != null) {
                throw new GorSystemException(error, (Throwable)ie);
            }
            throw new GorSystemException(error, null);
        }
        if (nor) {
            this.setHeader(norheaderprefix + this.getHeader());
        }
    }

    private void startReadStdErrThread(InputStream es) {
        Thread readStdErrThread = new Thread(() -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int r = es.read();
                while (r != -1) {
                    baos.write(r);
                    r = es.read();
                }
                es.close();
                baos.close();
                String stderr = baos.toString();
                if (stderr.length() > 0) {
                    this.errorStr.append(stderr);
                    log.trace("stderr from external process " + this.processName + ": " + stderr);
                }
            }
            catch (IOException e) {
                throw new GorSystemException("Error reading stderr from external process", (Throwable)e);
            }
        });
        readStdErrThread.setDaemon(true);
        readStdErrThread.start();
    }

    public boolean hasNext() {
        if (!this.mustReCheck) {
            return this.myHasNext;
        }
        try {
            this.line = this.breader.readLine();
            this.myHasNext = this.line != null;
        }
        catch (IOException e) {
            throw new GorSystemException("unable to read from process", (Throwable)e);
        }
        this.mustReCheck = false;
        if (this.outThread.hasError()) {
            throw new GorSystemException("Error in process out thread ", this.outThread.getException());
        }
        return this.myHasNext;
    }

    public Row next() {
        if (this.hasNext()) {
            Row myNext;
            this.mustReCheck = true;
            try {
                myNext = this.nor ? RowObj.StoR((CharSequence)(norprefix + this.line)) : RowObj.StoR((CharSequence)this.line);
            }
            catch (ArrayIndexOutOfBoundsException ae) {
                throw new GorDataException("external process " + this.processName + "returned illegal line.", -1, this.line, this.getHeader(), (Throwable)ae);
            }
            return myNext;
        }
        return null;
    }

    public void setPosition(String seekChr, int seekPos) {
        this.mustReCheck = true;
        if (this.rowSource instanceof RowSource) {
            ((RowSource)this.rowSource).setPosition(seekChr, seekPos);
        }
    }

    public void close() {
        this.mustReCheck = true;
        int exitValue = 0;
        if (this.proc.isAlive()) {
            this.proc.destroy();
        } else {
            exitValue = this.proc.exitValue();
        }
        if (exitValue != 0) {
            String errMsg;
            String string = errMsg = this.errorStr == null || this.errorStr.length() == 0 ? this.getHeader() : this.errorStr.toString();
            if (this.allowerror) {
                log.trace("Allowed external process " + this.processName + " with non-zero exit code: " + errMsg);
            } else {
                throw new GorSystemException("External process " + this.processName + " exited with non-zero exit code (" + exitValue + "): " + errMsg, null);
            }
        }
    }

    public boolean isBuffered() {
        return true;
    }

    private static Path getFileRoot(GorSession session) {
        String root;
        Path fileRoot = null;
        if (session != null && (root = session.getProjectContext().getRoot()) != null && root.length() > 0) {
            int i = root.indexOf(32);
            if (i == -1) {
                i = root.length();
            }
            fileRoot = Paths.get(root.substring(0, i), new String[0]);
        }
        return fileRoot;
    }

    static List<String> commandSplit(Path fileRoot, String cmd) {
        String[] cmds = CommandParseUtilities.quoteSafeSplit((String)cmd, (char)' ');
        ArrayList<String> split = new ArrayList<String>();
        for (String scmd : cmds) {
            ProcessIteratorAdaptor.subCommandSplit(fileRoot, scmd, split);
        }
        return split;
    }

    public static void subCommandSplit(Path fileRoot, String subCommand, List<String> split) {
        if (subCommand.startsWith("<(")) {
            split.add(subCommand);
        } else {
            Matcher matcher = pattern.matcher(subCommand);
            boolean found = matcher.find();
            while (found) {
                String match = matcher.group();
                if (match.startsWith("'")) {
                    split.add(match.substring(1, match.length() - 1));
                } else {
                    boolean isFile;
                    boolean bl = isFile = match.contains("/") || match.endsWith(".R") || match.endsWith(".py") || match.endsWith(".sh") || match.endsWith(".gor") || match.endsWith("gorz") || match.endsWith(".txt");
                    if (isFile) {
                        Path fmatch = fileRoot != null && !match.startsWith("/") ? fileRoot.resolve(match) : Paths.get(match, new String[0]);
                        if (split.size() == 0 && Files.exists(fmatch, new LinkOption[0])) {
                            fmatch.toFile().setExecutable(true);
                        }
                    }
                    split.add(match);
                }
                found = matcher.find();
            }
        }
    }

    private class OutThread
    extends Thread {
        private final Iterator<Row> rs;
        private final Analysis processPipeStep;
        private final OutputStream os;
        private Throwable th = null;
        private final String header;

        OutThread(Iterator<Row> rs, Analysis processPipeStep, OutputStream os, String header) {
            this.rs = rs;
            this.processPipeStep = processPipeStep;
            this.os = os;
            this.header = header;
        }

        boolean hasError() {
            return this.th != null;
        }

        public Throwable getException() {
            return this.th;
        }

        void writeOutput() {
            try {
                while (this.rs.hasNext() && !this.processPipeStep.wantsNoMore()) {
                    Row row = this.rs.next();
                    this.processPipeStep.process(row);
                }
            }
            finally {
                if (this.rs instanceof RowSource) {
                    ((RowSource)this.rs).close();
                }
            }
        }

        @Override
        public void run() {
            try {
                if (!ProcessIteratorAdaptor.this.skipheader) {
                    String hdr = ProcessIteratorAdaptor.this.nor ? "#" + this.header.substring(norheaderprefixlength) : this.header;
                    this.os.write(hdr.getBytes());
                    this.os.write(10);
                    this.os.flush();
                }
                this.writeOutput();
            }
            catch (IOException ie) {
                if (!ie.getMessage().contains("Stream closed")) {
                    this.th = ie;
                }
            }
            catch (Exception e) {
                this.th = e;
            }
            finally {
                this.processPipeStep.securedFinish(this.th);
            }
            if (!ProcessIteratorAdaptor.this.proc.isAlive() && ProcessIteratorAdaptor.this.proc.exitValue() != 0) {
                this.th = new GorSystemException("Non zero exit value from OutThread " + ProcessIteratorAdaptor.this.proc.exitValue(), this.th);
            }
        }
    }

    class NorProcessAdaptor
    extends ProcessAdaptor {
        NorProcessAdaptor(OutputStream os) {
            super(os);
        }

        @Override
        public void process(Row row) {
            try {
                if (!this.wantsNoMore()) {
                    String rowstr = row.toString();
                    rowstr = rowstr.substring(norprefixlength);
                    this.os.write(rowstr.getBytes());
                    this.os.write(10);
                } else {
                    this.pps.wantsNoMore_$eq(true);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class ProcessAdaptor
    extends Analysis {
        OutputStream os;
        Analysis pps;

        ProcessAdaptor(OutputStream os) {
            this.os = os;
        }

        void setProcessPipeStep(Analysis pps) {
            this.pps = pps;
        }

        public void process(Row row) {
            try {
                if (!this.wantsNoMore()) {
                    String rowstr = row.toString();
                    this.os.write(rowstr.getBytes());
                    this.os.write(10);
                } else {
                    this.pps.wantsNoMore_$eq(true);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void finish() {
            try {
                this.os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

