/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.gorpipe.gor.driver.GorDriver;
import org.gorpipe.gor.driver.GorDriverFactory;
import org.gorpipe.gor.driver.meta.SourceReferenceBuilder;
import org.gorpipe.gor.model.GenomicIterator;
import org.gorpipe.gor.model.Line;

public class GorBench {
    String[] chrNames = new String[]{"chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8", "chr9", "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21", "chr22", "chrX", "chrY"};
    int[] chrBases = new int[]{249250621, 243199373, 198022430, 191154276, 180915260, 171115067, 159138663, 146364022, 141213431, 135534747, 135006516, 133851895, 115169878, 107349540, 102531392, 90354753, 81195210, 78077248, 59128983, 63025520, 48129895, 51304566, 155270560, 59373566};
    String[] files;
    int seeks;
    int readBases;
    List<BenchmarkThread> threads = new ArrayList<BenchmarkThread>();
    GorDriver gorDriver;
    long totalTimeMs = 0L;
    long totalSeekNanos = 0L;
    long elapsedMs = 0L;
    String label;
    private boolean newSource;
    private String subset;
    Integer fixedIndex;
    long actualLines;

    public GorBench(String label, String[] files, int seeks, int readBases) {
        this.label = label;
        this.files = files;
        this.seeks = seeks;
        this.readBases = readBases;
        this.gorDriver = GorDriverFactory.fromConfig();
    }

    public void run() throws InterruptedException {
        if (this.subset != null) {
            for (int i = 0; i < this.chrNames.length; ++i) {
                if (!this.chrNames[i].equals(this.subset)) continue;
                this.fixedIndex = i;
                break;
            }
            if (this.fixedIndex == null) {
                throw new IllegalArgumentException("Illegal subset: " + this.subset + " expected one of chr1-chr22,chrX or chrY");
            }
        }
        long startTime = System.currentTimeMillis();
        for (String file : this.files) {
            BenchmarkThread thread = new BenchmarkThread(file);
            thread.start();
            this.threads.add(thread);
        }
        System.err.println("All threads started");
        for (BenchmarkThread thread : this.threads) {
            thread.join();
            this.totalTimeMs += thread.elapsedMs;
            this.totalSeekNanos += thread.seekNanos;
            this.actualLines += thread.actualLines;
        }
        this.elapsedMs = System.currentTimeMillis() - startTime;
        String format = "%s\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\n";
        System.out.println("#Label\tFileCount\tSeekCount\tThreads\tLinesPerSeek\tActualLines\tElapsedMs\tAccumMs\tAccumSeekMs");
        System.out.format(format, this.label, this.files.length, this.seeks, this.threads.size(), this.readBases, this.actualLines, this.elapsedMs, this.totalTimeMs, this.totalSeekNanos / 1000000L);
    }

    private static void help(String extraMessage) {
        if (extraMessage != null) {
            System.err.println(extraMessage);
        }
        System.err.println("Usage: gorbench [-n] [-s subset] <label> <seeks> <lines> <files ...>\n\nStarts a thead per file and repeatedly seeks and reads\n-n: If set, will request a new source for each seek\n-s: Can be used to specify subset (chromosome) - will request subset and only seek within that\nlabel: Label this run (will appear in output)\nseeks: How many seeks to perform per file (use 0 to open file once at beginning)\nlines: How many lines to read after each seek\n\nfiles: Any number of file paths/urls supporte by the gor driver\n");
        System.exit(-1);
    }

    private void setNewSourceOnSeek(boolean newSource) {
        this.newSource = newSource;
    }

    private void setSubset(String subset) {
        this.subset = subset;
    }

    public static void main(String[] args) throws InterruptedException {
        try {
            boolean newSource = false;
            String subset = null;
            while (args[0].startsWith("-")) {
                if (args[0].equals("-n")) {
                    newSource = true;
                    args = Arrays.copyOfRange(args, 1, args.length);
                    continue;
                }
                if (args[0].equals("-s")) {
                    subset = args[1];
                    args = Arrays.copyOfRange(args, 2, args.length);
                    continue;
                }
                GorBench.help("Illegal option " + args[0]);
            }
            String[] files = Arrays.copyOfRange(args, 3, args.length);
            GorBench bench = new GorBench(args[0], files, Integer.parseInt(args[1]), Integer.parseInt(args[2]));
            bench.setNewSourceOnSeek(newSource);
            bench.setSubset(subset);
            bench.run();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            GorBench.help(e.getMessage());
        }
    }

    class BenchmarkThread
    extends Thread {
        String file;
        long elapsedMs;
        Random random;
        long seekNanos = 0L;
        long actualLines;
        Line line = new Line(100);

        public BenchmarkThread(String file) {
            this.file = file;
            this.random = new Random();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime;
                block11: {
                    startTime = System.currentTimeMillis();
                    try (GenomicIterator iter = null;){
                        iter = GorBench.this.gorDriver.createIterator(new SourceReferenceBuilder(this.file).chrSubset(GorBench.this.subset).build());
                        if (GorBench.this.seeks == 0) {
                            for (int j = 0; j < GorBench.this.readBases - 1; ++j) {
                                if (!iter.next(this.line)) {
                                    break block11;
                                }
                                ++this.actualLines;
                            }
                            break block11;
                        }
                        for (int i = 0; i < GorBench.this.seeks; ++i) {
                            int chromIndex = GorBench.this.fixedIndex != null ? GorBench.this.fixedIndex.intValue() : this.random.nextInt(GorBench.this.chrNames.length);
                            String chrom = GorBench.this.chrNames[chromIndex];
                            int pos = this.random.nextInt(GorBench.this.chrBases[chromIndex] - 10 * GorBench.this.readBases);
                            long seekStart = System.nanoTime();
                            iter.seek(chrom, pos);
                            iter.next(this.line);
                            this.seekNanos += System.nanoTime() - seekStart;
                            for (int j = 0; j < GorBench.this.readBases - 1 && iter.next(this.line); ++j) {
                                ++this.actualLines;
                            }
                            if (!GorBench.this.newSource) continue;
                            iter.close();
                            iter = GorBench.this.gorDriver.createIterator(new SourceReferenceBuilder(this.file).chrSubset(GorBench.this.subset).build());
                        }
                    }
                }
                this.elapsedMs = System.currentTimeMillis() - startTime;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

