/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.gorpipe.gor.driver.DataSource;
import org.gorpipe.gor.driver.GorDriver;
import org.gorpipe.gor.driver.GorDriverFactory;
import org.gorpipe.gor.driver.meta.DataType;
import org.gorpipe.gor.driver.meta.SourceMetadata;
import org.gorpipe.gor.driver.meta.SourceReference;

public class GorMeta {
    private final String file;
    private final boolean followLink;
    private final GorDriver gorDriver;

    public GorMeta(String file, boolean followLink) {
        this.file = file;
        this.followLink = followLink;
        this.gorDriver = GorDriverFactory.fromConfig();
    }

    public int report(PrintStream out) throws IOException {
        DataSource source = this.gorDriver.resolveDataSource(new SourceReference(this.file));
        if (source == null) {
            out.println("Unknown data source " + this.file);
            return -1;
        }
        while (this.followLink && source.getDataType() == DataType.LINK) {
            String linksTo = GorDriverFactory.fromConfig().readLink(source);
            source.close();
            source = this.gorDriver.resolveDataSource(new SourceReference(linksTo));
        }
        SourceMetadata meta = source.getSourceMetadata();
        Map map = meta.attributes();
        for (String key : map.keySet()) {
            out.println(key + ": " + (String)map.get(key));
        }
        source.close();
        return 0;
    }

    public static void main(String[] args) throws IOException {
        String file;
        boolean followLink = true;
        if (args.length == 0 || args.length > 2) {
            GorMeta.help();
        }
        if (args.length == 1) {
            file = args[0];
        } else {
            if (args[0].equalsIgnoreCase("-l")) {
                followLink = false;
            } else {
                GorMeta.help();
            }
            file = args[1];
        }
        System.exit(new GorMeta(file, followLink).report(System.out));
    }

    private static void help() {
        System.err.println("Usage: gormeta [-l] <file>\n\nShows Gor Driver meta information for a file/url\nFollows .link files unless -l flag is given\nExample: gormeta .. file.bam");
        System.exit(-1);
    }
}

