/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.index;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.cli.HelpOptions;
import org.gorpipe.gor.driver.GorDriverFactory;
import org.gorpipe.gor.driver.meta.SourceReferenceBuilder;
import org.gorpipe.gor.driver.providers.stream.sources.StreamSource;
import picocli.CommandLine;

@CommandLine.Command(name="index", aliases={"i"}, description={"Index gor data files"}, header={"Index gor data files"})
public class IndexCommand
extends HelpOptions
implements Runnable {
    @CommandLine.Option(names={"-f", "--fullindex"}, description={"Performs a full index of gor file."})
    private boolean performFullIndex;
    @CommandLine.Parameters(arity="1..*", paramLabel="Files", description={"Queries to execute. Queries can be direct gor query, files containing gor script or gor report template."})
    private File[] files;
    private long pos = 0L;
    private final byte[] buffer = new byte[10000000];
    private int r = 0;
    private int i = 0;
    private int lastOffset;
    private boolean lastwritten = false;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private ByteArrayOutputStream lastbaos = null;

    private boolean byteArrayEquals(byte[] b1, byte[] b2, int len) {
        for (int j = 0; j < len; ++j) {
            if (b1[j] == b2[j]) continue;
            return false;
        }
        return true;
    }

    private void writeUntil(ByteArrayOutputStream baos, InputStream is, char charToFind) throws IOException {
        while (this.i < this.r && this.buffer[this.i] != charToFind) {
            ++this.i;
        }
        while (this.r > 0 && this.i == this.r) {
            baos.write(this.buffer, this.lastOffset, this.i - this.lastOffset);
            this.lastOffset = this.i + 1;
            this.pos += (long)this.r;
            this.r = is.read(this.buffer);
            this.i = 0;
            while (this.i < this.r && this.buffer[this.i] != charToFind) {
                ++this.i;
            }
        }
        ++this.i;
        if (this.r > 0) {
            if (this.lastOffset < this.buffer.length) {
                baos.write(this.buffer, this.lastOffset, this.i - this.lastOffset);
            } else {
                baos.write(charToFind);
            }
        }
    }

    private void skipUntil(InputStream is, char charToFind) throws IOException {
        while (this.i < this.r && this.buffer[this.i] != charToFind) {
            ++this.i;
        }
        while (this.r > 0 && this.i == this.r) {
            this.pos += (long)this.r;
            this.r = is.read(this.buffer);
            this.i = 0;
            while (this.i < this.r && this.buffer[this.i] != charToFind) {
                ++this.i;
            }
        }
        ++this.i;
    }

    private ByteArrayOutputStream writeBufferToFile(OutputStream fos) throws IOException {
        if (this.performFullIndex) {
            fos.write(this.baos.toByteArray());
        } else if (this.lastbaos == null) {
            fos.write(this.baos.toByteArray());
            this.lastbaos = this.baos;
            this.baos = new ByteArrayOutputStream();
        } else {
            int k;
            int o;
            byte[] tbuffer = this.baos.toByteArray();
            for (o = 0; o < tbuffer.length && tbuffer[o] != 9; ++o) {
            }
            if (o == tbuffer.length) {
                o = -1;
            }
            byte[] lastbuffer = this.lastbaos.toByteArray();
            for (k = 0; k < lastbuffer.length && lastbuffer[k] != 9; ++k) {
            }
            if (k == lastbuffer.length) {
                k = -1;
            }
            if (k == -1 || k != o || !this.byteArrayEquals(tbuffer, lastbuffer, k)) {
                if (!this.lastwritten) {
                    fos.write(lastbuffer);
                }
                fos.write(tbuffer);
                this.lastwritten = true;
            } else {
                this.lastwritten = false;
            }
            ByteArrayOutputStream nbaos = this.lastbaos;
            this.lastbaos = this.baos;
            this.baos = nbaos;
        }
        this.baos.reset();
        return this.lastbaos;
    }

    private void indexFile(File gorFile) {
        Path gorindex = Paths.get(gorFile.toString() + ".gori", new String[0]);
        try (StreamSource ds = (StreamSource)GorDriverFactory.fromConfig().resolveDataSource(new SourceReferenceBuilder(gorFile.toString()).build());
             InputStream is = ds.open();
             OutputStream fos = Files.newOutputStream(gorindex, new OpenOption[0]);){
            fos.write("## fileformat=GORIv1\n".getBytes());
            while (this.i == this.r) {
                this.pos += (long)this.r;
                this.r = is.read(this.buffer);
                this.i = 0;
                while (this.i < this.r && this.buffer[this.i] != 10) {
                    ++this.i;
                }
            }
            ++this.i;
            this.lastOffset = this.i;
            while (this.r > 0) {
                this.writeBufferToFile(fos);
                this.writeUntil(this.baos, is, '\t');
                this.lastOffset = this.i;
                this.writeUntil(this.baos, is, '\t');
                this.skipUntil(is, '\n');
                this.lastOffset = this.i;
                long totalOffset = this.pos + (long)this.lastOffset;
                if (this.r <= 0) continue;
                byte[] bytes = (totalOffset + "\n").getBytes();
                this.baos.write(bytes);
            }
            if (!this.lastwritten && this.lastbaos != null) {
                fos.write(this.lastbaos.toByteArray());
            }
            fos.write(this.baos.toByteArray());
        }
        catch (IOException e) {
            throw new GorSystemException("gor file index failed", (Throwable)e);
        }
    }

    @Override
    public void run() {
        for (File file : this.files) {
            this.indexFile(file);
        }
    }
}

