/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.manager;

import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.gorpipe.gor.cli.manager.CommandBucketizeOptions;
import org.gorpipe.gor.manager.TableManager;
import picocli.CommandLine;

@CommandLine.Command(name="bucketize", aliases={"b"}, description={"Bucketize dictionary/table."}, header={"Bucketize dictionary/table."})
public class BucketizeCommand
extends CommandBucketizeOptions
implements Runnable {
    @CommandLine.Option(names={"-d", "--bucket_dirs"}, split=",", description={"Directories to put the bucket files in, either absolute path or relative to the table dir.  The directories must exists and be writable.  Values are specified as comma separated list.  Dafault: .<table name>.buckets"})
    private List<String> bucketDirs = new ArrayList<String>();
    @CommandLine.Option(names={"--max_bucket_count"}, description={"Maximum number of buckets created in this call to bucketize.  No limit if less than 0. Default: 3"})
    private int maxBucketCount = 3;

    @Override
    public void run() {
        TableManager tm = TableManager.newBuilder().minBucketSize(this.minBucketSize).bucketSize(this.bucketSize).useHistory(!this.nohistory).lockTimeout(Duration.ofSeconds(this.lockTimeout)).build();
        tm.bucketize(this.dictionaryFile.toPath(), this.bucketPackLevel, this.workers, this.maxBucketCount, this.bucketDirs.stream().map(b -> Paths.get(b, new String[0])).collect(Collectors.toList()));
    }
}

