/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.manager;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.gorpipe.gor.cli.manager.FilterOptions;
import org.gorpipe.gor.manager.TableManager;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.BucketableTableEntry;
import picocli.CommandLine;

@CommandLine.Command(name="select", aliases={"s"}, description={"Looks up entries in a table or dictionary."}, header={"Look up entries in a table or dictionary."})
public class SelectCommand
extends FilterOptions
implements Runnable {
    @CommandLine.Parameters(index="1..*", arity="0..*", paramLabel="FILE", description={"List of files to delete, given as absolute path or relative to the table dir.  Values are specified as comma separated list.  Alternative to using -f."})
    private List<String> inputFiles = new ArrayList<String>();

    @Override
    public void run() {
        String[] allFiles = (String[])ArrayUtils.addAll((Object[])this.inputFiles.toArray(new String[0]), (Object[])this.files.toArray(new String[0]));
        String[] allTags = (String[])ArrayUtils.addAll((Object[])this.aliases.toArray(new String[0]), (Object[])this.tags.toArray(new String[0]));
        TableManager tm = TableManager.newBuilder().useHistory(!this.nohistory).lockTimeout(Duration.ofSeconds(this.lockTimeout)).build();
        BaseTable table = tm.initTable(this.dictionaryFile.toPath());
        List lines = table.filter().files((String[])(allFiles.length > 0 ? allFiles : null)).tags((String[])(allTags.length > 0 ? allTags : null)).buckets(this.buckets.size() > 0 ? this.buckets.toArray(new String[0]) : null).chrRange(this.range).includeDeleted(this.includeDeleted).get();
        for (BucketableTableEntry line : lines) {
            System.out.print(line.formatEntry());
        }
    }
}

