/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.render;

import gorsat.Commands.CommandParseUtilities;
import gorsat.process.CLISessionFactory;
import gorsat.process.PipeOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.gorpipe.gor.cli.render.RenderOptions;
import org.gorpipe.gor.cli.render.ReportCommand;
import org.gorpipe.gor.session.GorSession;
import picocli.CommandLine;

@CommandLine.Command(name="script", aliases={"s"}, header={"Renders gor script"}, description={"Renders gor script to its final executable form"})
public class ScriptCommand
extends RenderOptions
implements Runnable {
    @Override
    public void run() {
        String[] stringArray;
        File scriptFile = new File(this.input);
        String query = this.input;
        if (scriptFile.exists()) {
            try {
                query = FileUtils.readFileToString((File)scriptFile, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                System.err.println("Failed to load script file: " + this.input);
                System.exit(-1);
            }
        }
        query = CommandParseUtilities.cleanupQuery((String)query);
        if (this.aliasFile != null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = this.input;
            stringArray2[1] = "-alias";
            stringArray = stringArray2;
            stringArray2[2] = this.aliasFile.toString();
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this.input;
        }
        PipeOptions options = PipeOptions.parseInputArguments(stringArray);
        CLISessionFactory sessionFactory = new CLISessionFactory(options, "");
        GorSession session = sessionFactory.create();
        ReportCommand.renderQuery(session, query, this.pretty);
    }
}

