/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.manager;

import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.manager.BucketCreatorGorPipe;
import org.gorpipe.gor.manager.BucketManager;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.BucketableTableEntry;
import org.gorpipe.gor.table.dictionary.DictionaryTable;
import org.gorpipe.gor.table.lock.ExclusiveFileTableLock;
import org.gorpipe.gor.table.lock.TableLock;
import org.gorpipe.gor.table.lock.TableTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableManager {
    private static final Logger log = LoggerFactory.getLogger(TableManager.class);
    public static final Duration DEFAULT_LOCK_TIMEOUT = Duration.ofMinutes(30L);
    public static final Class<? extends TableLock> DEFAULT_LOCK_TYPE = ExclusiveFileTableLock.class;
    private boolean useHistory = true;
    private boolean validateFiles = true;
    private String securityContext;
    private Class<? extends TableLock> lockType = DEFAULT_LOCK_TYPE;
    private Duration lockTimeout = DEFAULT_LOCK_TIMEOUT;
    private int minBucketSize = 20;
    private int bucketSize = 100;

    public TableManager() {
    }

    private TableManager(Builder builder) {
        this.lockType = this.inferLockType(builder.lockType);
        Duration duration = this.lockTimeout = builder.lockTimeout != null ? builder.lockTimeout : DEFAULT_LOCK_TIMEOUT;
        if (builder.bucketSize > 0) {
            this.setBucketSize(builder.bucketSize);
        }
        if (builder.minBucketSize > 0) {
            this.setMinBucketSize(builder.minBucketSize);
        }
        this.useHistory = builder.useHistory;
        this.validateFiles = builder.validateFiles;
        this.securityContext = builder.securityContext != null ? builder.securityContext : System.getProperty("gor.security.context");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void setMinBucketSize(int minBucketSize) {
        this.minBucketSize = minBucketSize;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public void setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
    }

    public String getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(String securityContext) {
        this.securityContext = securityContext;
    }

    public Class<? extends TableLock> getLockType() {
        return this.lockType;
    }

    public Duration getLockTimeout() {
        return this.lockTimeout;
    }

    public BaseTable initTable(Path path) {
        if (path.toString().toLowerCase().endsWith(".gord")) {
            return ((DictionaryTable.Builder)((DictionaryTable.Builder)((DictionaryTable.Builder)new DictionaryTable.Builder(path).useHistory(this.useHistory)).securityContext(this.securityContext)).validateFiles(this.validateFiles)).build();
        }
        throw new RuntimeException("BaseTable of type " + path.toString() + " are not supported!");
    }

    public void insert(Path tableFile, BucketManager.BucketPackLevel packLevel, int workers, BucketableTableEntry ... entries) {
        BaseTable table = this.initTable(tableFile);
        this.insert(table, packLevel, workers, entries);
    }

    public void insert(BaseTable table, BucketManager.BucketPackLevel packLevel, int workers, BucketableTableEntry ... entries) {
        try (TableTransaction trans = TableTransaction.openWriteTransaction(this.lockType, (BaseTable)table, (String)table.getName(), (Duration)this.lockTimeout);){
            table.insert(entries);
            trans.commit();
        }
    }

    public void save(BaseTable table, BucketManager.BucketPackLevel packLevel, int workers) {
        try (TableTransaction trans = TableTransaction.openWriteTransaction(this.lockType, (BaseTable)table, (String)table.getName(), (Duration)this.lockTimeout);){
            trans.commit();
        }
    }

    public void delete(Path tableFile, BucketableTableEntry ... entries) {
        BaseTable table = this.initTable(tableFile);
        try (TableTransaction trans = TableTransaction.openWriteTransaction(this.lockType, (BaseTable)table, (String)table.getName(), (Duration)this.lockTimeout);){
            table.delete(entries);
            trans.commit();
        }
    }

    public void delete(Path tableFile, BaseTable.TableFilter entries) {
        BaseTable table = this.initTable(tableFile);
        try (TableTransaction trans = TableTransaction.openWriteTransaction(this.lockType, (BaseTable)table, (String)table.getName(), (Duration)this.lockTimeout);){
            table.delete((Collection)entries.get());
            trans.commit();
        }
    }

    public List<? extends BucketableTableEntry> select(Path tableFile, String[] files, String[] aliases, String[] tags, String[] buckets, String chrRange, boolean includedDeleted) {
        BaseTable table = this.initTable(tableFile);
        return table.filter().files(files).tags((String[])ArrayUtils.addAll((Object[])aliases, (Object[])tags)).buckets(buckets).chrRange(chrRange).includeDeleted(includedDeleted).get();
    }

    public Collection<? extends BucketableTableEntry> selectAll(Path tableFile) {
        BaseTable table = this.initTable(tableFile);
        try (TableTransaction trans = TableTransaction.openReadTransaction(this.lockType, (BaseTable)table, (String)table.getName(), (Duration)this.lockTimeout);){
            List list = table.selectAll();
            return list;
        }
    }

    public void print(BaseTable.TableFilter lines) {
        BaseTable table = lines.getTable();
        try (TableTransaction trans = TableTransaction.openReadTransaction(this.lockType, (BaseTable)table, (String)table.getName(), (Duration)this.lockTimeout);){
            for (Object line : lines.get()) {
                System.out.print(((BucketableTableEntry)line).formatEntry());
            }
        }
    }

    public void bucketize(Path tableFile, BucketManager.BucketPackLevel packLevel, int workers, int maxBucketCount, List<Path> bucketDirs) {
        BaseTable table = this.initTable(tableFile);
        BucketManager.newBuilder(table).lockTimeout(this.lockTimeout).bucketSize(this.bucketSize).minBucketSize(this.minBucketSize).lockType(this.lockType).bucketCreator(new BucketCreatorGorPipe(workers)).build().bucketize(packLevel, maxBucketCount, bucketDirs, false);
    }

    public void deleteBuckets(BaseTable table, Path ... buckets) {
        BucketManager.newBuilder(table).lockTimeout(this.lockTimeout).bucketSize(this.bucketSize).minBucketSize(this.minBucketSize).lockType(this.lockType).build().deleteBuckets(buckets);
    }

    public void deleteBuckets(Path tableFile, Path ... buckets) {
        BaseTable table = this.initTable(tableFile);
        this.deleteBuckets(table, buckets);
    }

    private Class<? extends TableLock> inferLockType(Class<? extends TableLock> newLockType) {
        Class<? extends TableLock> inferredLockType = DEFAULT_LOCK_TYPE;
        if (newLockType != null) {
            inferredLockType = newLockType;
            log.debug("Setting lock type from builder.");
        } else {
            String lockClassName = System.getProperty("gor.manager.locktype.class");
            if (lockClassName != null && lockClassName.length() > 0) {
                try {
                    Class<?> cls = Class.forName(lockClassName);
                    if (cls != null) {
                        inferredLockType = cls.asSubclass(TableLock.class);
                        log.debug("Setting lock type from config {}", (Object)"gor.manager.locktype.class");
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new GorSystemException((Throwable)e);
                }
            }
        }
        log.debug("Using {} for locking.", inferredLockType);
        return inferredLockType;
    }

    public static final class Builder {
        private Duration lockTimeout = null;
        private Class<? extends TableLock> lockType = null;
        private int minBucketSize = -1;
        private int bucketSize = -1;
        private boolean useHistory = true;
        private boolean validateFiles = true;
        private String securityContext;

        private Builder() {
        }

        public Builder lockType(Class val) {
            this.lockType = val;
            return this;
        }

        public Builder lockTimeout(Duration val) {
            this.lockTimeout = val;
            return this;
        }

        public Builder minBucketSize(int val) {
            this.minBucketSize = val;
            return this;
        }

        public Builder bucketSize(int val) {
            this.bucketSize = val;
            return this;
        }

        public Builder useHistory(boolean val) {
            this.useHistory = val;
            return this;
        }

        public Builder validateFiles(boolean val) {
            this.validateFiles = val;
            return this;
        }

        public Builder securityContext(String val) {
            this.securityContext = val;
            return this;
        }

        public TableManager build() {
            return new TableManager(this);
        }
    }
}

