/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.manager;

import de.tototec.cmdoption.CmdCommand;
import de.tototec.cmdoption.CmdOption;
import de.tototec.cmdoption.CmdlineParser;
import de.tototec.cmdoption.handler.AddToCollectionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandler;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.ArrayUtils;
import org.gorpipe.gor.manager.BucketManager;
import org.gorpipe.gor.manager.TableManager;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.BucketableTableEntry;
import org.gorpipe.gor.table.GenomicRange;
import org.gorpipe.gor.table.PathUtils;
import org.gorpipe.gor.table.dictionary.DictionaryEntry;
import org.gorpipe.gor.table.lock.TableLock;
import org.gorpipe.gor.util.ConfigUtil;
import org.gorpipe.logging.GorLogbackUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableManagerCLI {
    private static final Logger log = LoggerFactory.getLogger(TableManagerCLI.class);

    public static void main(String[] args) {
        GorLogbackUtil.initLog("gormanager");
        log.trace("TableManager starting");
        ConfigUtil.loadConfig((String)"gor");
        log.trace("config loaded");
        GenericOptions genericOpts = new GenericOptions();
        CmdlineParser cp = new CmdlineParser(new Object[]{genericOpts});
        cp.unregisterHandler(AddToCollectionHandler.class);
        cp.registerHandler((CmdOptionHandler)new ListAddToCollectionHandler());
        cp.setProgramName("gormanager");
        cp.setAboutLine("Copyright (c) 2017 WuxiNextCode.");
        cp.addObject(new Object[]{new CommandInsert(), new CommandMultiInsert(), new CommandDelete(), new CommandSelect(), new CommandBucketize(), new CommandDeleteBucket(), new CommandTest()});
        log.trace("CmdLineParser starting");
        String errMessage = null;
        try {
            cp.parse(args);
        }
        catch (RuntimeException e) {
            errMessage = "ERROR: " + e.getMessage() + "!\n";
        }
        log.trace("CmdLineParser done");
        if (errMessage == null && !genericOpts.help && cp.getParsedCommandName() != null) {
            ((CommandRun)cp.getParsedCommandObject()).run(genericOpts);
        } else if (genericOpts.help && cp.getParsedCommandName() != null) {
            TableManagerCLI.commandUsage(cp);
        } else if (genericOpts.version) {
            System.out.println(String.format("gormanager Copyright (c) 2017 WuxiNextCode.  Version: %s", TableManagerCLI.class.getPackage().getImplementationVersion()));
        } else if (errMessage != null) {
            System.err.println(errMessage);
            System.out.println("Use 'gormanager help' to get full command line help.");
            System.exit(-100);
        } else {
            TableManagerCLI.usage(cp);
        }
    }

    private static void usage(CmdlineParser cp) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream(baos);){
            cp.usage(ps);
            System.out.print(new String(baos.toByteArray()).replace("[parameter]", "<table>").replace("[command]", "<command>"));
        }
    }

    private static void commandUsage(CmdlineParser cp) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        PrintStream old = System.out;
        System.setOut(ps);
        cp.commandUsage(cp.getParsedCommandObject().getClass());
        System.out.flush();
        System.setOut(old);
        System.out.println(baos.toString().replace("Usage: gormanager", "Usage: gormanager <table>"));
    }

    private static BaseTable.TableFilter getBucketableTableEntries(GenericOptions genericOpts, SelectionArgs args, TableManager tm) {
        String[] allFiles = (String[])ArrayUtils.addAll((Object[])args.files.toArray(new String[0]), (Object[])args.files.toArray(new String[0]));
        String[] allTags = (String[])ArrayUtils.addAll((Object[])args.aliases.toArray(new String[0]), (Object[])args.tags.toArray(new String[0]));
        BaseTable table = tm.initTable(Paths.get(genericOpts.table, new String[0]));
        return table.filter().files((String[])(allFiles.length > 0 ? allFiles : null)).tags((String[])(allTags.length > 0 ? allTags : null)).buckets(args.buckets.size() > 0 ? args.buckets.toArray(new String[0]) : null).chrRange(args.range).includeDeleted(args.includeDeleted);
    }

    private static class ListAddToCollectionHandler
    extends AddToCollectionHandler
    implements CmdOptionHandler {
        private ListAddToCollectionHandler() {
        }

        public void applyParams(Object config, AccessibleObject element, String[] args, String optionName) {
            try {
                Field field = (Field)element;
                Collection collection = (Collection)field.get(config);
                collection.addAll(Arrays.stream(args[0].split("[,]")).map(String::trim).collect(Collectors.toList()));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class SelectionArgs {
        @CmdOption(names={"--files", "-f"}, args={"<list>"}, description="Files to filter by.  Values are specified as comma separated list.  Files are specified absolute or relative to the table dir.  Values are specified as comma separated list.", minCount=0, maxCount=-1)
        protected List<String> files = new ArrayList<String>();
        @CmdOption(names={"--tags", "-t"}, args={"<list>"}, description="Tags to filter by.  Values are specified as comma separated list.", minCount=0, maxCount=-1)
        protected List<String> tags = new ArrayList<String>();
        @CmdOption(names={"--buckets", "-b"}, args={"<list>"}, description="Buckets to filter by.  Values are specified as comma separated list.", minCount=0, maxCount=-1)
        protected List<String> buckets = new ArrayList<String>();
        @CmdOption(names={"--aliases", "-a"}, args={"<list>"}, description="Aliases to filter by.  Values are specified as comma separated list.", minCount=0, maxCount=-1)
        protected List<String> aliases = new ArrayList<String>();
        @CmdOption(names={"--range", "-r", "-p"}, args={"<range>"}, description="Range to filter by.  Value is specified as <chrom start>[:<poststart>][-[<chrom stop>:][<pos stop>]].  Note:  When seleting table lines based on ranges they always have to match exactly.")
        protected String range = null;
        @CmdOption(names={"--include_deleted"}, description="Should deleted files be included.  Mostly for debugging purposes.")
        protected boolean includeDeleted = false;

        private SelectionArgs() {
        }
    }

    @CmdCommand(names={"test"}, description="Test command")
    private static class CommandTest
    implements CommandRun {
        @CmdOption(args={"subcommand [<subcommand args> ...]"}, description="Available subcommands: \n    readlock <lockname> <period>\n    writelock <lockname> <period>\n    islock <lockname>\n    lockInfo <lockName>", minCount=0, maxCount=-1)
        private List<String> subArgs = new ArrayList<String>();

        private CommandTest() {
        }

        @Override
        public void run(GenericOptions genericOpts) {
            try {
                String subCommand = this.subArgs.get(0);
                String name = this.subArgs.get(1);
                Duration lockTimeout = Duration.ofSeconds(genericOpts.lockTimeout);
                TableManager tm = TableManager.newBuilder().useHistory(genericOpts.history).lockTimeout(lockTimeout).build();
                BaseTable table = tm.initTable(Paths.get(genericOpts.table, new String[0]));
                switch (subCommand.toLowerCase()) {
                    case "readlock": {
                        long period = Long.parseLong(this.subArgs.get(2));
                        try (TableLock lock = TableLock.acquireRead(tm.getLockType(), (BaseTable)table, (String)name, (Duration)tm.getLockTimeout());){
                            Thread.sleep(period);
                            break;
                        }
                    }
                    case "writelock": {
                        long period = Long.parseLong(this.subArgs.get(2));
                        try (TableLock lock = TableLock.acquireWrite(tm.getLockType(), (BaseTable)table, (String)name, (Duration)tm.getLockTimeout());){
                            Thread.sleep(period);
                            break;
                        }
                    }
                    case "islock": {
                        try (TableLock lock = TableLock.acquireWrite(tm.getLockType(), (BaseTable)table, (String)name, (Duration)Duration.ZERO);){
                            System.out.println((String)(lock.isValid() ? "Unlocked" : "Locked " + lock.reservedTo()));
                            break;
                        }
                    }
                    case "lockinfo": {
                        System.out.println(tm.getLockType().getSimpleName() + ":" + tm.getLockTimeout());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown command " + subCommand);
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @CmdCommand(names={"select"}, description="Looks up entries in a table or dictionary.")
    private static class CommandSelect
    extends SelectionArgs
    implements CommandRun {
        @CmdOption(args={"[<files> ...]"}, description="List of files to select, given as absolute path or relative to the table dir.  Values are specified as comma separated list.  Alternative to using -f.", minCount=0, maxCount=-1)
        private List<String> argsFiles = new ArrayList<String>();

        private CommandSelect() {
        }

        @Override
        public void run(GenericOptions genericOpts) {
            TableManager tm = TableManager.newBuilder().useHistory(genericOpts.history).lockTimeout(Duration.ofSeconds(genericOpts.lockTimeout)).build();
            BaseTable.TableFilter lines = TableManagerCLI.getBucketableTableEntries(genericOpts, this, tm);
            tm.print(lines);
        }
    }

    @CmdCommand(names={"delete_bucket"}, description="Delete the given bucket")
    private static class CommandDeleteBucket
    implements CommandRun {
        @CmdOption(args={"[<buckets> ...]"}, description="Buckets to delete, absolute path or relative to the table dir.  Values are specified as comma separated list.", minCount=0, maxCount=-1)
        private List<String> argsBuckets = new ArrayList<String>();

        private CommandDeleteBucket() {
        }

        @Override
        public void run(GenericOptions genericOpts) {
            TableManager tm = TableManager.newBuilder().useHistory(genericOpts.history).lockTimeout(Duration.ofSeconds(genericOpts.lockTimeout)).build();
            tm.deleteBuckets(Paths.get(genericOpts.table, new String[0]), (Path[])this.argsBuckets.stream().map(b -> Paths.get(b, new String[0])).toArray(Path[]::new));
        }
    }

    @CmdCommand(names={"bucketize"}, description="Bucketize the table")
    private static class CommandBucketize
    implements CommandRun {
        @CmdOption(names={"-w", "--workers"}, args={"<value>"}, description="Number of workers/threads to use.  Default: 4")
        protected int workers = 4;
        @CmdOption(names={"--min_bucket_size"}, args={"<value>"}, description="Minimum number of files in a bucket.  Can never be larger than the bucket size.  Default: 20")
        protected int minBucketSize = 20;
        @CmdOption(names={"--bucket_size"}, args={"<value>"}, description="Preferred number of files in a bucket (effective maximum).  Default: 100")
        protected int bucketSize = 100;
        @CmdOption(names={"-c", "--pack_level"}, args={"<value>"}, description="Should we pack/compress the buckets.  NO_PACKING = No packing.  CONSOLIDATE = Merge small buckets into larger ones as needed.  FULL_PACKING = Full packing (rebucketize all small buckets and rebucketize partially deleted buckets).  Default: CONSOLIDATE")
        protected BucketManager.BucketPackLevel bucketPackLevel = BucketManager.DEFAULT_BUCKET_PACK_LEVEL;
        @CmdOption(names={"-d", "--bucket_dirs"}, args={"<list>"}, description="Directories to put the bucket files in, either absolute path or relative to the table dir.  The directories must exists and be writable.  Values are specified as comma separated list.  Dafault: .<table name>.buckets", minCount=0, maxCount=-1)
        protected List<String> bucketDirs = new ArrayList<String>();
        @CmdOption(names={"--max_bucket_count"}, args={"<value>"}, description="Maximum number of buckets created in this call to bucketize.  No limit if less than 0. Default: 3")
        protected int maxBucketCount = 3;

        private CommandBucketize() {
        }

        @Override
        public void run(GenericOptions genericOpts) {
            log.trace("Calling command bucketize");
            TableManager tm = TableManager.newBuilder().minBucketSize(this.minBucketSize).bucketSize(this.bucketSize).useHistory(genericOpts.history).lockTimeout(Duration.ofSeconds(genericOpts.lockTimeout)).build();
            tm.bucketize(Paths.get(genericOpts.table, new String[0]), this.bucketPackLevel, this.workers, this.maxBucketCount, this.bucketDirs.stream().map(b -> Paths.get(b, new String[0])).collect(Collectors.toList()));
        }
    }

    @CmdCommand(names={"delete"}, description="Deletes matching entries.")
    private static class CommandDelete
    extends SelectionArgs
    implements CommandRun {
        @CmdOption(args={"[<files> ...]"}, description="List of files to delete, given as absolute path or relative to the table dir.  Values are specified as comma separated list.  Alternative to using -f.", minCount=0, maxCount=-1)
        private List<String> argsFiles = new ArrayList<String>();

        private CommandDelete() {
        }

        @Override
        public void run(GenericOptions genericOpts) {
            TableManager tm = TableManager.newBuilder().useHistory(genericOpts.history).lockTimeout(Duration.ofSeconds(genericOpts.lockTimeout)).build();
            BaseTable.TableFilter lines = TableManagerCLI.getBucketableTableEntries(genericOpts, this, tm);
            BaseTable table = tm.initTable(Paths.get(genericOpts.table, new String[0]));
            tm.delete(Paths.get(genericOpts.table, new String[0]), lines);
        }
    }

    @CmdCommand(names={"multiinsert"}, description="Inserts the given the gor files into the table.")
    private static class CommandMultiInsert
    extends CommandBucketize
    implements CommandRun {
        @CmdOption(args={"[<files> ...]"}, description="Files to insert, absolute path or relative to the table dir. Values are specified as comma separated list.", minCount=0, maxCount=-1)
        private List<String> files = new ArrayList<String>();
        @CmdOption(names={"--tags", "-t"}, args={"<list>"}, description="Specify tags to use.  Values are specified as comma separated list, where length of the list must match the number of files and element i applies to the ith file.  Empty values are allowed.")
        private List<String> tags = new ArrayList<String>();
        @CmdOption(names={"--aliases", "-a"}, args={"<list>"}, description="Aliases to use.  Values are specified as comma separated list, where length of the list must match the number of files and element i applies to the ith file.  Empty values are allowed.")
        private List<String> aliases = new ArrayList<String>();
        @CmdOption(names={"--ranges", "-r", "-p"}, args={"<list>"}, description="Specify range to use.  Values are specified as comma separated list, where length of the list must match the number of files and element i applies to the ith file.  Empty values are allowed.  Each values is specified as <chrom start>[:<poststart>][-[<chrom stop>:][<pos stop>]].")
        private List<String> ranges = new ArrayList<String>();
        @CmdOption(names={"--source", "-s"}, args={"<value>"}, description="Column used for tag filtering.")
        private String source = "PN";

        private CommandMultiInsert() {
        }

        @Override
        public void run(GenericOptions genericOpts) {
            if (this.tags.size() != 0 && this.tags.size() != this.files.size()) {
                throw new RuntimeException("Length of tag list must be the same as number of files (" + this.files.size() + ")");
            }
            if (this.aliases.size() != 0 && this.aliases.size() != this.files.size()) {
                throw new RuntimeException("Length of alias list must be the same as number of files (" + this.files.size() + ")");
            }
            if (this.ranges.size() != 0 && this.ranges.size() != this.files.size()) {
                throw new RuntimeException("Length of range list must be the same as number of files (" + this.files.size() + ")");
            }
            this.tags = this.tags.size() != 0 ? this.tags : Arrays.asList(new String[this.files.size()]);
            this.aliases = this.aliases.size() != 0 ? this.aliases : Arrays.asList(new String[this.files.size()]);
            this.ranges = this.ranges.size() != 0 ? this.ranges : Arrays.asList(new String[this.files.size()]);
            TableManager tm = TableManager.newBuilder().useHistory(genericOpts.history).minBucketSize(this.minBucketSize).bucketSize(this.bucketSize).lockTimeout(Duration.ofSeconds(genericOpts.lockTimeout)).build();
            BaseTable table = tm.initTable(Paths.get(genericOpts.table, new String[0]));
            if (this.source != null && !this.source.equals(table.getProperty("SOURCE_COLUMN"))) {
                table.setProperty("SOURCE_COLUMN", this.source);
            }
            tm.insert(Paths.get(genericOpts.table, new String[0]), this.bucketPackLevel, this.workers, (BucketableTableEntry[])IntStream.range(0, this.files.size()).mapToObj(i -> ((DictionaryEntry.Builder)((DictionaryEntry.Builder)new DictionaryEntry.Builder(PathUtils.relativize((Path)table.getRootPath(), (Path)Paths.get(this.files.get(i), new String[0])), table.getRootUri()).range(GenomicRange.parseGenomicRange((String)this.ranges.get(i)))).alias(this.aliases.get(i)).tags(new String[]{this.tags.get(i)})).build()).toArray(DictionaryEntry[]::new));
        }
    }

    @CmdCommand(names={"insert"}, description="Inserts the given the gor files into the table.  All options apply to all the files.")
    private static class CommandInsert
    extends CommandBucketize
    implements CommandRun {
        @CmdOption(args={"[<files> ...]"}, description="Files to insert, absolute path or relative to the table dir. Values are specified as comma separated list.", minCount=0, maxCount=-1)
        private List<String> files = new ArrayList<String>();
        @CmdOption(names={"--tags", "-t"}, args={"<list>"}, description="Specify tags to use.  Values are specified as comma separated list.")
        private List<String> tags = new ArrayList<String>();
        @CmdOption(names={"--alias", "-a"}, args={"<value>"}, description="Aliases to use.")
        private String alias = null;
        @CmdOption(names={"--range", "-r", "-p"}, args={"<value>"}, description="Specify range to use.  Value is specified as <chrom start>[:<poststart>][-[<chrom stop>:][<pos stop>]].")
        private String range = null;
        @CmdOption(names={"--source", "-s"}, args={"<value>"}, description="Column used for tag filtering.")
        private String source = "PN";
        @CmdOption(names={"--tagskey"}, description="All tags must be unique. The usage of the same tag twice is disallowed. If used on a dictionary with multiple files using the same tag this option will result in an error.")
        protected boolean tagskey = false;

        private CommandInsert() {
        }

        @Override
        public void run(GenericOptions genericOpts) {
            TableManager tm = TableManager.newBuilder().useHistory(genericOpts.history).minBucketSize(this.minBucketSize).bucketSize(this.bucketSize).lockTimeout(Duration.ofSeconds(genericOpts.lockTimeout)).validateFiles(genericOpts.validateFiles).build();
            BaseTable table = tm.initTable(Paths.get(genericOpts.table, new String[0]));
            if (this.source != null && !this.source.equals(table.getProperty("SOURCE_COLUMN"))) {
                table.setProperty("SOURCE_COLUMN", this.source);
            }
            if (this.alias != null && !this.tags.contains(this.alias)) {
                this.tags.add(this.alias);
            }
            if (this.tagskey) {
                table.setUniqueTags(this.tagskey);
            }
            tm.insert(Paths.get(genericOpts.table, new String[0]), this.bucketPackLevel, this.workers, (BucketableTableEntry[])this.files.stream().map(f -> PathUtils.relativize((Path)table.getRootPath(), (Path)Paths.get(f, new String[0]))).map(p -> ((DictionaryEntry.Builder)((DictionaryEntry.Builder)new DictionaryEntry.Builder(p, table.getRootUri()).range(GenomicRange.parseGenomicRange((String)this.range))).tags(this.tags)).build()).toArray(DictionaryEntry[]::new));
        }
    }

    static interface CommandRun {
        public void run(GenericOptions var1);
    }

    private static class GenericOptions {
        @CmdOption(args={"<table/dictionary file>"}, description="Table/dictionary to work with.", minCount=1)
        private String table = "";
        @CmdOption(names={"-h", "--help", "help"}, description="Display this help.", isHelp=true)
        private boolean help = false;
        @CmdOption(names={"--lock_timeout"}, args={"<value>"}, description="Maximum time (in seconds) we will wait for acquiring lock an a resource.  Default: 1800 sec.")
        private int lockTimeout = Math.toIntExact(TableManager.DEFAULT_LOCK_TIMEOUT.getSeconds());
        @CmdOption(names={"--history"}, args={"<value>"}, description="Don't keep history of gord files in the dictionary folder.  If not set we only keep the last one.  Default: True.")
        private boolean history = true;
        @CmdOption(names={"--validate"}, args={"<value>"}, description="Should the header of the input files be validate against the dictionary.  Default: True.")
        protected boolean validateFiles = true;
        @CmdOption(names={"-v", "--version", "version"}, description="Display versionInfo.", isHelp=true)
        private boolean version = false;

        private GenericOptions() {
        }
    }
}

