/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.tools;

import de.tototec.cmdoption.CmdCommand;
import de.tototec.cmdoption.CmdOption;
import de.tototec.cmdoption.CmdlineParser;
import de.tototec.cmdoption.handler.AddToCollectionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandler;
import gorsat.process.GorInputSources;
import gorsat.process.GorPipeCommands;
import gorsat.process.GorPipeMacros;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gorpipe.gor.binsearch.GorIndexFile;
import org.gorpipe.gor.binsearch.GorIndexType;
import org.gorpipe.gor.util.ConfigUtil;
import org.gorpipe.logging.GorLogbackUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GorToolsCLI {
    private static final Logger log = LoggerFactory.getLogger(GorToolsCLI.class);

    public static void main(String[] args) {
        GorLogbackUtil.initLog("gortool");
        log.trace("GorToolsCLI starting");
        try {
            GorToolsCLI.runCLI(args);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage() + "!\n");
            e.printStackTrace();
            System.out.println("Use 'gortool help' to get full command line help.");
            System.exit(-100);
        }
    }

    private static void usage(CmdlineParser cp) {
        StringBuilder output = new StringBuilder();
        cp.usage(output);
        System.out.print(output.toString().replace("[parameter]", "<url>").replace("[command]", "<command>"));
    }

    private static void commandUsage(CmdlineParser cp) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        PrintStream old = System.out;
        System.setOut(ps);
        cp.commandUsage(cp.getParsedCommandObject().getClass());
        System.out.flush();
        System.setOut(old);
        System.out.println(baos.toString().replace("Usage: gortool", "Usage: gortool <command>"));
    }

    public static void runCLI(String ... args) throws IOException {
        ConfigUtil.loadConfig((String)"gor");
        GenericOptions genericOpts = new GenericOptions();
        CmdlineParser cp = new CmdlineParser(new Object[]{genericOpts});
        cp.unregisterHandler(AddToCollectionHandler.class);
        cp.registerHandler((CmdOptionHandler)new ListAddToCollectionHandler());
        cp.setProgramName("gortool");
        cp.setAboutLine("Copyright (c) 2018 WuxiNextCode.");
        IndexFile idxFile = new IndexFile();
        cp.addObject(new Object[]{idxFile});
        GorCommandInfo gorCommandInfo = new GorCommandInfo();
        cp.addObject(new Object[]{gorCommandInfo});
        GorMacroInfo gorMacroInfo = new GorMacroInfo();
        cp.addObject(new Object[]{gorMacroInfo});
        GorInputSourceInfo gorInputSourceInfo = new GorInputSourceInfo();
        cp.addObject(new Object[]{gorInputSourceInfo});
        log.trace("CmdLineParser starting");
        cp.parse(false, true, args);
        log.trace("CmdLineParser done");
        String cmdName = cp.getParsedCommandName();
        Objects.requireNonNull(genericOpts);
        Objects.requireNonNull(genericOpts);
        if (cmdName != null) {
            Object obj = cp.getParsedCommandObject();
            ((Runnable)obj).run();
        } else {
            GorToolsCLI.usage(cp);
        }
    }

    private static class GenericOptions {
        @CmdOption(names={"-h", "--help", "help"}, description="Display this help.", isHelp=true)
        private final boolean help = false;
        @CmdOption(names={"-v", "--version", "version"}, description="Display version info.", isHelp=true)
        private final boolean version = false;

        private GenericOptions() {
        }
    }

    private static class ListAddToCollectionHandler
    extends AddToCollectionHandler
    implements CmdOptionHandler {
        private ListAddToCollectionHandler() {
        }

        public void applyParams(Object config, AccessibleObject element, String[] args, String optionName) {
            try {
                Field field = (Field)element;
                Collection collection = (Collection)field.get(config);
                collection.addAll(Arrays.stream(args[0].split("[,]")).map(String::trim).collect(Collectors.toList()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @CmdCommand(names={"index"}, description="Index a gor file.")
    private static class IndexFile
    implements Runnable {
        @CmdOption(args={"<gorfile>"}, description="The gor file.", minCount=1, maxCount=1)
        private String gorfile;
        @CmdOption(names={"--fullindex", "-f"}, description="Full index.")
        protected boolean fullindex;

        private IndexFile() {
        }

        @Override
        public void run() {
            int fi = this.gorfile.lastIndexOf(47) + 1;
            String filename = this.gorfile.substring(fi);
            Path gorindex = Paths.get(filename + ".gori", new String[0]);
            GorIndexType indexType = this.fullindex ? GorIndexType.FULLINDEX : GorIndexType.CHROMINDEX;
            try (GorIndexFile file = new GorIndexFile(gorindex.toFile(), indexType);){
                file.generateForGorz(this.gorfile);
            }
            catch (IOException e) {
                throw new RuntimeException("gor file index failed", e);
            }
        }
    }

    @CmdCommand(names={"macros"}, description="Output info on GOR macros.")
    private static class GorMacroInfo
    implements Runnable {
        private GorMacroInfo() {
        }

        @Override
        public void run() {
            try {
                GorPipeMacros.register();
                System.out.print(GorPipeMacros.getMacroInfoTable());
            }
            catch (Exception e) {
                System.err.println("Error: \n");
                System.err.println(e.getMessage());
            }
        }
    }

    @CmdCommand(names={"inputSources"}, description="Output info on GOR input sources.")
    private static class GorInputSourceInfo
    implements Runnable {
        private GorInputSourceInfo() {
        }

        @Override
        public void run() {
            try {
                GorInputSources.register();
                System.out.print(GorInputSources.getInputSourceInfoTable());
            }
            catch (Exception e) {
                System.err.println("Error: \n");
                System.err.println(e.getMessage());
            }
        }
    }

    @CmdCommand(names={"commands"}, description="Output info on GOR commands.")
    private static class GorCommandInfo
    implements Runnable {
        private GorCommandInfo() {
        }

        @Override
        public void run() {
            try {
                GorPipeCommands.register();
                System.out.print(GorPipeCommands.getCommandInfoTable());
            }
            catch (Exception e) {
                System.err.println("Error: \n");
                System.err.println(e.getMessage());
            }
        }
    }
}

