/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gorshell;

import java.io.File;
import java.io.IOException;
import org.gorpipe.gorshell.Commands;
import picocli.CommandLine;

@CommandLine.Command(name="cd", description={"Change the current working directory"})
public class CdCmd
implements Runnable {
    @CommandLine.ParentCommand
    private Commands parent;
    @CommandLine.Parameters(index="0")
    private String directory_name;

    @Override
    public void run() {
        File directory = new File(this.directory_name).getAbsoluteFile();
        if (directory.exists()) {
            try {
                String canonicalPath = directory.getCanonicalPath();
                System.setProperty("user.dir", canonicalPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.parent.print("cd: no such file or directory: " + this.directory_name);
        }
    }
}

