/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gorshell;

import com.fasterxml.jackson.databind.ObjectMapper;
import gorsat.Commands.InputSourceInfo;
import gorsat.Script.MacroInfo;
import gorsat.process.GorInputSources;
import gorsat.process.GorPipeCommands;
import gorsat.process.GorPipeMacros;
import gorsat.process.PipeInstance;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.gorpipe.gor.util.ConfigUtil;
import org.gorpipe.gorshell.Commands;
import org.gorpipe.gorshell.GorShellSessionFactory;
import org.gorpipe.gorshell.QueryRunner;
import org.gorpipe.logging.GorLogbackUtil;
import org.jline.builtins.Completers;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;
import scala.Option;

public class GorShell {
    Terminal terminal;
    LineReader lineReader;
    private CommandLine commandLine;
    private QueryRunner runner = null;
    private String input = "";
    private boolean exit = false;
    public GorShellSessionFactory sessionFactory;
    private Settings settings = new Settings();

    public GorShell(GorShellSessionFactory sessionFactory) {
        try {
            this.terminal = TerminalBuilder.builder().jansi(false).build();
        }
        catch (IOException e) {
            this.exit();
        }
        DefaultParser parser = new DefaultParser();
        parser.setEscapeChars(null);
        Commands commands = new Commands(this);
        this.commandLine = new CommandLine((Object)commands);
        this.commandLine.setCaseInsensitiveEnumValuesAllowed(true);
        this.commandLine.setUnmatchedOptionsArePositionalParams(true);
        Completer completer = this.getCompleter(this.commandLine);
        this.lineReader = LineReaderBuilder.builder().terminal(this.terminal).parser((Parser)parser).completer(completer).build();
        String startupMsg = String.format("GOR shell - %s", GorShell.class.getPackage().getImplementationVersion());
        this.terminal.writer().println(startupMsg);
        String historyFile = System.getProperty("user.home") + File.separator + ".gorshell_history";
        this.lineReader.setVariable("history-file", (Object)historyFile);
        this.lineReader.setOpt(LineReader.Option.CASE_INSENSITIVE);
        this.sessionFactory = sessionFactory;
        this.sessionFactory.setFileCacheEnabled(this.settings.fileCacheEnabled);
        this.sessionFactory.setRequestStatsEnabled(this.settings.requestStatsEnabled);
        this.sessionFactory.setConfigFile(this.settings.configFile);
    }

    public static void main(String[] args) throws IOException {
        GorLogbackUtil.initLog("gorshell");
        ConfigUtil.loadConfig((String)"gor");
        PipeInstance.initialize();
        String cwd = System.getProperty("user.dir");
        GorShell gorShell = new GorShell(new GorShellSessionFactory(cwd));
        gorShell.run();
    }

    void exit() {
        this.exit = true;
    }

    public void setConfigFile(String configFile) {
        this.settings.configFile = configFile;
    }

    void setTimingEnabled(boolean enableTiming) {
        this.settings.timingEnabled = enableTiming;
    }

    void setFileCacheEnabled(boolean fileCacheEnabled) {
        this.settings.fileCacheEnabled = fileCacheEnabled;
    }

    void setRequestStatsEnabled(boolean requestStatsEnabled) {
        this.settings.requestStatsEnabled = requestStatsEnabled;
    }

    void setDisplayResults(boolean displayResults) {
        this.settings.displayResults = displayResults;
    }

    void create(String name, String stmt) {
        if (!stmt.equals("")) {
            this.settings.createStatements.put(name, stmt);
        } else {
            this.settings.createStatements.remove(name);
        }
    }

    void def(String name, String stmt) {
        if (!stmt.equals("")) {
            this.settings.defStatements.put(name, stmt);
        } else {
            this.settings.defStatements.remove(name);
        }
    }

    void script(String scriptName) {
        File scriptFile = new File(scriptName).getAbsoluteFile();
        String query = null;
        if (scriptFile.exists()) {
            try {
                query = FileUtils.readFileToString((File)scriptFile, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                this.reportException(e);
            }
        } else {
            this.lineReader.printAbove("File does not exist");
        }
        if (query != null) {
            this.runQuery(query);
        }
    }

    void showCreates() {
        if (this.settings.createStatements.isEmpty()) {
            this.lineReader.printAbove("No create statements defined");
        } else {
            String msg = String.format("%d create statements:", this.settings.createStatements.size());
            this.lineReader.printAbove(msg);
        }
        for (String name : this.settings.createStatements.keySet()) {
            this.lineReader.printAbove(name);
        }
    }

    void showCreate(String name) {
        String statement = this.settings.createStatements.getOrDefault(name, null);
        if (statement == null) {
            String msg = String.format("%s is not a defined create statement", name);
            this.lineReader.printAbove(msg);
        } else {
            this.lineReader.printAbove(statement);
        }
    }

    void showDefs() {
        if (this.settings.defStatements.isEmpty()) {
            this.lineReader.printAbove("No def statements");
        } else {
            String msg = String.format("%d def statements:", this.settings.defStatements.size());
            this.lineReader.printAbove(msg);
        }
        for (String name : this.settings.defStatements.keySet()) {
            this.lineReader.printAbove(name);
        }
    }

    void showDef(String name) {
        String statement = this.settings.defStatements.getOrDefault(name, null);
        if (statement == null) {
            String msg = String.format("%s is not a def statement", name);
            this.lineReader.printAbove(msg);
        } else {
            this.lineReader.printAbove(statement);
        }
    }

    void showScript() {
        StringBuilder script = this.getScript();
        this.lineReader.printAbove(script.toString());
    }

    void saveScript(String scriptFile) {
        StringBuilder script = this.getScript();
        File file = new File(scriptFile);
        try {
            FileUtils.writeStringToFile((File)file, (String)script.toString(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            this.reportException(e);
        }
    }

    public void clearScript() {
        this.settings.createStatements.clear();
        this.settings.defStatements.clear();
    }

    void reportException(Exception e) {
        this.lineReader.printAbove(e.toString());
    }

    public void run() throws IOException {
        this.loadSettings();
        this.lineReader.getHistory().load();
        this.mainLoop();
        this.lineReader.getHistory().save();
        this.saveSettings();
    }

    private void saveSettings() {
        try {
            File file = this.getSettingsFile();
            String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.settings);
            FileUtils.writeStringToFile((File)file, (String)json, (Charset)Charset.defaultCharset());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadSettings() {
        try {
            File file = this.getSettingsFile();
            String json = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
            this.settings = (Settings)new ObjectMapper().readValue(json, Settings.class);
        }
        catch (IOException e) {
            this.settings = new Settings();
        }
    }

    private File getSettingsFile() {
        return new File(System.getProperty("user.home") + File.separator + ".gorshell_settings");
    }

    private void mainLoop() {
        while (!this.exit) {
            try {
                String prompt = "> ";
                if (this.runner != null) {
                    prompt = "(query running)> ";
                }
                this.input = this.lineReader.readLine(prompt);
                if (this.input.equals("")) continue;
                this.handleInput();
            }
            catch (UserInterruptException e) {
                if (!e.getPartialLine().equals("")) continue;
                this.handleInterrupt();
            }
            catch (EndOfFileException e) {
                break;
            }
            catch (Exception e) {
                this.reportException(e);
            }
        }
    }

    private void handleInput() {
        ParsedLine parsedLine = this.lineReader.getParsedLine();
        String cmd = (String)parsedLine.words().get(0);
        InputSourceInfo info = GorInputSources.getInfo(cmd);
        Option<MacroInfo> macroInfo = GorPipeMacros.getInfo(cmd);
        if (info != null || macroInfo.isDefined()) {
            this.handleQuery();
        } else {
            String[] arguments = this.input.split(" ");
            this.commandLine.execute(arguments);
        }
    }

    private Completer getCompleter(CommandLine commandLine) {
        Path workDir = Paths.get("", new String[0]);
        PicocliCommands picocliCommands = new PicocliCommands(workDir, commandLine);
        Completers.SystemCompleter commandsCompleter = picocliCommands.compileCompleters();
        commandsCompleter.compile();
        StringsCompleter inputSourcesCompleter = new StringsCompleter(GorInputSources.getInputSources());
        StringsCompleter pipeCommandsCompleter = new StringsCompleter(GorPipeCommands.getGorCommands());
        return new AggregateCompleter(new Completer[]{inputSourcesCompleter, pipeCommandsCompleter, new Completers.FileNameCompleter(), commandsCompleter});
    }

    private void handleInterrupt() {
        if (this.runner != null) {
            if (this.runner.isDone()) {
                this.lineReader.printAbove("Query finished");
                this.runner = null;
            } else if (!this.runner.isCancelled()) {
                this.lineReader.printAbove("Cancelling query");
                this.runner.cancel();
                try {
                    this.runner.join(3000L);
                    this.runner = null;
                }
                catch (InterruptedException e) {
                    this.runner.interrupt();
                }
            } else if (this.runner.isAlive()) {
                this.lineReader.printAbove("Killing query");
                this.runner.interrupt();
                this.runner = null;
            } else {
                this.runner = null;
            }
        } else {
            this.lineReader.printAbove("Ctrl-D or 'exit' to exit");
        }
    }

    private void handleQuery() {
        StringBuilder script = this.getScript();
        script.append(this.input);
        this.runQuery(script.toString());
    }

    private StringBuilder getScript() {
        StringBuilder script = new StringBuilder();
        this.addStatements(script, "def", this.settings.defStatements);
        this.addStatements(script, "create", this.settings.createStatements);
        return script;
    }

    private void runQuery(String script) {
        this.resetRunner();
        this.runner = new QueryRunner(script, this.lineReader, Thread.currentThread(), this.sessionFactory);
        this.runner.setTimingEnabled(this.settings.timingEnabled);
        this.runner.setFileCacheEnabled(this.settings.fileCacheEnabled);
        this.runner.setRequestStatsEnabled(this.settings.requestStatsEnabled);
        this.runner.setDisplayResults(this.settings.displayResults);
        this.runner.setConfigFile(this.settings.configFile);
        this.runner.start();
    }

    private void resetRunner() {
        if (this.runner != null && this.runner.isAlive()) {
            this.runner.interrupt();
            this.runner = null;
        }
    }

    private void addStatements(StringBuilder script, String prefix, Map<String, String> statements) {
        for (Map.Entry<String, String> entry : statements.entrySet()) {
            script.append(prefix);
            script.append(" ");
            script.append(entry.getKey());
            script.append(" = ");
            script.append(entry.getValue());
            script.append(";\n");
        }
    }

    public static class Settings {
        public boolean timingEnabled = false;
        public boolean fileCacheEnabled = true;
        public boolean requestStatsEnabled = false;
        public boolean displayResults = true;
        public String configFile = "";
        public Map<String, String> createStatements = new HashMap<String, String>();
        public Map<String, String> defStatements = new HashMap<String, String>();
    }
}

