/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gorshell;

import gorsat.QueryHandlers.GeneralQueryHandler;
import gorsat.process.FreemarkerReportBuilder;
import gorsat.process.GenericRunnerFactory;
import gorsat.process.GorSessionCacheManager;
import gorsat.process.GorSessionFactory;
import gorsat.process.SessionBasedQueryEvaluator;
import java.nio.file.Paths;
import java.util.UUID;
import org.gorpipe.client.FileCache;
import org.gorpipe.gor.RequestStats;
import org.gorpipe.gor.clients.LocalFileCacheClient;
import org.gorpipe.gor.clients.NoCacheFileCacheClient;
import org.gorpipe.gor.model.DefaultEventLogger;
import org.gorpipe.gor.model.DriverBackedFileReader;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.GorParallelQueryHandler;
import org.gorpipe.gor.model.QueryEvaluator;
import org.gorpipe.gor.session.EventLogger;
import org.gorpipe.gor.session.GorReportBuilder;
import org.gorpipe.gor.session.GorRunnerFactory;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.gor.session.GorSessionCache;
import org.gorpipe.gor.session.ProjectContext;
import org.gorpipe.gor.session.SystemContext;

public class GorShellSessionFactory
extends GorSessionFactory {
    private String root = "";
    private final String cacheDir;
    private String configFile = "";
    private boolean fileCacheEnabled = true;
    private boolean requestStatsEnabled = false;

    public GorShellSessionFactory() {
        this.cacheDir = System.getProperty("java.io.tmpdir");
    }

    public GorShellSessionFactory(String root) {
        this.root = root;
        this.cacheDir = System.getProperty("java.io.tmpdir");
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setFileCacheEnabled(boolean fileCacheEnabled) {
        this.fileCacheEnabled = fileCacheEnabled;
    }

    public void setRequestStatsEnabled(boolean requestStatsEnabled) {
        this.requestStatsEnabled = requestStatsEnabled;
    }

    protected GorSession createSession() {
        String requestId = UUID.randomUUID().toString();
        return new GorSession(requestId);
    }

    protected GorParallelQueryHandler createQueryHandler(GorSession session) {
        return new GeneralQueryHandler(session.getGorContext(), false);
    }

    public GorSession create() {
        GorSession session = this.createSession();
        ProjectContext.Builder projectContextBuilder = new ProjectContext.Builder();
        LocalFileCacheClient fileCache = this.fileCacheEnabled ? new LocalFileCacheClient(Paths.get(this.cacheDir, new String[0])) : new NoCacheFileCacheClient(Paths.get(this.cacheDir, new String[0]));
        GorParallelQueryHandler queryHandler = this.createQueryHandler(session);
        projectContextBuilder.setRoot(this.root).setCacheDir(this.cacheDir).setConfigFile(this.configFile).setFileReader((FileReader)new DriverBackedFileReader("", this.root, null)).setFileCache((FileCache)fileCache).setQueryHandler(queryHandler).setQueryEvaluator((QueryEvaluator)new SessionBasedQueryEvaluator(session));
        SystemContext.Builder systemContextBuilder = new SystemContext.Builder();
        systemContextBuilder.setReportBuilder((GorReportBuilder)new FreemarkerReportBuilder(session)).setRunnerFactory((GorRunnerFactory)new GenericRunnerFactory()).setServer(false).setStartTime(System.currentTimeMillis());
        GorSessionCache cache = GorSessionCacheManager.getCache(session.getRequestId());
        Object eventLogger = this.requestStatsEnabled ? new RequestStats(session) : new DefaultEventLogger();
        session.init(projectContextBuilder.build(), systemContextBuilder.build(), cache, (EventLogger)eventLogger);
        return session;
    }
}

