/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gorshell;

import gorsat.process.PipeInstance;
import java.io.IOException;
import org.gorpipe.gor.RequestStats;
import org.gorpipe.gor.monitor.GorMonitor;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.gorshell.GorShellSessionFactory;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public class QueryRunner
extends Thread {
    private final String query;
    private final LineReader lineReader;
    private final Thread ownerThread;
    private final GorMonitor gorMonitor;
    private boolean timingEnabled = false;
    private boolean fileCacheEnabled = true;
    private boolean requestStatsEnabled = false;
    private GorShellSessionFactory sessionFactory;
    private long startTime;
    private GorSession gorSession;
    private long initTime;
    private long numRows;
    private long beforeLoopTime;
    private long afterLoopTime;
    private boolean isDone;
    private boolean displayResults = true;
    private String configFile;

    QueryRunner(String query, LineReader lineReader, Thread owner, GorShellSessionFactory sessionFactory) {
        this.query = query;
        this.lineReader = lineReader;
        this.ownerThread = owner;
        this.gorMonitor = new GorMonitor();
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void run() {
        this.startTime = System.currentTimeMillis();
        this.gorSession = this.sessionFactory.create();
        this.gorSession.getSystemContext().setMonitor(this.gorMonitor);
        this.gorSession.getEventLogger().query(this.query);
        try (PipeInstance pipe = PipeInstance.createGorIterator(this.gorSession.getGorContext());){
            this.runPipe(pipe);
        }
        catch (Exception e) {
            this.lineReader.printAbove(e.toString());
        }
        this.isDone = true;
        if (!this.isCancelled()) {
            this.ownerThread.interrupt();
        }
    }

    private void runPipe(PipeInstance pipe) throws IOException {
        this.gorSession.getGorContext().start("");
        pipe.init(this.query, this.gorMonitor);
        this.initTime = System.currentTimeMillis();
        this.printHeader(pipe);
        this.printRows(pipe);
        this.printFooter();
        this.gorSession.getGorContext().end();
        this.gorSession.close();
        if (this.requestStatsEnabled) {
            RequestStats rs = (RequestStats)this.gorSession.getEventLogger();
            rs.saveToJson();
        }
    }

    private void printHeader(PipeInstance pipe) {
        String header = pipe.getHeader();
        if (this.gorSession.getNorContext() || pipe.isNorContext()) {
            header = this.skipFirstTwoColumns(header);
        }
        this.lineReader.printAbove(new AttributedString((CharSequence)header, AttributedStyle.BOLD));
    }

    private void printRows(PipeInstance pipe) {
        this.numRows = 0L;
        this.beforeLoopTime = System.currentTimeMillis();
        while (pipe.hasNext() && !this.gorMonitor.isCancelled()) {
            String rowAsString = pipe.next();
            if (this.displayResults) {
                this.lineReader.printAbove(rowAsString);
            }
            ++this.numRows;
        }
        pipe.close();
        this.afterLoopTime = System.currentTimeMillis();
    }

    private void printFooter() {
        String cancelledSuffix = "";
        if (this.gorMonitor.isCancelled()) {
            cancelledSuffix = " (cancelled)";
        }
        String footer = String.format("%d row(s)%s", this.numRows, cancelledSuffix);
        this.lineReader.printAbove(new AttributedString((CharSequence)footer, AttributedStyle.BOLD));
        if (this.timingEnabled) {
            double initTimeSec = (double)(this.initTime - this.startTime) / 1000.0;
            double rowsTimeSec = (double)(this.afterLoopTime - this.beforeLoopTime) / 1000.0;
            this.lineReader.printAbove(String.format("Init: %f, Data: %f", initTimeSec, rowsTimeSec));
        }
    }

    private String skipFirstTwoColumns(String header) {
        int firstTab = header.indexOf(9);
        int secondTab = header.indexOf(9, firstTab + 1);
        header = header.substring(secondTab + 1);
        return header;
    }

    void cancel() {
        this.gorMonitor.setCancelled(true);
    }

    public boolean isDone() {
        return this.isDone;
    }

    boolean isCancelled() {
        return this.gorMonitor.isCancelled();
    }

    void setTimingEnabled(boolean timingEnabled) {
        this.timingEnabled = timingEnabled;
    }

    void setFileCacheEnabled(boolean fileCacheEnabled) {
        this.fileCacheEnabled = fileCacheEnabled;
    }

    void setRequestStatsEnabled(boolean requestStatsEnabled) {
        this.requestStatsEnabled = requestStatsEnabled;
    }

    public void setDisplayResults(boolean displayResults) {
        this.displayResults = displayResults;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }
}

