/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.factory;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.querydialogs.Argument;
import org.gorpipe.querydialogs.ArgumentDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArgumentBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ArgumentBuilder.class);
    private static Map<String, String> pathMap = null;
    private final FileReader fileResolver;
    private boolean ignoreAllowedMismatch = false;

    public ArgumentBuilder(FileReader fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void setIgnoreAllowedMismatch(boolean ignoreAllowedMismatch) {
        this.ignoreAllowedMismatch = ignoreAllowedMismatch;
    }

    public boolean ignoreAllowedMismatch() {
        return this.ignoreAllowedMismatch;
    }

    private static synchronized Map<String, String> getPathMap(FileReader fileResolver) throws IOException {
        if (pathMap == null) {
            pathMap = new HashMap<String, String>();
            String path = System.getProperty("dialog.aliasmap", null);
            if (path != null) {
                for (String line : fileResolver.readAll(path)) {
                    String[] parts = line.split("\\t");
                    if (parts.length <= 1) continue;
                    pathMap.put(parts[0], parts[1]);
                }
            }
        }
        return pathMap;
    }

    protected static String safeString(Object o) {
        return o == null ? null : o.toString();
    }

    protected static List<? extends Object> getAllowedValues(Map<String, ? extends Object> attributes) {
        List<Object> allowedValues = new ArrayList();
        if (attributes.containsKey("values")) {
            for (Object o : (List)attributes.get("values")) {
                if (Number.class.isAssignableFrom(o.getClass())) {
                    allowedValues.add(o);
                    continue;
                }
                if (Date.class.isAssignableFrom(o.getClass())) {
                    allowedValues.add(o);
                    continue;
                }
                allowedValues.add(o.toString());
            }
        } else if (attributes.containsKey("values_path")) {
            allowedValues = Argument.DEFERRED_LIST;
        }
        return allowedValues;
    }

    public abstract Argument build(String var1, Map<String, ? extends Object> var2);

    protected URI getValuesPath(Map<String, ? extends Object> attributes) {
        try {
            String resource = ArgumentBuilder.safeString(attributes.get("values_path"));
            if (resource == null) {
                return null;
            }
            if (ArgumentBuilder.getPathMap(this.fileResolver).containsKey(resource)) {
                resource = ArgumentBuilder.getPathMap(this.fileResolver).get(resource).trim();
            }
            return URI.create(resource);
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid valuesPath", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load valuesPath", e);
        }
    }

    protected Integer getDisplayWidth(Map<String, ? extends Object> attributes) {
        return (Integer)attributes.get("display_width");
    }

    protected ArgumentDescription getArgumentDescription(Map<String, ? extends Object> attributes, String name) {
        String description = ArgumentBuilder.safeString(attributes.get("description"));
        String displayName = ArgumentBuilder.safeString(attributes.get("display_name"));
        String tooltip = ArgumentBuilder.safeString(attributes.get("tooltip"));
        return new ArgumentDescription(name, description, displayName, tooltip);
    }
}

