/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.factory.builder;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.querydialogs.ArgumentDescription;
import org.gorpipe.querydialogs.ArgumentType;
import org.gorpipe.querydialogs.argument.StringArgument;
import org.gorpipe.querydialogs.factory.ArgumentBuilder;
import org.gorpipe.querydialogs.util.ValueFormatter;

public class StringArgumentBuilder
extends ArgumentBuilder {
    public StringArgumentBuilder(FileReader fileResolver) {
        super(fileResolver);
    }

    @Override
    public StringArgument build(String name, Map<String, ? extends Object> attributes) {
        ArgumentDescription argDescr = this.getArgumentDescription(attributes, name);
        Boolean optional = (Boolean)attributes.get("optional");
        String defaultValue = StringArgumentBuilder.safeString(attributes.get("default"));
        List<Object> allowed = this.ignoreAllowedMismatch() ? new ArrayList() : StringArgumentBuilder.getAllowedValues(attributes);
        URI valuesPath = this.getValuesPath(attributes);
        List operators = (List)attributes.get("operators");
        ValueFormatter formatter = null;
        if (attributes.containsKey("format")) {
            formatter = new ValueFormatter((Map)attributes.get("format"));
        }
        boolean quoted = !attributes.containsKey("quoted") || attributes.get("quoted") == Boolean.TRUE;
        Boolean advanced = (Boolean)attributes.get("advanced");
        Integer displayWidth = this.getDisplayWidth(attributes);
        ArgumentType argType = attributes.containsKey("type") ? ArgumentType.valueOf(attributes.get("type").toString().trim().toUpperCase()) : ArgumentType.STRING;
        Boolean singleSelection = (Boolean)attributes.get("single_selection");
        return new StringArgument(argDescr, quoted, optional, defaultValue, allowed, valuesPath, formatter, operators, advanced, displayWidth, argType, singleSelection);
    }
}

