/*
 * Decompiled with CFR 0.152.
 */
package gorsat;

import gorsat.BufferAdaptor;
import gorsat.ReaderThread;
import gorsat.RowBuffer;
import org.gorpipe.gor.model.Row;

public class TimeoutBufferAdaptor
extends BufferAdaptor {
    long timeTriggerBufferFlushNs;

    public TimeoutBufferAdaptor(ReaderThread readerThread, long timeTriggerBufferFlushNs) {
        super(readerThread);
        this.timeTriggerBufferFlushNs = timeTriggerBufferFlushNs;
    }

    public void updateTimeMeasurement(long deltaTimeNs, RowBuffer current) {
        ++this.avgCount;
        this.numberOfRowsRead += current.size();
        this.totalTimeNs += deltaTimeNs;
        this.avgBatchSize = ((double)(this.avgCount - 1) * this.avgBatchSize + (double)current.size()) / (double)this.avgCount;
        this.avgRowsPerMilliSecond = (double)this.numberOfRowsRead / ((double)this.totalTimeNs / 1000000.0);
        Row firstRow = current.get(0);
        Row lastRow = current.get(current.size() - 1);
        if (firstRow.chr.equals(lastRow.chr)) {
            ++this.bavgCount;
            this.avgBasesPerMilliSecond = ((double)(this.bavgCount - 1) * this.avgBasesPerMilliSecond + (double)(lastRow.pos - firstRow.pos) / ((double)deltaTimeNs / 1000000.0)) / (double)this.bavgCount;
        }
    }

    @Override
    public void process(Row r) {
        try {
            if (!this.wantsNoMore()) {
                this.current.add(r);
                if (this.current.isFull()) {
                    long nt = System.nanoTime();
                    if (nt - this.t > this.timeTriggerBufferFlushNs) {
                        if (this.readerThread.offer(this.current)) {
                            this.updateTimeMeasurement(nt - this.t, this.current);
                            this.current = this.current.nextRowBuffer();
                            this.current.reduce(this.current.size() / 2);
                            this.t = System.nanoTime();
                        } else if (!this.current.enlarge(this.current.size() * 2)) {
                            this.updateTimeMeasurement(nt - this.t, this.current);
                            this.readerThread.offerBatch(this.current);
                            this.current = this.current.nextRowBuffer();
                            this.t = System.nanoTime();
                        }
                    } else if (!this.current.enlarge(this.current.size() * 8)) {
                        this.updateTimeMeasurement(nt - this.t, this.current);
                        this.readerThread.offerBatch(this.current);
                        this.current = this.current.nextRowBuffer();
                        this.t = System.nanoTime();
                    }
                }
            } else {
                this.readerThread.stopProcessing("Stop processing adaptor wantsNoMore");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }
}

