/*
 * Decompiled with CFR 0.152.
 */
package gorsat.parquet;

import gorsat.Commands.Output;
import gorsat.RowBuffer;
import gorsat.parquet.GorParquetWriter;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.function.GorRowInferFunction;
import org.gorpipe.gor.model.Row;

public class GorParquetFileOut
extends Output {
    ParquetWriter<Row> parquetWriter;
    Configuration conf = new Configuration();
    Path path;
    String header;
    GorRowInferFunction gorRowInferFunction;
    RowBuffer rowBuffer;
    boolean nor;

    public GorParquetFileOut(String filePath, String header, boolean nor) {
        this.path = new Path(filePath);
        this.header = header;
        this.nor = nor;
    }

    public void setup() {
        this.gorRowInferFunction = new GorRowInferFunction();
        this.rowBuffer = new RowBuffer(1000);
    }

    private void flushTypeInferBuffer() throws IOException {
        if (this.rowBuffer.available()) {
            boolean ordered;
            Row row;
            Row prev = row = this.rowBuffer.get(0);
            boolean bl = ordered = !row.chr.equals("chrN") && row.pos != 0;
            if (this.rowBuffer.size() == 1) {
                row = this.gorRowInferFunction.apply(row, row);
            } else {
                for (int i = 1; i < this.rowBuffer.size(); ++i) {
                    Row next = this.rowBuffer.get(i);
                    ordered &= prev.atPriorPos(next) || prev.atSamePos(next);
                    prev = next;
                    row = this.gorRowInferFunction.apply(row, next);
                }
            }
            this.conf.setBoolean("ordered", ordered);
            this.conf.setBoolean("nor", this.nor);
            this.conf.set("header", this.header);
            this.conf.set("schema", row.toString());
            this.parquetWriter = ((GorParquetWriter.GorParquetBuilder)((GorParquetWriter.GorParquetBuilder)GorParquetWriter.builder(this.path).withConf(this.conf)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).build();
            while (this.rowBuffer.hasNext()) {
                this.parquetWriter.write((Object)this.rowBuffer.next());
            }
        }
    }

    public void process(Row r) {
        if (!this.rowBuffer.isFull()) {
            this.rowBuffer.add(r);
        } else {
            try {
                this.flushTypeInferBuffer();
                this.parquetWriter.write((Object)r);
            }
            catch (IOException e) {
                throw new GorSystemException("Error in parquet file out process", (Throwable)e);
            }
        }
    }

    public void finish() {
        try {
            this.flushTypeInferBuffer();
            this.parquetWriter.close();
        }
        catch (IOException e) {
            throw new GorSystemException("Error in parquet file out finish", (Throwable)e);
        }
    }
}

