/*
 * Decompiled with CFR 0.152.
 */
package gorsat.parser;

import gorsat.process.PipeInstance;
import gorsat.process.PipeInstance$;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import org.gorpipe.exceptions.GorDataException;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.GenomicIterator;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.session.GorContext;
import org.gorpipe.gor.util.GChiSquared2by2;
import org.gorpipe.gor.util.GFisherExact2by2;
import org.gorpipe.model.gor.iterators.RefSeq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ParseUtilities$ {
    public static ParseUtilities$ MODULE$;
    private final Logger logger;
    private final char[] complementPairsMap;
    private final Map<String, String> iupac2GTs;
    private final List<Tuple2<String, String>> codon2aminoacid;
    private final String[] codon2aminoAcidLookupLong;
    private final String[] codon2aminoAcidLookupShort;
    private final byte[] byteArray;

    static {
        new ParseUtilities$();
    }

    private Logger logger() {
        return this.logger;
    }

    public double twoByTwoPvalTwoTailed(int minCase, int majCase, int minCtrl, int majCtrl) {
        if (minCase < 10 || majCase < 10 || minCtrl < 10 || majCtrl < 10) {
            return GFisherExact2by2.computeTwoTailed(minCase, majCase, minCtrl, majCtrl);
        }
        double chisq = GChiSquared2by2.computeLogLikelihoodChiSquared(minCase, majCase, minCtrl, majCtrl);
        return GChiSquared2by2.getPValue(chisq);
    }

    public double twoByTwoPvalOneTailed(int minCase, int majCase, int minCtrl, int majCtrl) {
        if (minCase < 10 || majCase < 10 || minCtrl < 10 || majCtrl < 10) {
            return GFisherExact2by2.computeOneTailed(minCase, majCase, minCtrl, majCtrl);
        }
        double chisq = GChiSquared2by2.computeLogLikelihoodChiSquared(minCase, majCase, minCtrl, majCtrl);
        return GChiSquared2by2.getPValue(chisq) / 2.0;
    }

    public String genTag(String str, String tag, String term) {
        int n;
        String res = "";
        if (str.startsWith(new StringBuilder(1).append(tag).append("=").toString())) {
            n = 0;
        } else {
            int st = str.indexOf(new StringBuilder(1).append(term).append(tag).append("=").toString());
            if (st == -1) {
                return "NOT_FOUND";
            }
            n = st + 1;
        }
        int start = n;
        String s2 = str.substring(start, str.length());
        int stop = s2.indexOf(term);
        res = stop == -1 ? str.substring(start + new StringBuilder(1).append(tag).append("=").toString().length(), str.length()) : str.substring(start + new StringBuilder(1).append(tag).append("=").toString().length(), stop + start);
        String string = res;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new GorDataException(new StringBuilder(36).append(tag).append(" is missing value, check file data: ").toString());
        }
        return res;
    }

    public String bamTag(String str, String tag) {
        return this.genTag(str, tag, " ");
    }

    public String gffTag(String str, String tag) {
        return this.genTag(str, tag, ";");
    }

    public char[] complementPairsMap() {
        return this.complementPairsMap;
    }

    public Map<String, String> iupac2GTs() {
        return this.iupac2GTs;
    }

    public String iupac2GT(String code) {
        String alleles = (String)this.iupac2GTs().apply((Object)code);
        return new StringOps(Predef$.MODULE$.augmentString(alleles)).mkString("/");
    }

    public int nucleotide2integer(char nucleotide) {
        char c = nucleotide;
        switch (c) {
            case 'A': 
            case 'a': {
                return 0;
            }
            case 'C': 
            case 'c': {
                return 1;
            }
            case 'G': 
            case 'g': {
                return 2;
            }
            case 'T': 
            case 't': {
                return 3;
            }
        }
        throw new GorParsingException(new StringBuilder(19).append("Unknown nucleotide ").append(nucleotide).toString());
    }

    public List<Tuple2<String, String>> codon2aminoacid() {
        return this.codon2aminoacid;
    }

    public String[] codon2aminoAcidLookupLong() {
        return this.codon2aminoAcidLookupLong;
    }

    public String[] codon2aminoAcidLookupShort() {
        return this.codon2aminoAcidLookupShort;
    }

    public byte[] byteArray() {
        return this.byteArray;
    }

    public String system(String s) {
        Process p = Runtime.getRuntime().exec(s);
        String systemMessage = "";
        try (InputStream in = p.getInputStream();){
            try {
                int total = 0;
                int r = in.read(this.byteArray(), 0, this.byteArray().length);
                while (r != -1 && total < this.byteArray().length) {
                    r = in.read(this.byteArray(), total += r, this.byteArray().length - total);
                }
                if (total == this.byteArray().length) {
                    r = in.read();
                }
                systemMessage = new String(this.byteArray(), 0, total).trim();
                if (r != -1) {
                    systemMessage = new StringBuilder(29).append(systemMessage).append("... additional truncated data").toString();
                }
            }
            catch (GorSystemException e) {
                systemMessage = e.getMessage();
            }
        }
        return systemMessage;
    }

    public String eval(String s, GorContext context) {
        PipeInstance pipeInstance = PipeInstance$.MODULE$.createGorIterator(context);
        pipeInstance.init(s);
        String systemMessage = "";
        try (GenomicIterator rs = pipeInstance.getRowSource();){
            try {
                String[] nextItems;
                if (rs.hasNext() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(nextItems = new StringOps(Predef$.MODULE$.augmentString(((Row)rs.next()).otherCols())).split('\t')))).nonEmpty()) {
                    systemMessage = ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nextItems)).head()).trim();
                }
            }
            catch (GorSystemException e) {
                systemMessage = e.getMessage();
            }
        }
        return systemMessage;
    }

    public int aminoAcid2Integer(String amino) {
        return 1 + this.nucleotide2integer(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(amino), 0)) + this.nucleotide2integer(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(amino), 1)) * 4 + this.nucleotide2integer(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(amino), 2)) * 16;
    }

    public String codons2aminos(String codon, boolean longFormat) {
        scala.collection.mutable.StringBuilder strbuff = new scala.collection.mutable.StringBuilder(codon.length() + 1);
        int noCodons = codon.length() / 3;
        for (int i = 0; i < noCodons; ++i) {
            scala.collection.mutable.StringBuilder stringBuilder;
            try {
                int x = this.aminoAcid2Integer(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(codon), i * 3, i * 3 + 3));
                if (longFormat) {
                    stringBuilder = strbuff.append(this.codon2aminoAcidLookupLong()[x]);
                    continue;
                }
                stringBuilder = strbuff.append(this.codon2aminoAcidLookupShort()[x]);
                continue;
            }
            catch (GorParsingException gorParsingException) {
                stringBuilder = longFormat ? strbuff.append("???") : strbuff.append("?");
            }
        }
        Object object = codon.length() > noCodons * 3 ? (longFormat ? strbuff.append("???") : strbuff.append("?")) : BoxedUnit.UNIT;
        return strbuff.toString();
    }

    public boolean codons2aminos$default$2() {
        return true;
    }

    public String string2wordString(String c, int wordSize, String sep) {
        int i;
        int noWords = c.length() / wordSize;
        scala.collection.mutable.StringBuilder strbuff = new scala.collection.mutable.StringBuilder(c.length() + noWords);
        for (i = 0; i < noWords; ++i) {
            Object object = i != 0 ? strbuff.append(sep) : BoxedUnit.UNIT;
            String x = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(c), i * wordSize, i * wordSize + wordSize);
            strbuff.append(x);
        }
        Object object = c.length() > noWords * wordSize ? strbuff.append(new StringBuilder(0).append(i != 0 ? sep : "").append(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(c), i * wordSize, i * wordSize + wordSize)).toString()) : BoxedUnit.UNIT;
        return strbuff.toString();
    }

    public String reverseComplement(String str) {
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(str)).reverse())).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToCharacter((char)ParseUtilities$.$anonfun$reverseComplement$1(BoxesRunTime.unboxToChar((Object)x))), Predef$.MODULE$.StringCanBuildFrom());
    }

    public String revCigar(String str) {
        int start = 0;
        scala.collection.mutable.StringBuilder ostr = new scala.collection.mutable.StringBuilder(str.length());
        ostr.length_$eq(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), i) <= '9') continue;
            for (int j = start; j <= i; ++j) {
                ostr.setCharAt(str.length() - 1 - i + j - start, StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), j));
            }
            start = i + 1;
        }
        return ostr.toString();
    }

    public int IHA(String iupac, String allele) {
        if (((String)this.iupac2GTs().apply((Object)iupac)).indexOf(allele) >= 0) {
            return 1;
        }
        return 0;
    }

    public String fString(int a, int b) {
        return new StringBuilder(3).append("%").append(a).append(".").append(b).append("f").toString();
    }

    public String eString(int a, int b) {
        return new StringBuilder(3).append("%").append(a).append(".").append(b).append("e").toString();
    }

    public String gString(int a, int b) {
        return new StringBuilder(3).append("%").append(a).append(".").append(b).append("g").toString();
    }

    public String formNum(Double d, String f) {
        if (d.isNaN()) {
            return d.toString();
        }
        return String.format(Locale.ROOT, f, d);
    }

    public String parentsGT(String child, String father, String mother, int fORm) {
        String string;
        try {
            block8: {
                block7: {
                    String string2 = child;
                    String string3 = "A";
                    if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block7;
                    String string4 = child;
                    String string5 = "C";
                    if (!(string4 == null ? string5 != null : !string4.equals(string5))) break block7;
                    String string6 = child;
                    String string7 = "G";
                    if (!(string6 == null ? string7 != null : !string6.equals(string7))) break block7;
                    String string8 = child;
                    String string9 = "T";
                    if (string8 != null ? !string8.equals(string9) : string9 != null) break block8;
                }
                return child;
            }
            String cGT = (String)this.iupac2GTs().apply((Object)child);
            String fGT = (String)this.iupac2GTs().apply((Object)father);
            int fGT0 = fGT.indexOf(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(cGT), 0));
            int fGT1 = fGT.indexOf(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(cGT), 1));
            if (fGT0 >= 0 && fGT1 < 0) {
                return Character.toString(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(cGT), 0));
            }
            String mGT = (String)this.iupac2GTs().apply((Object)mother);
            int mGT0 = mGT.indexOf(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(cGT), 0));
            int mGT1 = mGT.indexOf(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(cGT), 1));
            if (mGT0 >= 0 && mGT1 < 0) {
                return Character.toString(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(cGT), 1));
            }
            string = Character.toString(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(cGT), fORm));
        }
        catch (GorSystemException e) {
            this.logger().error(new StringBuilder(0).append(child).append(father).append(mother).toString(), (Throwable)e);
            string = "";
        }
        return string;
    }

    public String fatherGT(String child, String father, String mother) {
        return this.parentsGT(child, father, mother, 0);
    }

    public String motherGT(String child, String father, String mother) {
        return this.parentsGT(child, mother, father, 1);
    }

    public String phaseKnown(String child, String father, String mother) {
        block19: {
            block20: {
                boolean mHet;
                boolean fHet;
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        String string = child;
                                        String string2 = "U";
                                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                            return "0";
                                        }
                                        String string3 = child;
                                        String string4 = "A";
                                        if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block13;
                                        String string5 = child;
                                        String string6 = "C";
                                        if (!(string5 == null ? string6 != null : !string5.equals(string6))) break block13;
                                        String string7 = child;
                                        String string8 = "G";
                                        if (!(string7 == null ? string8 != null : !string7.equals(string8))) break block13;
                                        String string9 = child;
                                        String string10 = "T";
                                        if (string9 != null ? !string9.equals(string10) : string10 != null) break block14;
                                    }
                                    return "1";
                                }
                                fHet = true;
                                String string = father;
                                String string11 = "A";
                                if (!(string == null ? string11 != null : !string.equals(string11))) break block15;
                                String string12 = father;
                                String string13 = "C";
                                if (!(string12 == null ? string13 != null : !string12.equals(string13))) break block15;
                                String string14 = father;
                                String string15 = "G";
                                if (!(string14 == null ? string15 != null : !string14.equals(string15))) break block15;
                                String string16 = father;
                                String string17 = "T";
                                if (string16 != null ? !string16.equals(string17) : string17 != null) break block16;
                            }
                            fHet = false;
                        }
                        mHet = true;
                        String string = mother;
                        String string18 = "A";
                        if (!(string == null ? string18 != null : !string.equals(string18))) break block17;
                        String string19 = mother;
                        String string20 = "C";
                        if (!(string19 == null ? string20 != null : !string19.equals(string20))) break block17;
                        String string21 = mother;
                        String string22 = "G";
                        if (!(string21 == null ? string22 != null : !string21.equals(string22))) break block17;
                        String string23 = mother;
                        String string24 = "T";
                        if (string23 != null ? !string23.equals(string24) : string24 != null) break block18;
                    }
                    mHet = false;
                }
                if (!fHet || !mHet) break block19;
                String string = father;
                String string25 = mother;
                if (!(string == null ? string25 != null : !string.equals(string25))) break block20;
                String string26 = mother;
                String string27 = "U";
                if (!(string26 == null ? string27 != null : !string26.equals(string27))) break block20;
                String string28 = father;
                String string29 = "U";
                if (string28 != null ? !string28.equals(string29) : string29 != null) break block19;
            }
            return "0";
        }
        return "1";
    }

    public String ihe(String child, String father, String mother) {
        String cGT = (String)this.iupac2GTs().apply((Object)child);
        String fGT = (String)this.iupac2GTs().apply((Object)father);
        String mGT = (String)this.iupac2GTs().apply((Object)mother);
        if (fGT.indexOf(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(cGT), 0)) >= 0 && mGT.indexOf(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(cGT), 1)) >= 0) {
            return "0";
        }
        if (fGT.indexOf(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(cGT), 1)) >= 0 && mGT.indexOf(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(cGT), 0)) >= 0) {
            return "0";
        }
        return "1";
    }

    public String gtStat(String iChild, String iFactor, String iMother) {
        String string = iChild;
        String string2 = "";
        String c = !(string != null ? !string.equals(string2) : string2 != null) ? "U" : iChild;
        String string3 = iFactor;
        String string4 = "";
        String f = !(string3 != null ? !string3.equals(string4) : string4 != null) ? "U" : iFactor;
        String string5 = iMother;
        String string6 = "";
        String m = !(string5 != null ? !string5.equals(string6) : string6 != null) ? "U" : iMother;
        String string7 = this.ihe(c, f, m);
        String string8 = "1";
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            return "0";
        }
        String string9 = this.phaseKnown(c, f, m);
        String string10 = "1";
        if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
            return "2";
        }
        return "1";
    }

    public String varSignature(String ref, String alt) {
        int i;
        int a = 0;
        int g = 0;
        int c = 0;
        int t = 0;
        for (i = 0; i < alt.length(); ++i) {
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(alt), i) == 'A') {
                ++a;
                continue;
            }
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(alt), i) == 'G') {
                ++g;
                continue;
            }
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(alt), i) == 'C') {
                ++c;
                continue;
            }
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(alt), i) != 'T') continue;
            ++t;
        }
        for (i = 0; i < ref.length(); ++i) {
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(ref), i) == 'A') {
                --a;
                continue;
            }
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(ref), i) == 'G') {
                --g;
                continue;
            }
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(ref), i) == 'C') {
                --c;
                continue;
            }
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(ref), i) != 'T') continue;
            --t;
        }
        return new StringBuilder(4).append("A").append(a).append("C").append(c).append("G").append(g).append("T").append(t).toString();
    }

    public String generateVarSeq(String refSeq, int refPos, int allRefSize, String alleles, int allelePos, int alleleStart, int alleleStop) {
        int p;
        int alleleLength = alleleStop - alleleStart;
        int startDiff = allelePos - refPos;
        int seqLength = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(refSeq.length()), allRefSize) + alleleLength - allRefSize;
        int insSize = alleleLength - allRefSize;
        scala.collection.mutable.StringBuilder bases = new scala.collection.mutable.StringBuilder(seqLength);
        for (p = 0; p < startDiff; ++p) {
            bases.append(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(refSeq), p));
        }
        while (p < alleleLength + startDiff) {
            bases.append(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(alleles), p - startDiff + alleleStart));
            ++p;
        }
        while (p < seqLength) {
            bases.append(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(refSeq), p - insSize));
            ++p;
        }
        return bases.toString();
    }

    public boolean sameVarSeqs(String varSeq1, String refSeq, int refPos, int allRefSize, String alleles, int allelePos, int alleleStart, int allleleStop) {
        int alleleLength = allleleStop - alleleStart;
        int startDiff = allelePos - refPos;
        int seqLength = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(refSeq.length()), allRefSize) + alleleLength - allRefSize;
        int insSize = alleleLength - allRefSize;
        int p = 0;
        int p1 = 0;
        int vl = varSeq1.length() - 1;
        while (p < startDiff) {
            if (p1 > vl || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(varSeq1), p1) != StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(refSeq), p)) {
                return false;
            }
            ++p;
            ++p1;
        }
        while (p < alleleLength + startDiff) {
            if (p1 > vl || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(varSeq1), p1) != StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(alleles), p - startDiff + alleleStart)) {
                return false;
            }
            ++p;
            ++p1;
        }
        while (p < seqLength) {
            if (p1 > vl || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(varSeq1), p1) != StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(refSeq), p - insSize)) {
                return false;
            }
            ++p;
            ++p1;
        }
        return p1 == varSeq1.length();
    }

    public String mergedReference(int pos1, String ref1, int pos2, String ref2, RefSeq refSeq, String theChrom) {
        int start = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(pos1), pos2);
        int stop = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(pos1 + ref1.length() - 1), pos2 + ref2.length() - 1);
        scala.collection.mutable.StringBuilder seq = new scala.collection.mutable.StringBuilder(stop - start + 1);
        seq.length_$eq(stop - start + 1);
        for (int p = start; p <= stop; ++p) {
            if (p - pos1 >= 0 && p - pos1 < ref1.length()) {
                seq.setCharAt(p - start, StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(ref1), p - pos1));
                continue;
            }
            if (p - pos2 >= 0 && p - pos2 < ref2.length()) {
                seq.setCharAt(p - start, StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(ref2), p - pos2));
                continue;
            }
            if (refSeq == null) {
                seq.setCharAt(p - start, 'N');
                continue;
            }
            seq.setCharAt(p - start, RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(refSeq.getBase(theChrom, p))));
        }
        return seq.toString();
    }

    public int[] cvsSplitArray(String s) {
        int i;
        int n = 0;
        int cols = 1;
        for (i = 0; i < s.length(); ++i) {
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), i) != ',' && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), i) != '/' && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), i) != '|') continue;
            ++cols;
        }
        n = 0;
        int[] seps = new int[cols];
        for (i = 0; i < s.length() && n < cols; ++i) {
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), i) != ',' && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), i) != '/' && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), i) != '|') continue;
            seps[n] = i;
            ++n;
        }
        seps[n] = i;
        return seps;
    }

    public int compareVCFgt(int pos1, String ref1, String alleles1, int pos2, String ref2, String alleles2, RefSeq refSeq, String theChrom) {
        String string = ref1;
        String string2 = alleles1;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = ref2;
            String string4 = alleles2;
            if (!(string3 != null ? !string3.equals(string4) : string4 != null) && pos1 == pos2) {
                return 1;
            }
            return 0;
        }
        if (ref1.length() == 1 && alleles1.length() == 1 && ref2.length() == 1 && alleles2.length() == 1) {
            if (pos1 == pos2) {
                String string5 = alleles1;
                String string6 = alleles2;
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    return 1;
                }
            }
            return 0;
        }
        if (pos1 == pos2) {
            String string7 = alleles1;
            String string8 = alleles2;
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                String string9 = ref1;
                String string10 = ref2;
                if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                    return 1;
                }
            }
        }
        int[] allIndex1 = this.cvsSplitArray(alleles1);
        int[] allIndex2 = this.cvsSplitArray(alleles2);
        int mergePos = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(pos1), pos2);
        String mergedRef = this.mergedReference(pos1, ref1, pos2, ref2, refSeq, theChrom);
        int ssame = 0;
        int tests = 0;
        int allOne = 0;
        while (allOne < allIndex1.length) {
            int allOneStart = allOne == 0 ? 0 : allIndex1[allOne - 1] + 1;
            int allTwo = 0;
            int nsame = 0;
            while (allTwo < allIndex2.length) {
                int allTwoStart = allTwo == 0 ? 0 : allIndex2[allTwo - 1] + 1;
                String varSeq1 = this.generateVarSeq(mergedRef, mergePos, ref1.length(), alleles1, pos1, allOneStart, allIndex1[allOne]);
                if (this.sameVarSeqs(varSeq1, mergedRef, mergePos, ref2.length(), alleles2, pos2, allTwoStart, allIndex2[allTwo])) {
                    ++nsame;
                }
                ++allTwo;
                ++tests;
            }
            ++allOne;
            if (nsame <= false) continue;
            ++ssame;
        }
        if (tests > 2 && ssame > 1) {
            return 2;
        }
        if (tests == 2 && ssame > 1) {
            return 1;
        }
        if (ssame > 0) {
            return 1;
        }
        return 0;
    }

    public int allelesFoundVCF(int pos1, String ref1, String alleles1, int pos2, String ref2, String alleles2, RefSeq refSeq, String theChrom) {
        if (pos2 > pos1 + 10000 || pos1 > pos2 + 10000) {
            return 0;
        }
        if (pos2 > pos1 && pos1 + ref1.length() < pos2 || pos1 > pos2 && pos2 + ref2.length() < pos1) {
            String string = ref1;
            String string2 = alleles1;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = ref2;
                String string4 = alleles2;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    return 0;
                }
            }
        }
        return this.compareVCFgt(pos1, ref1, alleles1, pos2, ref2, alleles2, refSeq, theChrom);
    }

    public String gtStatVCF(int posC, String refC, String allelesC, int posF, String refF, String allelesF, int posM, String refM, String allelesM, RefSeq refSeq, String theChrom) {
        String[] childAlleles = allelesC.split("[,|/]");
        if (childAlleles.length == 1) {
            int foundInMother;
            int foundInFather = this.allelesFoundVCF(posC, refC, allelesC, posF, refF, allelesF, refSeq, theChrom);
            if (foundInFather + (foundInMother = this.allelesFoundVCF(posC, refC, allelesC, posM, refM, allelesM, refSeq, theChrom)) >= 2) {
                return "2";
            }
            return "0";
        }
        int foundInFather1 = this.allelesFoundVCF(posC, refC, childAlleles[0], posF, refF, allelesF, refSeq, theChrom);
        int foundInMother1 = this.allelesFoundVCF(posC, refC, childAlleles[0], posM, refM, allelesM, refSeq, theChrom);
        int foundInFather2 = this.allelesFoundVCF(posC, refC, childAlleles[1], posF, refF, allelesF, refSeq, theChrom);
        int foundInMother2 = this.allelesFoundVCF(posC, refC, childAlleles[1], posM, refM, allelesM, refSeq, theChrom);
        if (allelesC.indexOf(124) > -1 && (foundInFather1 > 0 && foundInMother2 > 9 || foundInFather2 > 0 && foundInMother1 > 0)) {
            return "2";
        }
        if (foundInFather1 > 0 && foundInMother1 == 0 && foundInMother2 > 0) {
            return "2";
        }
        if (foundInFather2 > 0 && foundInMother2 == 0 && foundInMother1 > 0) {
            return "2";
        }
        if (foundInMother1 > 0 && foundInFather1 == 0 && foundInFather2 > 0) {
            return "2";
        }
        if (foundInMother2 > 0 && foundInFather2 == 0 && foundInFather1 > 0) {
            return "2";
        }
        if (foundInFather1 + foundInMother1 >= 2 && foundInFather2 + foundInMother2 >= 2) {
            return "1";
        }
        return "0";
    }

    public String fatherGTVCF(int posC, String refC, String allelesC, int posF, String refF, String allelesF, int posM, String refM, String allelesM, RefSeq refSeq, String theChrom) {
        String[] childAlleles = allelesC.split("[,|/]");
        if (childAlleles.length == 1) {
            return childAlleles[0];
        }
        if (allelesC.indexOf(124) > -1) {
            return childAlleles[0];
        }
        int foundInFather1 = this.allelesFoundVCF(posC, refC, childAlleles[0], posF, refF, allelesF, refSeq, theChrom);
        int foundInMother1 = this.allelesFoundVCF(posC, refC, childAlleles[0], posM, refM, allelesM, refSeq, theChrom);
        int foundInFather2 = this.allelesFoundVCF(posC, refC, childAlleles[1], posF, refF, allelesF, refSeq, theChrom);
        int foundInMother2 = this.allelesFoundVCF(posC, refC, childAlleles[1], posM, refM, allelesM, refSeq, theChrom);
        if (foundInFather1 > 0 && foundInMother1 <= 0) {
            return childAlleles[0];
        }
        if (foundInFather2 > 0 && foundInMother2 <= 0) {
            return childAlleles[1];
        }
        int motherAllele = -1;
        if (foundInMother1 > 0 && foundInFather1 <= 0) {
            motherAllele = 0;
        }
        if (foundInMother2 > 0 && foundInFather2 <= 0) {
            motherAllele = 1;
        }
        if (motherAllele != 0) {
            return childAlleles[0];
        }
        if (motherAllele != 1) {
            return childAlleles[1];
        }
        return childAlleles[0];
    }

    public String motherGTVCF(int posC, String refC, String allelesC, int posF, String refF, String allelesF, int posM, String refM, String allelesM, RefSeq refSeq, String theChrom) {
        String[] childAlleles = allelesC.split("[,|/]");
        if (childAlleles.length == 1) {
            return childAlleles[0];
        }
        if (allelesC.indexOf(124) > -1) {
            return childAlleles[1];
        }
        int foundInFather1 = this.allelesFoundVCF(posC, refC, childAlleles[0], posF, refF, allelesF, refSeq, theChrom);
        int foundInMother1 = this.allelesFoundVCF(posC, refC, childAlleles[0], posM, refM, allelesM, refSeq, theChrom);
        int foundInFather2 = this.allelesFoundVCF(posC, refC, childAlleles[1], posF, refF, allelesF, refSeq, theChrom);
        int foundInMother2 = this.allelesFoundVCF(posC, refC, childAlleles[1], posM, refM, allelesM, refSeq, theChrom);
        if (foundInMother1 > 0 && foundInFather1 <= 0) {
            return childAlleles[0];
        }
        if (foundInMother2 > 0 && foundInFather2 <= 0) {
            return childAlleles[1];
        }
        int fatherAllele = -1;
        if (foundInFather1 > 0 && foundInMother1 <= 0) {
            fatherAllele = 0;
        }
        if (foundInFather2 > 0 && foundInMother2 <= 0) {
            fatherAllele = 1;
        }
        if (fatherAllele != 1) {
            return childAlleles[1];
        }
        if (fatherAllele != 0) {
            return childAlleles[0];
        }
        return childAlleles[1];
    }

    public static final /* synthetic */ void $anonfun$new$4(Tuple2 x$2, String t) {
        ParseUtilities$.MODULE$.codon2aminoAcidLookupLong()[ParseUtilities$.MODULE$.aminoAcid2Integer((String)t)] = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString((String)x$2._2()), 0, 3);
        ParseUtilities$.MODULE$.codon2aminoAcidLookupShort()[ParseUtilities$.MODULE$.aminoAcid2Integer((String)t)] = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString((String)x$2._2()), 4, 5);
    }

    public static final /* synthetic */ void $anonfun$new$2(Tuple2 x) {
        String[] xx = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)x._1())).split(','))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ParseUtilities$.MODULE$.codon2aminoAcidLookupLong()[0] = "???";
        ParseUtilities$.MODULE$.codon2aminoAcidLookupShort()[0] = "?";
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xx)).foreach((Function1 & Serializable & scala.Serializable)t -> {
            ParseUtilities$.$anonfun$new$4(x, t);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ char $anonfun$reverseComplement$1(char x) {
        char temp = MODULE$.complementPairsMap()[x];
        if (temp == '#') {
            return x;
        }
        return temp;
    }

    private ParseUtilities$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.complementPairsMap = new char[256];
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.complementPairsMap().length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ParseUtilities$.MODULE$.complementPairsMap()[i - 1] = 35;
        });
        this.complementPairsMap()[97] = 116;
        this.complementPairsMap()[116] = 97;
        this.complementPairsMap()[99] = 103;
        this.complementPairsMap()[103] = 99;
        this.complementPairsMap()[110] = 110;
        this.complementPairsMap()[117] = 117;
        this.complementPairsMap()[41] = 40;
        this.complementPairsMap()[65] = 84;
        this.complementPairsMap()[84] = 65;
        this.complementPairsMap()[67] = 71;
        this.complementPairsMap()[71] = 67;
        this.complementPairsMap()[78] = 78;
        this.complementPairsMap()[85] = 85;
        this.complementPairsMap()[40] = 41;
        this.iupac2GTs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"A"), (Object)"AA"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C"), (Object)"CC"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"G"), (Object)"GG"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"T"), (Object)"TT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"M"), (Object)"AC"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"R"), (Object)"AG"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"W"), (Object)"AT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"S"), (Object)"CG"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Y"), (Object)"CT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"K"), (Object)"GT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"N"), (Object)"ACGT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"U"), (Object)"ACGT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"ACGT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-"), (Object)"ACGT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"?"), (Object)"ACGT")}));
        this.codon2aminoacid = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"GCT, GCC, GCA, GCG"), (Object)"Ala/A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CGT, CGC, CGA, CGG, AGA, AGG"), (Object)"Arg/R"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"AAT, AAC"), (Object)"Asn/N"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"GAT, GAC"), (Object)"Asp/D"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TGT, TGC"), (Object)"Cys/C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CAA, CAG"), (Object)"Gln/Q"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"GAA, GAG"), (Object)"Glu/E"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"GGT, GGC, GGA, GGG"), (Object)"Gly/G"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CAT, CAC"), (Object)"His/H"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ATT, ATC, ATA"), (Object)"Ile/I"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ATG"), (Object)"Met/M"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TTA, TTG, CTT, CTC, CTA, CTG"), (Object)"Leu/L"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"AAA, AAG"), (Object)"Lys/K"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ATG"), (Object)"Met/M"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TTT, TTC"), (Object)"Phe/F"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CCT, CCC, CCA, CCG"), (Object)"Pro/P"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TCT, TCC, TCA, TCG, AGT, AGC"), (Object)"Ser/S"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ACT, ACC, ACA, ACG"), (Object)"Thr/T"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TGG"), (Object)"Trp/W"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TAT, TAC"), (Object)"Tyr/Y"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"GTT, GTC, GTA, GTG"), (Object)"Val/V"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TAA, TGA, TAG"), (Object)"STO/X")}));
        this.codon2aminoAcidLookupLong = new String[65];
        this.codon2aminoAcidLookupShort = new String[65];
        this.codon2aminoacid().foreach((Function1 & Serializable & scala.Serializable)x -> {
            ParseUtilities$.$anonfun$new$2(x);
            return BoxedUnit.UNIT;
        });
        this.byteArray = new byte[2000];
    }
}

