/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor;

import gorsat.Commands.CommandParseUtilities;
import gorsat.Script.ExecutionBlock;
import gorsat.Script.ExecutionGraph;
import gorsat.Utilities.MacroUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gorpipe.exceptions.GorException;
import org.gorpipe.gor.SemanticChecker;
import org.gorpipe.gor.session.GorScriptTask;
import scala.collection.immutable.List;

public class GorScriptAnalyzer {
    private final String input;
    private Map<String, GorScriptTask> tasksByName = new HashMap<String, GorScriptTask>();
    private java.util.List<java.util.List<GorScriptTask>> tasksByLevel = new ArrayList<java.util.List<GorScriptTask>>();
    private java.util.List<GorScriptTask> extraTasks = new ArrayList<GorScriptTask>();
    private GorException exception;

    public GorScriptAnalyzer(String input) {
        this.input = input;
    }

    public void semanticCheck() {
        SemanticChecker semanticChecker = new SemanticChecker();
        semanticChecker.validate(this.input);
    }

    public GorException getException() {
        return this.exception;
    }

    public Map<String, GorScriptTask> getTasksByName() {
        return this.tasksByName;
    }

    public java.util.List<java.util.List<GorScriptTask>> getTasksByLevel() {
        return this.tasksByLevel;
    }

    public Collection<GorScriptTask> getTasks() {
        this.tasksByName = new HashMap<String, GorScriptTask>();
        this.tasksByLevel = new ArrayList<java.util.List<GorScriptTask>>();
        String[] rawCommands = CommandParseUtilities.quoteSafeSplitAndTrim((String)this.input, (char)';');
        for (int i = 0; i < rawCommands.length; ++i) {
            rawCommands[i] = CommandParseUtilities.cleanupQuery((String)rawCommands[i]);
        }
        Map<String, String> aliases = MacroUtilities.extractAliases(rawCommands);
        String[] commands = MacroUtilities.applyAliases(rawCommands, aliases);
        ExecutionGraph executionGraph = new ExecutionGraph(commands);
        this.convertExecutionGraph(executionGraph);
        return this.tasksByName.values();
    }

    public java.util.List<GorScriptTask> getExtraTasks() {
        return this.extraTasks;
    }

    private void convertExecutionGraph(ExecutionGraph executionGraph) {
        List<ExecutionBlock>[] levels = executionGraph.levels();
        for (int level = 0; level < levels.length; ++level) {
            List<ExecutionBlock> blocksInLevel = levels[level];
            ArrayList tasksInLevel = new ArrayList();
            int levelForLambda = level + 1;
            blocksInLevel.foreach(block -> {
                GorScriptTask task = this.getGorScriptTask((ExecutionBlock)block);
                task.level = levelForLambda;
                this.tasksByName.put(task.name, task);
                tasksInLevel.add(task);
                return null;
            });
            this.tasksByLevel.add(tasksInLevel);
        }
        this.extraTasks = new ArrayList<GorScriptTask>();
        executionGraph.remainingBlocks().values().forEach(block -> this.extraTasks.add(this.getGorScriptTask((ExecutionBlock)block)));
    }

    private GorScriptTask getGorScriptTask(ExecutionBlock block) {
        GorScriptTask task = new GorScriptTask();
        task.name = "[" + block.groupName() + "]";
        task.query = block.query();
        task.dependsOn = block.dependencies();
        return task;
    }
}

