/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.session.EventLogger;
import org.gorpipe.gor.session.GorContext;
import org.gorpipe.gor.session.GorScriptTask;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.gor.stats.StatsCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestStats
implements EventLogger {
    private static final Logger log = LoggerFactory.getLogger(RequestStats.class);
    protected Map<String, GorScriptTask> nodes = new HashMap<String, GorScriptTask>();
    protected Map<String, StatsCollector> stats = new HashMap<String, StatsCollector>();
    protected Map<String, String> createdFiles = new HashMap<String, String>();
    protected int iteratorsCreated = 0;
    protected String query;
    protected final GorSession session;
    protected final String localHostName;

    public RequestStats(GorSession session) {
        log.info("RequestStats - {}", (Object)session);
        this.session = session;
        try {
            this.localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new GorSystemException("Cannot get local host name", (Throwable)e);
        }
    }

    public EventLogger.SessionInfo getInfo() {
        GorContext topLevelContext = this.session.getGorContext();
        EventLogger.SessionInfo sessionInfo = new EventLogger.SessionInfo();
        sessionInfo.requestId = this.session.getRequestId();
        sessionInfo.query = this.query;
        sessionInfo.startedAt = topLevelContext.getStartedAt();
        sessionInfo.endedAt = topLevelContext.getEndedAt();
        this.stats.put("session", topLevelContext.getStats());
        this.addContextStats(topLevelContext);
        sessionInfo.stats = this.stats;
        sessionInfo.tasks = this.nodes;
        sessionInfo.createdFiles = this.createdFiles;
        sessionInfo.iteratorsCreated = this.iteratorsCreated;
        return sessionInfo;
    }

    private void addContextStats(GorContext ctx) {
        this.stats.put(ctx.getName(), ctx.getStats());
        for (GorContext nested : ctx.getNestedContexts()) {
            this.addContextStats(nested);
        }
    }

    protected void nodeAddedOrUpdated(GorScriptTask task) {
    }

    protected void statsAdded(String signature, StatsCollector stats) {
    }

    public void tasks(Collection<GorScriptTask> tasks) {
        tasks.forEach(t -> {
            GorScriptTask task = this.nodes.computeIfAbsent(t.name, k -> new GorScriptTask());
            task.update(t);
            this.nodeAddedOrUpdated(task);
        });
    }

    public void query(String query) {
        this.query = query;
    }

    public void commandCreated(String name, String origin, String commandSignature, String commandToExecute) {
        log.info("commandCreated: {} - {}", (Object)commandSignature, (Object)commandToExecute);
        GorScriptTask task = this.nodes.computeIfAbsent(name, k -> new GorScriptTask());
        task.name = name;
        task.origin = origin;
        task.signature = commandSignature;
        task.commandExecuted = commandToExecute;
        this.nodeAddedOrUpdated(task);
    }

    public void commandStarted(String name, String commandSignature, String cacheFile, String commandToExecute) {
        log.info("commandStarted: {} - {}", (Object)commandSignature, (Object)commandToExecute);
        GorScriptTask task = this.nodes.computeIfAbsent(name, k -> new GorScriptTask());
        task.name = name;
        task.signature = commandSignature;
        task.startedAt = System.currentTimeMillis();
        task.host = this.localHostName;
        task.thread = Thread.currentThread().getName();
        task.cacheFile = cacheFile;
        task.commandExecuted = commandToExecute;
        this.createdFiles.put(cacheFile, name);
        this.nodeAddedOrUpdated(task);
    }

    public void commandEnded(String name) {
        GorScriptTask task = this.nodes.get(name);
        if (task != null) {
            log.info("commandEnded: {})", (Object)name);
            task.endedAt = System.currentTimeMillis();
            this.nodeAddedOrUpdated(task);
        } else {
            log.warn("commandEnded: {} is unknown)", (Object)name);
        }
    }

    public void commandCached(String name, String cacheFile) {
        GorScriptTask task = this.nodes.get(name);
        if (task != null) {
            log.info("commandCached: {})", (Object)name);
            task.endedAt = System.currentTimeMillis();
            task.cacheFile = cacheFile;
            task.cached = true;
            this.nodeAddedOrUpdated(task);
        } else {
            log.warn("commandCached: {} is unknown)", (Object)name);
        }
    }

    public synchronized void iteratorCreated(String args) {
        ++this.iteratorsCreated;
    }

    public void endSession() {
        this.session.getGorContext().end();
        this.addContextStats(this.session.getGorContext());
    }

    public StatsCollector getStatsCollector() {
        return new StatsCollector();
    }

    public void saveToJson() throws IOException {
        QueryInfo queryInfo = new QueryInfo();
        queryInfo.requestId = this.session.getRequestId();
        queryInfo.tasks = this.nodes;
        queryInfo.stats = this.stats;
        queryInfo.createdFiles = this.createdFiles;
        String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)queryInfo);
        String fileName = "gor-stats-" + this.session.getRequestId() + ".json";
        FileUtils.writeStringToFile((File)new File(fileName), (String)json, (Charset)Charset.defaultCharset());
    }

    static class QueryInfo {
        public String requestId;
        public Map<String, GorScriptTask> tasks = new HashMap<String, GorScriptTask>();
        public Map<String, StatsCollector> stats = new HashMap<String, StatsCollector>();
        public Map<String, String> createdFiles = new HashMap<String, String>();

        QueryInfo() {
        }
    }
}

