/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.manager;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gorpipe.gor.manager.BucketCreator;
import org.gorpipe.gor.table.GorPipeUtils;
import org.gorpipe.gor.table.dictionary.BaseDictionaryTable;
import org.gorpipe.gor.table.dictionary.DictionaryEntry;
import org.gorpipe.gor.table.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketCreatorGorPipe<T extends DictionaryEntry>
implements BucketCreator<T> {
    private static final Logger log = LoggerFactory.getLogger(BucketCreatorGorPipe.class);
    public static final int DEFAULT_NUMBER_WORKERS = 4;
    private final int workers;

    public BucketCreatorGorPipe() {
        this(4);
    }

    public BucketCreatorGorPipe(int workers) {
        this.workers = workers;
    }

    @Override
    public void createBucketsForBucketDir(BaseDictionaryTable<T> table, Map<String, List<T>> bucketsToCreate, URI absBucketDir) throws IOException {
        String gorPipeCommand = this.createBucketizeGorCommandForBucketDir(bucketsToCreate, absBucketDir, table);
        GorPipeUtils.executeGorPipeForSideEffects(gorPipeCommand, this.workers, table.getProjectPath(), table.getSecurityContext());
    }

    private String createBucketizeGorCommandForBucketDir(Map<String, List<T>> bucketsToCreate, URI absBucketDir, BaseDictionaryTable<T> table) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<T>> b2c : bucketsToCreate.entrySet()) {
            String bucket = b2c.getKey();
            String tags = b2c.getValue().stream().flatMap(e -> Arrays.stream(e.getFilterTags()).distinct()).distinct().collect(Collectors.joining(","));
            if (tags.length() <= 0) continue;
            sb.append(String.format("create #%s# = gor %s -s %s -f %s %s | write -c %s;%n", bucket, table.getPath(), table.getSourceColumn(), tags, table.getSecurityContext() != null ? table.getSecurityContext() : "", PathUtils.resolve((URI)absBucketDir, (String)PathUtils.getFileName((String)bucket))));
        }
        sb.append("gor 1.mem| top 1\n");
        return sb.toString();
    }
}

