/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.table;

import gorsat.process.CLIGorExecutionEngine;
import gorsat.process.PipeOptions;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GorPipeUtils {
    private static final Logger log = LoggerFactory.getLogger(GorPipeUtils.class);

    public static void executeGorPipeForSideEffects(String gorPipeCommand, int workers, String gorroot, String securityContext) {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(gorPipeCommand);
        argsList.add("-workers");
        argsList.add(String.valueOf(workers));
        if (gorroot != null) {
            argsList.add("-gorroot");
            argsList.add(gorroot);
        }
        Object[] args = argsList.toArray(new String[argsList.size()]);
        log.trace("Calling gor command with command args: {} \"{}\" {} {} {} {}", args);
        PrintStream oldOut = System.out;
        PipeOptions options = new PipeOptions();
        options.parseOptions((String[])args);
        CLIGorExecutionEngine engine = new CLIGorExecutionEngine(options, null, securityContext);
        try (PrintStream newPrintStream = new PrintStream((OutputStream)new NullOutputStream());){
            System.setOut(newPrintStream);
            engine.execute();
        }
        catch (Exception e) {
            log.error("Calling gor cmmand failed.  Command args: {} \"{}\" {} {} {} {} failed", args);
            throw e;
        }
        finally {
            System.setOut(oldOut);
        }
    }
}

