/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.table.files;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.model.RowBase;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.GorPipeUtils;
import org.gorpipe.gor.table.TableHeader;
import org.gorpipe.gor.table.TableLog;
import org.gorpipe.gor.table.dictionary.DictionaryEntry;
import org.gorpipe.gor.table.dictionary.TableEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileTable<T extends Row>
extends BaseTable<T> {
    private static final Logger log = LoggerFactory.getLogger(FileTable.class);
    protected String tempOutFilePath;

    public FileTable(BaseTable.Builder builder) {
        super(builder);
        this.init();
    }

    public FileTable(URI uri, FileReader inputFileReader) {
        super(uri, inputFileReader);
        this.init();
    }

    private void init() {
        this.header = new TableHeader();
        if (this.fileReader.exists(this.getPath().toString())) {
            this.validateFile(this.getPath().toString());
        }
        this.reload();
    }

    public Stream<String> getLines() {
        try {
            BufferedReader reader = this.fileReader.getReader(this.getMainFile());
            Stream<String> stream = reader.lines();
            stream.onClose(() -> {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            return stream;
        }
        catch (IOException e) {
            throw new GorSystemException("Error getting file reader", (Throwable)e);
        }
    }

    public void insert(Collection<T> lines) {
        Path tempInputFile;
        try {
            tempInputFile = this.createInputTempFile(lines);
        }
        catch (IOException e) {
            throw new GorSystemException("Could not create temp file for inserting data", (Throwable)e);
        }
        this.insertFiles(tempInputFile.toString());
        this.logAfter(TableLog.LogAction.INSERT, "", (String[])lines.stream().map(l -> l.otherCols()).toArray(String[]::new));
    }

    public void insert(String ... lines) {
        List<T> entries = this.lineStringsToEntries(lines);
        this.insert(entries);
    }

    public void insertEntries(Collection<DictionaryEntry> entries) {
        this.insertFiles((String[])entries.stream().map(TableEntry::getContentReal).toArray(String[]::new));
    }

    protected void insertFiles(String ... gorFiles) {
        if (this.isValidateFiles()) {
            for (String gorFile : gorFiles) {
                this.validateFile(gorFile);
            }
        }
        String outFile = this.getNewTempFileName();
        String gorPipeCommand = this.createInsertTempFileCommand(this.getMainFile(), outFile, gorFiles);
        GorPipeUtils.executeGorPipeForSideEffects(gorPipeCommand, 1, this.getProjectPath(), this.fileReader.getSecurityContext());
        this.tempOutFilePath = outFile;
    }

    public void delete(Collection<T> lines) {
        this.createDeleteTempFile((String[])lines.stream().map(l -> l.getAllCols().toString()).toArray(String[]::new));
        throw new GorSystemException("DeleteEntries not supported yet for FileTable", null);
    }

    public void delete(String ... lines) {
        this.createDeleteTempFile(lines);
    }

    public void deleteEntries(Collection<DictionaryEntry> entries) {
        throw new GorSystemException("DeleteEntries not supported yet for FileTable", null);
    }

    protected void createDeleteTempFile(String ... lines) {
        String localTempPath = this.getNewTempFileName();
        String[] strippedLines = (String[])Arrays.stream(lines).map(line -> line.endsWith("\n") ? line.substring(0, line.length() - 1) : line).toArray(String[]::new);
        try (OutputStream os = this.fileReader.getOutputStream(localTempPath);
             Stream<String> stream = this.getLines();){
            stream.filter(l -> this.includeLine((String)l, strippedLines)).forEach(l -> this.writeOutLine(os, (String)l));
        }
        catch (IOException e) {
            throw new GorSystemException((Throwable)e);
        }
        this.tempOutFilePath = localTempPath;
    }

    private void writeOutLine(OutputStream os, String line) {
        try {
            os.write(line.getBytes(StandardCharsets.UTF_8));
            os.write(10);
        }
        catch (IOException e) {
            throw new GorSystemException((Throwable)e);
        }
    }

    private boolean includeLine(String line, String[] skipLines) {
        for (String skipLine : skipLines) {
            if (!line.equals(skipLine)) continue;
            return false;
        }
        return true;
    }

    protected List<T> lineStringsToEntries(String[] lines) {
        ArrayList<T> entries = new ArrayList<T>();
        for (String line : lines) {
            if (line.trim().isEmpty() || line.startsWith("#")) continue;
            entries.add(this.createRow(line));
        }
        return entries;
    }

    protected T createRow(String line) {
        return (T)new RowBase((CharSequence)(line.endsWith("\n") ? line.substring(0, line.length() - 1) : line));
    }

    protected abstract String getInputTempFileEnding();

    protected abstract String getGorCommand();

    public void saveTempMainFile() {
        log.debug(String.format("Saving temp file (%s)to temp main file (%s) ", this.tempOutFilePath, this.getTempMainFileName()));
        try {
            if (this.tempOutFilePath != null && this.getFileReader().exists(this.tempOutFilePath.toString())) {
                this.updateFromTempFile(this.tempOutFilePath.toString(), this.getTempMainFileName());
                this.tempOutFilePath = null;
                this.getFileReader().deleteDirectory(this.getTransactionFolderPath().toString());
            } else if (!this.getFileReader().exists(this.getPath().toString())) {
                this.writeToFile(Path.of(this.getTempMainFileName(), new String[0]), new ArrayList());
            }
        }
        catch (IOException e) {
            throw new GorSystemException("Could not save table", (Throwable)e);
        }
    }

    public void initialize() {
        super.initialize();
    }

    protected Path getTransactionFolderPath() {
        return Path.of(this.getFolderPath().toString(), "transactions");
    }

    protected void writeToFile(Path filePath, Collection<T> lines) throws IOException {
        try (OutputStream os = this.fileReader.getOutputStream(filePath.toString());){
            os.write(35);
            os.write(Stream.of(this.getColumns()).collect(Collectors.joining("\t")).getBytes(StandardCharsets.UTF_8));
            os.write(10);
            for (Row r : lines) {
                this.writeRowToStream(r, os);
                os.write(10);
            }
        }
    }

    protected void writeRowToStream(Row r, OutputStream os) throws IOException {
        r.writeRowToStream(os);
    }

    protected abstract String createInsertTempFileCommand(String var1, String var2, String ... var3);

    protected String getPostProcessing() {
        Object insertPostProcessing = this.getHeader().getProperty("SELECT_TRANSFORM", "");
        if (!((String)insertPostProcessing).isEmpty() && !((String)insertPostProcessing).trim().startsWith("|")) {
            insertPostProcessing = "| " + (String)insertPostProcessing;
        }
        return insertPostProcessing;
    }

    private Path createInputTempFile(Collection<T> lines) throws IOException {
        String randomString = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
        Path tempFilePath = this.getTransactionFolderPath().resolve("insert_temp_" + randomString + this.getInputTempFileEnding());
        this.fileReader.createDirectories(tempFilePath.getParent().toString(), new FileAttribute[0]);
        this.writeToFile(tempFilePath, lines);
        return tempFilePath;
    }

    private String getNewTempFileName() {
        String randomString = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
        return this.getTransactionFolderPath().resolve(String.format("result_temp_%s.%s", randomString, FilenameUtils.getExtension((String)this.getPath().toString()))).toString();
    }

    protected String getMainFile() {
        String mainFile = this.tempOutFilePath == null ? this.getPath().toString() : this.tempOutFilePath;
        return mainFile;
    }
}

