/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs;

import java.util.HashMap;
import java.util.Map;

public class ArgumentType {
    private static final Map<String, ArgumentType> TYPE_MAP = new HashMap<String, ArgumentType>();
    public final Integer defaultDisplayWidth;
    private final int ordinal;
    private final String name;
    public static final int DATE_ORDINAL = 0;
    public static final ArgumentType DATE = new ArgumentType(0, "DATE");
    public static final int NUMBER_ORDINAL = 1;
    public static final ArgumentType NUMBER = new ArgumentType(1, "NUMBER", 150);
    public static final int STRING_ORDINAL = 2;
    public static final ArgumentType STRING = new ArgumentType(2, "STRING");
    public static final int FILE_ORDINAL = 3;
    public static final ArgumentType FILE = new ArgumentType(3, "FILE");
    public static final int POSITION_RANGE_ORDINAL = 4;
    public static final ArgumentType POSITION_RANGE = new ArgumentType(4, "POSITION_RANGE", 200);
    public static final int PN_LISTS_ORDINAL = 5;
    public static final ArgumentType PN_LISTS = new ArgumentType(5, "PN_LISTS");
    public static final int FILTERED_PN_LISTS_ORDINAL = 6;
    public static final ArgumentType FILTERED_PN_LISTS = new ArgumentType(6, "FILTERED_PN_LISTS");
    public static final int SLIDER_ORDINAL = 7;
    public static final ArgumentType SLIDER = new ArgumentType(7, "SLIDER");
    public static final int VIRTUAL_PN_FILE_ORDINAL = 8;
    public static final ArgumentType VIRTUAL_PN_FILE = new ArgumentType(8, "VIRTUAL_PN_FILE");
    public static final int GRID_ORDINAL = 9;
    public static final ArgumentType GRID = new ArgumentType(9, "GRID", 250);
    public static final int GOR_GRID_ORDINAL = 10;
    public static final ArgumentType GOR_GRID = new ArgumentType(10, "GOR_GRID", 250);
    public static final int VALUE_GRID_ORDINAL = 11;
    public static final ArgumentType VALUE_GRID = new ArgumentType(11, "VALUE_GRID", 250);
    public static final int PN_LISTS_ENTRIES_ORDINAL = 12;
    public static final ArgumentType PN_LISTS_ENTRIES = new ArgumentType(12, "PN_LISTS_ENTRIES");
    public static final int GENE_LIST_ORDINAL = 13;
    public static final ArgumentType GENE_LIST = new ArgumentType(13, "GENE_LIST", 250);
    public static final int CHECK_ITEMS_ORDINAL = 14;
    public static final ArgumentType CHECK_ITEMS = new ArgumentType(14, "CHECK_ITEMS", 250);
    public static final int QUERY_ORDINAL = 15;
    public static final ArgumentType QUERY = new ArgumentType(15, "QUERY", 250);

    protected ArgumentType(int ordinal, String name, Integer defaultDisplayWidth) {
        this.ordinal = ordinal;
        this.name = name;
        this.defaultDisplayWidth = defaultDisplayWidth;
        if (TYPE_MAP.containsKey(name)) {
            throw new RuntimeException("Internal error: redefinition of ArgumentType " + name);
        }
        TYPE_MAP.put(name, this);
    }

    protected ArgumentType(int ordinal, String name) {
        this(ordinal, name, null);
    }

    public static ArgumentType valueOf(String name) {
        if (name == null) {
            throw new NullPointerException("");
        }
        ArgumentType type = TYPE_MAP.get(name);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("No ArgumentType " + name);
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name;
    }
}

