/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.NumberFormatter;

public class RangedNumberFormatter
extends NumberFormatter {
    private static final NumberFormat DEFAULT_FORMAT = NumberFormat.getInstance(Locale.US);

    public RangedNumberFormatter(Double min, Double max) {
        super(DEFAULT_FORMAT);
        this.setAllowsInvalid(true);
        this.setCommitsOnValidEdit(true);
        if (min != null) {
            this.setMinimum(min);
        }
        if (max != null) {
            this.setMaximum(max);
        }
        this.setValueClass(Double.class);
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        if (text == null || text.trim().isEmpty()) {
            return null;
        }
        return super.stringToValue(text);
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        return super.valueToString(value);
    }

    static {
        DEFAULT_FORMAT.setGroupingUsed(false);
        DEFAULT_FORMAT.setParseIntegerOnly(false);
        if (DEFAULT_FORMAT instanceof DecimalFormat) {
            ((DecimalFormat)DEFAULT_FORMAT).setDecimalSeparatorAlwaysShown(false);
        }
    }
}

