/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.argument;

import java.net.URI;
import java.util.List;
import org.gorpipe.querydialogs.Argument;
import org.gorpipe.querydialogs.ArgumentDescription;
import org.gorpipe.querydialogs.ArgumentType;
import org.gorpipe.querydialogs.util.ValueFormatter;

public abstract class FormatArgument
extends Argument {
    ValueFormatter formatter;
    boolean quoted;
    String format;

    public FormatArgument(ArgumentType type, ArgumentDescription argDescr, Boolean optional, Object defaultValue, List<?> allowedValues, URI valuesPath, List<String> operators, Boolean advanced, Integer displayWidth) {
        super(type, argDescr, optional, defaultValue, allowedValues, valuesPath, operators, advanced, displayWidth);
    }

    public FormatArgument(Argument arg) {
        super(arg);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormattedValue() {
        String newValue;
        String result;
        String delim;
        if (this.formatter == null) {
            if (this.getValue() == null) {
                return null;
            }
            return this.getValue().toString().trim();
        }
        if (this.getValue() == null || this.getValue().toString().trim().isEmpty()) {
            return this.formatter.format("empty", "");
        }
        StringBuilder sb = new StringBuilder();
        String string = delim = this.quoted ? "','" : ",";
        if (this.quoted) {
            sb.append('\'');
        }
        String value = this.getValue().toString().trim();
        value = this.escapeQuote(value);
        sb.append(String.join((CharSequence)delim, value.split("\\s*,\\s*")));
        if (this.quoted) {
            sb.append('\'');
        }
        if ((result = this.formatter.format(this.format, newValue = sb.toString())) == null) {
            result = this.formatter.format("default", newValue);
        }
        return result;
    }

    private String escapeQuote(String s) {
        if (!s.contains("'")) {
            return s;
        }
        if (!s.contains(",")) {
            return s.replace("'", "\\'");
        }
        StringBuilder sb = new StringBuilder();
        String[] strings = s.split(",");
        for (int i = 0; i < strings.length; ++i) {
            String currentString = strings[i];
            if (currentString.contains("'")) {
                int length = currentString.length();
                char start = currentString.charAt(0);
                char end = currentString.charAt(length - 1);
                if (length == 1 || start != '\'' || end != '\'') {
                    sb.append(currentString.replace("'", "\\'"));
                } else {
                    String middle = currentString.substring(1, length - 1);
                    String middleEscaped = middle.replace("'", "\\'");
                    sb.append(start).append(middleEscaped).append(end);
                }
            } else {
                sb.append(currentString);
            }
            if (i >= strings.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    void setFormattingParameters(ValueFormatter inpFormatter, boolean inpQuoted, String format) {
        this.formatter = inpFormatter;
        this.format = format;
        this.quoted = inpQuoted;
    }

    public ValueFormatter getFormatter() {
        return this.formatter;
    }
}

