/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Analysis;

import gorsat.Analysis.RegressionAnalysis;
import gorsat.Regression.LogisticRegression;
import java.io.Serializable;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.model.gor.RowObj$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001\u0002\u000b\u0016\u0001iA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tc\u0001\u0011\t\u0011)A\u0005e!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!)\u0005A!A!\u0002\u0013y\u0002\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u0011\u001d\u0003!\u0011!Q\u0001\n\tCQ\u0001\u0013\u0001\u0005\u0002%CqA\u0015\u0001C\u0002\u0013\u00051\u000b\u0003\u0004U\u0001\u0001\u0006IA\u0010\u0005\b+\u0002\u0011\r\u0011\"\u0001W\u0011\u0019Q\u0006\u0001)A\u0005/\"I1\f\u0001a\u0001\u0002\u0004%\t\u0001\u0018\u0005\nM\u0002\u0001\r\u00111A\u0005\u0002\u001dD\u0011\"\u001c\u0001A\u0002\u0003\u0005\u000b\u0015B/\t\u000b9\u0004A\u0011I8\t\u000bA\u0004A\u0011I9\t\u000bi\u0004A\u0011B>\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a\tQBj\\4jgRL7MU3he\u0016\u001c8/[8o\u0003:\fG._:jg*\u0011acF\u0001\t\u0003:\fG._:jg*\t\u0001$\u0001\u0004h_J\u001c\u0018\r^\u0002\u0001'\t\u00011\u0004E\u0002\u001d;}i\u0011!F\u0005\u0003=U\u0011!CU3he\u0016\u001c8/[8o\u0003:\fG._:jgB\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t9!i\\8mK\u0006t\u0017a\u00047p_.,\u0006oU5h]\u0006$XO]3\u0011\u0005\u001drcB\u0001\u0015-!\tI\u0013%D\u0001+\u0015\tY\u0013$\u0001\u0004=e>|GOP\u0005\u0003[\u0005\na\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011Q&I\u0001\bg\u0016\u001c8/[8o!\t\u00194(D\u00015\u0015\t\tTG\u0003\u00027o\u0005\u0019qm\u001c:\u000b\u0005aJ\u0014aB4peBL\u0007/\u001a\u0006\u0002u\u0005\u0019qN]4\n\u0005q\"$AC$peN+7o]5p]\u00061a/\u00197D_2\u0004\"\u0001I \n\u0005\u0001\u000b#aA%oi\u000611/\u001a9WC2\u00042\u0001I\"'\u0013\t!\u0015E\u0001\u0004PaRLwN\\\u0001\bS6\u0004X\u000f^3e\u0003%\u0001\b.\u001a8p\r&dW-A\u0005d_Z\f'OR5mK\u00061A(\u001b8jiz\"\u0002BS&M\u001b:{\u0005+\u0015\t\u00039\u0001AQ!\n\u0005A\u0002\u0019BQ!\r\u0005A\u0002IBQ!\u0010\u0005A\u0002yBQ!\u0011\u0005A\u0002\tCQ!\u0012\u0005A\u0002}AQA\u0012\u0005A\u0002\u0019BQa\u0012\u0005A\u0002\t\u000bq!\\1y\u0013R,'/F\u0001?\u0003!i\u0017\r_%uKJ\u0004\u0013a\u0001;pYV\tq\u000b\u0005\u0002!1&\u0011\u0011,\t\u0002\u0007\t>,(\r\\3\u0002\tQ|G\u000eI\u0001\u000eY><'+Z4PE*,7\r^:\u0016\u0003u\u00032\u0001\t0a\u0013\ty\u0016EA\u0003BeJ\f\u0017\u0010\u0005\u0002bI6\t!M\u0003\u0002d/\u0005Q!+Z4sKN\u001c\u0018n\u001c8\n\u0005\u0015\u0014'A\u0005'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:\f\u0011\u0003\\8h%\u0016<wJ\u00196fGR\u001cx\fJ3r)\tA7\u000e\u0005\u0002!S&\u0011!.\t\u0002\u0005+:LG\u000fC\u0004m\u001d\u0005\u0005\t\u0019A/\u0002\u0007a$\u0013'\u0001\bm_\u001e\u0014VmZ(cU\u0016\u001cGo\u001d\u0011\u0002\u000bM,G/\u001e9\u0015\u0003!\fq\u0001\u001d:pG\u0016\u001c8\u000f\u0006\u0002ie\")1/\u0005a\u0001i\u0006\t!\u000f\u0005\u0002vq6\taO\u0003\u0002xk\u0005)Qn\u001c3fY&\u0011\u0011P\u001e\u0002\u0004%><\u0018\u0001C<sSR,w*\u001e;\u0015\u000fq\fY!a\u0004\u0002\u0014A!Q0!\u0002u\u001d\rq\u0018\u0011\u0001\b\u0003S}L\u0011AI\u0005\u0004\u0003\u0007\t\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\tIA\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t\u0019!\t\u0005\u0007\u0003\u001b\u0011\u0002\u0019\u0001\u0014\u0002'\t\f7/Z!oIBCWM\\8D_2,XN\\:\t\r\u0005E!\u00031\u0001a\u0003%awn\u001a*fO>\u0013'\u000e\u0003\u0004\u0002\u0016I\u0001\raH\u0001\nG>tg/\u001a:hK\u0012\fq\u0002]1sg\u0016\u0004\u0006.\u001a8p-\u0006dW/\u001a\u000b\u0005\u00037\t\t\u0003E\u0003!\u0003;yr$C\u0002\u0002 \u0005\u0012a\u0001V;qY\u0016\u0014\u0004BBA\u0012'\u0001\u0007a%A\u0001t\u0001")
public class LogisticRegressionAnalysis
extends RegressionAnalysis<Object> {
    private final int valCol;
    private final int maxIter;
    private final double tol;
    private LogisticRegression[] logRegObjects;

    public int maxIter() {
        return this.maxIter;
    }

    public double tol() {
        return this.tol;
    }

    public LogisticRegression[] logRegObjects() {
        return this.logRegObjects;
    }

    public void logRegObjects_$eq(LogisticRegression[] x$1) {
        this.logRegObjects = x$1;
    }

    @Override
    public void setup() {
        super.setup();
        this.logRegObjects_$eq((LogisticRegression[])Array$.MODULE$.tabulate(this.ri().phenoNames().length, (Function1 & Serializable & scala.Serializable)x$1 -> LogisticRegressionAnalysis.$anonfun$setup$1(this, BoxesRunTime.unboxToInt((Object)x$1)), ClassTag$.MODULE$.apply(LogisticRegression.class)));
    }

    public void process(Row r) {
        String values = ((Object)r.colAsString(this.valCol)).toString();
        r.removeColumn(this.valCol);
        String baseColumnsAsString = r.toString();
        double[] genoType = this.ri().genos();
        boolean[] filter = this.ri().genoFilter();
        this.setGenotypesAndFilter().apply((Object)values, (Object)genoType, (Object)filter);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(this.ri().phenoTable())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int idx;
                boolean[] phenos = (boolean[])tuple2._1();
                Tuple3<double[][], Object, Object> tuple3 = this.setupRegressionData(genoType, filter, phenos, idx = tuple2._2$mcI$sp());
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                double[][] x = (double[][])tuple3._1();
                boolean[] y = (boolean[])tuple3._2();
                int numberOfSamples = BoxesRunTime.unboxToInt((Object)tuple3._3());
                Tuple3 tuple32 = new Tuple3((Object)x, (Object)y, (Object)BoxesRunTime.boxToInteger((int)numberOfSamples));
                double[][] x2 = (double[][])tuple32._1();
                boolean[] y2 = (boolean[])tuple32._2();
                int numberOfSamples2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
                LogisticRegression logRegObj = this.logRegObjects()[idx];
                boolean converged = logRegObj.runRegression(x2, y2, numberOfSamples2, this.tol(), this.maxIter());
                String baseAndPhenoColumns = new StringBuilder(1).append(baseColumnsAsString).append("\t").append(this.ri().phenoNames()[idx]).toString();
                return this.writeOut(baseAndPhenoColumns, logRegObj, converged);
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Iterable.class))))).seq().foreach((Function1 & Serializable & scala.Serializable)outRows -> {
            outRows.foreach((Function1 & Serializable & scala.Serializable)outRow -> {
                LogisticRegressionAnalysis.$anonfun$process$3($this, outRow);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    private Iterable<Row> writeOut(String baseAndPhenoColumns, LogisticRegression logRegObj, boolean converged) {
        return (Iterable)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ri().betaNames())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                scala.collection.mutable.StringBuilder stringBuilder;
                String name = (String)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                scala.collection.mutable.StringBuilder lineBuilder = new scala.collection.mutable.StringBuilder(baseAndPhenoColumns);
                lineBuilder.append('\t');
                lineBuilder.append(name);
                if (converged) {
                    lineBuilder.append('\t');
                    lineBuilder.append(new StringOps(Predef$.MODULE$.augmentString("%.5g")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)logRegObj$1.beta[idx])})));
                    lineBuilder.append('\t');
                    lineBuilder.append(new StringOps(Predef$.MODULE$.augmentString("%.5g")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)logRegObj$1.zStats[idx])})));
                    lineBuilder.append('\t');
                    stringBuilder = lineBuilder.append(new StringOps(Predef$.MODULE$.augmentString("%.5g")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)logRegObj$1.pValues[idx])})));
                } else {
                    stringBuilder = lineBuilder.append("\t\t\t");
                }
                return RowObj$.MODULE$.apply((CharSequence)lineBuilder);
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    @Override
    public Tuple2<Object, Object> parsePhenoValue(String s) {
        String string = s;
        if ("1".equals(string)) {
            return new Tuple2.mcZZ.sp(false, true);
        }
        if ("2".equals(string)) {
            return new Tuple2.mcZZ.sp(true, true);
        }
        return new Tuple2.mcZZ.sp(false, false);
    }

    public static final /* synthetic */ LogisticRegression $anonfun$setup$1(LogisticRegressionAnalysis $this, int x$1) {
        return LogisticRegression.getGorLogisticRegressionObject($this.ri().betaLength() - 1, $this.ri().size());
    }

    public static final /* synthetic */ void $anonfun$process$3(LogisticRegressionAnalysis $this, Row outRow) {
        $this.nextProcessor().process(outRow);
    }

    public LogisticRegressionAnalysis(String lookUpSignature, GorSession session, int valCol, Option<String> sepVal, boolean imputed, String phenoFile, Option<String> covarFile) {
        this.valCol = valCol;
        super(lookUpSignature, session, valCol, sepVal, imputed, phenoFile, covarFile, ManifestFactory$.MODULE$.Boolean());
        this.maxIter = 20;
        this.tol = 1.0E-5;
    }
}

