/*
 * Decompiled with CFR 0.152.
 */
package gorsat;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.QueryEvaluator;
import org.gorpipe.querydialogs.Argument;
import org.gorpipe.querydialogs.ArgumentType;
import org.gorpipe.querydialogs.factory.ArgumentContent;
import org.gorpipe.querydialogs.factory.Perspective;
import org.gorpipe.querydialogs.factory.PerspectiveDialog;
import org.gorpipe.querydialogs.factory.PerspectiveDialogFactory;

public class FreemarkerQueryUtilities {
    static Set<String> extraAllowed = Set.of("perspective", "query");

    public static Optional<String> requestQuery(String resource, FileReader fileResolver, QueryEvaluator queryEval, String reportName, Map<String, String> parameterMap, String cacheDir) throws IOException, TemplateException {
        List<PerspectiveDialog> perspectiveDialogs = PerspectiveDialogFactory.create(fileResolver, queryEval, true).buildDialogs(resource, cacheDir);
        Optional<PerspectiveDialog> optionalPerspective = FreemarkerQueryUtilities.getOptionalPerspective(reportName, perspectiveDialogs);
        if (!optionalPerspective.isPresent()) {
            return Optional.empty();
        }
        PerspectiveDialog perspectiveDialog = optionalPerspective.get();
        perspectiveDialog.setArgumentValues(FreemarkerQueryUtilities.getArgumentValues(parameterMap, fileResolver, perspectiveDialog));
        Optional<String> optional = parameterMap.entrySet().stream().filter(p -> p.getValue() == null).map(Map.Entry::getKey).findFirst();
        Optional<String> perspective = parameterMap.entrySet().stream().filter(p -> ((String)p.getKey()).equalsIgnoreCase("perspective")).map(Map.Entry::getValue).findFirst();
        String query = perspective.map(s -> FreemarkerQueryUtilities.getPerspectiveQuery(perspectiveDialog, optional, s)).orElseGet(() -> FreemarkerQueryUtilities.getQuery(perspectiveDialog, optional));
        String newQuery = FreemarkerQueryUtilities.getNewQuery(query);
        return Optional.of(newQuery);
    }

    private static Optional<PerspectiveDialog> getOptionalPerspective(String reportName, List<PerspectiveDialog> perspectiveDialogs) {
        Optional<PerspectiveDialog> optionalPerspective;
        if (reportName != null) {
            optionalPerspective = perspectiveDialogs.stream().filter(p -> reportName.equalsIgnoreCase(p.getName())).findFirst();
            if (!optionalPerspective.isPresent()) {
                optionalPerspective = perspectiveDialogs.stream().findFirst();
            }
        } else {
            optionalPerspective = perspectiveDialogs.stream().findFirst();
        }
        return optionalPerspective;
    }

    private static String getPerspectiveQuery(PerspectiveDialog perspectiveDialog, Optional<String> optional, String perspective) {
        StringBuilder query = new StringBuilder(FreemarkerQueryUtilities.getQuery(perspectiveDialog, optional));
        perspectiveDialog.getPerspectives().stream().filter(pd -> pd.getName().equalsIgnoreCase(perspective)).map(Perspective::getFilterString).findFirst().ifPresent(f -> query.append(" | where ").append((String)f));
        return query.toString();
    }

    private static String getQuery(PerspectiveDialog perspectiveDialog, Optional<String> optional) {
        if (!optional.isPresent()) {
            return perspectiveDialog.getQuery();
        }
        String query = perspectiveDialog.getAttribute(optional.get()).toString();
        StringBuilder ret = new StringBuilder();
        int start = 0;
        int k = query.indexOf("${");
        while (k != -1) {
            ret.append(query, start, k);
            int n = query.indexOf(125, k + 6);
            if (n == -1) {
                ret.append(query.substring(k));
                break;
            }
            if (perspectiveDialog.getArgumentMap().containsKey(query.substring(k + 2, n - 4))) {
                ret.append(perspectiveDialog.getArgumentMap().get(query.substring(k + 2, n - 4)));
            } else {
                ret.append(query, k, n + 1);
            }
            start = n + 1;
            k = query.indexOf("${", start);
        }
        ret.append(query.substring(start));
        query = ret.toString();
        return query;
    }

    private static String getNewQuery(String query) {
        String[] virtualFiles;
        Object newQuery = Arrays.stream(query.split(";")).map(String::trim).collect(Collectors.joining(";"));
        for (String virtualfile : virtualFiles = new String[]{"[gorgrid:", "[grid:"}) {
            int i = ((String)newQuery).indexOf(virtualfile);
            while (i != -1) {
                int e = ((String)newQuery).indexOf(93, i);
                int c = ((String)newQuery).indexOf(39, i);
                newQuery = c < e && c != -1 ? ((String)newQuery).substring(0, i) + ((String)newQuery).substring(c + 1, ((String)newQuery).indexOf(39, c + 1)).trim() + ((String)newQuery).substring(e + 1) : ((String)newQuery).substring(0, i) + ((String)newQuery).substring(i + virtualfile.length() + 1, e).trim() + ((String)newQuery).substring(e + 1);
                i = ((String)newQuery).indexOf(virtualfile, i + 1);
            }
        }
        return newQuery;
    }

    private static String readPnListFromFile(String value, FileReader fileResolver) {
        String result = value;
        try {
            String[] lines;
            if (Files.exists(Paths.get(value, new String[0]), new LinkOption[0]) && (lines = fileResolver.readAll(value)).length > 0) {
                StringBuilder builder = new StringBuilder();
                for (String line : lines) {
                    String quote = "'";
                    if (line.contains("'")) {
                        quote = "\"";
                    }
                    builder.append(quote).append(line).append(quote).append(",");
                }
                result = builder.toString();
                result = result.substring(0, result.length() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static Map<String, ArgumentContent> getArgumentValues(Map<String, String> parameterMap, FileReader fileResolver, PerspectiveDialog perspectiveDialog) {
        return parameterMap.entrySet().stream().filter(p -> p.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            int end;
            String entryKey = (String)entry.getKey();
            if (!extraAllowed.contains(entryKey) && !perspectiveDialog.hasArgument(entryKey)) {
                HashSet<String> set = new HashSet<String>(extraAllowed);
                set.addAll(perspectiveDialog.getArgumentMap().keySet());
                throw new GorParsingException("Parameter '" + entryKey + "' not listed in report builder yaml. Allowed values are " + set);
            }
            Argument argument = perspectiveDialog.getArgument(entryKey);
            String value = argument != null && argument.getType() == ArgumentType.PN_LISTS_ENTRIES ? FreemarkerQueryUtilities.readPnListFromFile((String)entry.getValue(), fileResolver) : (String)entry.getValue();
            if (value.startsWith("[") && value.substring(0, end = value.indexOf(93)).contains(",")) {
                value = value.substring(1, value.length() - 1);
            }
            return new ArgumentContent(value);
        }));
    }

    private FreemarkerQueryUtilities() {
    }
}

