/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Script;

import gorsat.Commands.CommandParseUtilities;
import gorsat.Script.CommandEntry;
import gorsat.Script.CommandGroup;
import gorsat.Script.ExecutionBatch;
import gorsat.Script.ExecutionBlock;
import gorsat.Script.MacroInfo;
import gorsat.Script.MacroParsingResult;
import gorsat.Script.SplitManager;
import gorsat.Script.VirtualFileEntry;
import gorsat.Script.VirtualFileManager;
import gorsat.Utilities.AnalysisUtilities;
import gorsat.Utilities.MacroUtilities;
import gorsat.Utilities.StringUtilities;
import gorsat.process.GorPipeMacros;
import gorsat.process.GorPrePipe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gorpipe.exceptions.GorException;
import org.gorpipe.exceptions.GorResourceException;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.session.EventLogger;
import org.gorpipe.gor.session.GorContext;
import org.gorpipe.gor.session.GorSession;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;

public class BaseScriptExecutionEngine {
    Map<String, ExecutionBlock> executionBlocks = new ConcurrentHashMap<String, ExecutionBlock>();
    Map<String, String> aliases = new ConcurrentHashMap<String, String>();
    Map<String, String> fileSignatureMap = new ConcurrentHashMap<String, String>();
    Map<String, String> singleFileSignatureMap = new ConcurrentHashMap<String, String>();
    VirtualFileManager virtualFileManager = new VirtualFileManager();

    public java.util.List<String> getUsedFiles(String commandToExecute, GorSession session) {
        ArrayList<String> usedFiles = new ArrayList<String>();
        if (CommandParseUtilities.isDictionaryQuery((String)commandToExecute)) {
            String[] w = commandToExecute.split(" ");
            for (int i = 1; i < w.length - 1; i += 2) {
                usedFiles.add(w[i]);
            }
        } else {
            List<String> slist = GorPrePipe.getUsedFiles(commandToExecute, session);
            slist.foreach(usedFiles::add);
        }
        Collections.sort(usedFiles);
        return usedFiles;
    }

    private Optional<Tuple2<String, Boolean>> resolveForkPathParent(String res) {
        int i = res.indexOf("#{");
        if (i != -1) {
            int k = res.lastIndexOf(47, i);
            String ret = k == -1 ? "." : res.substring(0, k);
            return Optional.of(Tuple2.apply((Object)ret, (Object)true));
        }
        return Optional.of(Tuple2.apply((Object)res, (Object)false));
    }

    private Optional<Tuple2<String, Boolean>> resolveCache(String lastCommand) {
        String[] fields = lastCommand.split(" ");
        String lastField = fields[fields.length - 1].trim();
        return !lastField.startsWith("-") ? this.resolveForkPathParent(lastField) : Optional.empty();
    }

    public Optional<Tuple2<String, Boolean>> getExplicitWrite(String query) {
        String lastCommand = MacroUtilities.getLastCommand(query);
        if (lastCommand.toLowerCase().startsWith("write ")) {
            return this.resolveCache(lastCommand);
        }
        return Optional.empty();
    }

    private String getGorDictSignature(GorSession gorPipeSession, String fileName) {
        FileReader fileReader = gorPipeSession.getProjectContext().getFileReader();
        boolean hasTags = fileName.contains("#gortags#");
        String dictFile = fileName.substring("#gordict#".length(), hasTags ? fileName.indexOf("#gortags#") : fileName.length());
        String[] dictTags = hasTags ? fileName.substring(fileName.indexOf("#gortags#") + "#gortags#".length()).split(",") : null;
        try {
            if (dictTags != null && dictTags.length > 9) {
                return fileReader.getFileSignature(dictFile);
            }
            return fileReader.getDictionarySignature(dictFile, dictTags);
        }
        catch (IOException e) {
            throw new GorResourceException("Could not get signature for file", dictFile, (Throwable)e);
        }
    }

    public String fileFingerPrint(String fileName, GorSession gorPipeSession) {
        return this.singleFileSignatureMap.computeIfAbsent(fileName, k -> {
            if (fileName.startsWith("#gordict#")) {
                return this.getGorDictSignature(gorPipeSession, fileName);
            }
            FileReader fileReader = gorPipeSession.getProjectContext().getFileReader();
            String cacheDirectory = AnalysisUtilities.theCacheDirectory(gorPipeSession);
            String[] fnameSplit = fileName.split("/");
            String x_f_name = fnameSplit[fnameSplit.length - 1].split("\\.")[0];
            if (Boolean.parseBoolean(System.getProperty("gor.caching.md5.enabled", "false")) && x_f_name.split("\\.")[0].endsWith("_md5")) {
                return x_f_name.split("\\.")[0];
            }
            if (fileName.startsWith(cacheDirectory)) {
                return "0";
            }
            try {
                return fileReader.getFileSignature(fileName);
            }
            catch (GorException ge) {
                throw ge;
            }
            catch (Exception e) {
                throw new GorResourceException("Could not get file signature for:  " + fileName, fileName, (Throwable)e);
            }
        });
    }

    public String getFileSignatureAndUpdateSignatureMap(GorSession session, String commandToExecute, java.util.List<String> usedFiles) {
        String fileSignature = "";
        if (CommandParseUtilities.isDictionaryQuery((String)commandToExecute)) {
            String usedFilesConcatStr = String.join((CharSequence)" ", usedFiles);
            fileSignature = StringUtilities.createMD5(usedFilesConcatStr);
        } else {
            String signatureKey = AnalysisUtilities.getSignature(commandToExecute);
            String fileListKey = String.join((CharSequence)" ", usedFiles) + signatureKey;
            fileSignature = this.fileSignatureMap.computeIfAbsent(fileListKey, k -> StringUtilities.createMD5(usedFiles.stream().map(x -> this.fileFingerPrint((String)x, session)).collect(Collectors.joining(" ")) + signatureKey));
        }
        return fileSignature;
    }

    private Map<String, ExecutionBlock> expandMacros(GorContext context, Map<String, ExecutionBlock> creates, boolean valid) {
        Map<String, ExecutionBlock> activeCreates = creates;
        boolean macroCreated = false;
        do {
            HashMap<String, ExecutionBlock> newCreates = new HashMap<String, ExecutionBlock>();
            macroCreated = false;
            for (Map.Entry<String, ExecutionBlock> create : activeCreates.entrySet()) {
                String[] commands = CommandParseUtilities.quoteSafeSplit((String)create.getValue().query(), (char)'|');
                if (commands.length <= 0) continue;
                String[] commandOptions = CommandParseUtilities.quoteSafeSplit((String)commands[0], (char)' ');
                Option<MacroInfo> macroEntry = GorPipeMacros.getInfo(commandOptions[0]);
                if (macroEntry.isEmpty()) {
                    newCreates.put(create.getKey(), create.getValue());
                    continue;
                }
                macroCreated = true;
                MacroParsingResult macroResult = ((MacroInfo)macroEntry.get()).init(create.getKey(), create.getValue(), context, false, Arrays.copyOfRange(commandOptions, 1, commandOptions.length), !valid);
                newCreates.putAll(macroResult.createCommands());
                if (macroResult.aliases() == null) continue;
                this.aliases.putAll(macroResult.aliases());
            }
            activeCreates = newCreates;
        } while (macroCreated);
        return activeCreates;
    }

    private Tuple2<Map<String, ExecutionBlock>, Map<String, ExecutionBlock>> splitBasedOnDependencies(Map<String, ExecutionBlock> executionBlocks) {
        HashMap<String, ExecutionBlock> activeExecutionBlocks = new HashMap<String, ExecutionBlock>();
        HashMap<String, ExecutionBlock> dependantExecutionBlocks = new HashMap<String, ExecutionBlock>();
        for (Map.Entry<String, ExecutionBlock> executionBlock : executionBlocks.entrySet()) {
            String[] dependencies;
            VirtualFileEntry virt = this.virtualFileManager.get(executionBlock.getKey());
            if (virt != null) {
                if (virt.fileName != null) continue;
                dependencies = executionBlock.getValue().dependencies();
                if (dependencies.length == 0 || this.virtualFileManager.areDependenciesReady(dependencies)) {
                    activeExecutionBlocks.put(executionBlock.getKey(), executionBlock.getValue());
                    continue;
                }
                dependantExecutionBlocks.put(executionBlock.getKey(), executionBlock.getValue());
                continue;
            }
            dependencies = executionBlock.getValue().dependencies();
            if (dependencies.length == 0 || this.virtualFileManager.areDependenciesReady(dependencies)) {
                activeExecutionBlocks.put(executionBlock.getKey(), executionBlock.getValue());
                continue;
            }
            dependantExecutionBlocks.put(executionBlock.getKey(), executionBlock.getValue());
        }
        return Tuple2.apply(activeExecutionBlocks, dependantExecutionBlocks);
    }

    public Tuple2<String, java.util.List<String>> processBlocks(GorContext context, boolean suggestName, ExecutionBatch executionBatch, boolean validate, String currentGorCmd) {
        GorSession session = context.getSession();
        EventLogger eventLogger = session.getEventLogger();
        String[] gorCommand = new String[]{currentGorCmd};
        ArrayList allUsedFiles = new ArrayList();
        java.util.List cAllUsedFiles = Collections.synchronizedList(allUsedFiles);
        ((Stream)Arrays.stream(executionBatch.getBlocks()).parallel()).forEach(firstLevelBlock -> {
            boolean isParallelQuery;
            firstLevelBlock.query_$eq(this.virtualFileManager.replaceVirtualFiles(firstLevelBlock.query()));
            String query = firstLevelBlock.query();
            String queryLower = query.toLowerCase();
            boolean bl = isParallelQuery = queryLower.startsWith("pgor ") || queryLower.startsWith("partgor ") || queryLower.startsWith("parallel ");
            if (validate && firstLevelBlock.signature() == null && firstLevelBlock.query() != null && isParallelQuery) {
                java.util.List<String> usedFiles = this.getUsedFiles(query, session);
                String fileSignature = this.getFileSignatureAndUpdateSignatureMap(session, query, usedFiles);
                String querySignature = StringUtilities.createMD5(query + fileSignature);
                firstLevelBlock.signature_$eq(querySignature);
                Optional<Tuple2<String, Boolean>> cachePath = this.getExplicitWrite(query);
                if (cachePath.isPresent()) {
                    Tuple2<String, Boolean> cp = cachePath.get();
                    firstLevelBlock.cachePath_$eq((String)cp._1());
                    firstLevelBlock.hasForkWrite_$eq((Boolean)cp._2());
                }
            }
            Map<String, ExecutionBlock> newExecutionBlocks = this.expandMacros(context, Map.of(firstLevelBlock.groupName(), firstLevelBlock), validate);
            Tuple2<Map<String, ExecutionBlock>, Map<String, ExecutionBlock>> tmpExecutionBlocks = this.splitBasedOnDependencies(newExecutionBlocks);
            Map activeExecutionBlocks = (Map)tmpExecutionBlocks._1;
            Map dependentExecutionBlocks = (Map)tmpExecutionBlocks._2;
            this.virtualFileManager.addRange(activeExecutionBlocks);
            for (Map.Entry newExecutionBlock : activeExecutionBlocks.entrySet()) {
                boolean hasFork;
                String cachePath;
                String commandToExecute = ((ExecutionBlock)newExecutionBlock.getValue()).query();
                String cacheFile = ((ExecutionBlock)newExecutionBlock.getValue()).cachePath();
                boolean hasForkWrite = ((ExecutionBlock)newExecutionBlock.getValue()).hasForkWrite();
                if (cacheFile == null) {
                    Optional<Tuple2<String, Boolean>> ocache = this.getExplicitWrite(commandToExecute);
                    if (ocache.isPresent()) {
                        Tuple2<String, Boolean> tup = ocache.get();
                        cachePath = (String)tup._1;
                        hasFork = (Boolean)tup._2;
                    } else {
                        cachePath = cacheFile;
                        hasFork = hasForkWrite;
                    }
                } else {
                    cachePath = cacheFile;
                    hasFork = hasForkWrite;
                }
                java.util.List<String> usedFiles = this.getUsedFiles(commandToExecute, session);
                SplitManager splitManager = SplitManager.createFromCommand((String)newExecutionBlock.getKey(), commandToExecute, context);
                CommandGroup commandGroup = splitManager.expandCommand(commandToExecute, (String)newExecutionBlock.getKey(), cachePath);
                if (commandGroup.removeFromCreate()) {
                    this.executionBlocks.remove(firstLevelBlock.groupName());
                }
                for (CommandEntry cte : commandGroup.commandEntries()) {
                    String querySignature;
                    boolean gordictfolder;
                    if (cte.createName().equals("[]")) {
                        gorCommand[0] = cte.query();
                        this.executionBlocks.remove(firstLevelBlock.groupName());
                        continue;
                    }
                    String commandLower = commandToExecute.toLowerCase();
                    boolean bl2 = gordictfolder = commandLower.startsWith("gordictfolder") || commandLower.startsWith("gordictfolderpart");
                    if (firstLevelBlock.signature() != null && gordictfolder) {
                        querySignature = firstLevelBlock.signature();
                    } else {
                        String fileSignature = validate ? this.getFileSignatureAndUpdateSignatureMap(session, commandToExecute, usedFiles) : "";
                        querySignature = StringUtilities.createMD5(cte.query() + fileSignature);
                    }
                    String ctequery = cte.query();
                    if (!gordictfolder && !hasFork && cte.cacheFile() != null && cte.cacheFile().endsWith(".gord")) {
                        String gordResultsPath = cte.cacheFile() + "/" + querySignature + ".gorz";
                        executionBatch.createNewCommand(querySignature, ctequery.replace(cte.cacheFile(), gordResultsPath), cte.batchGroupName(), cte.createName(), gordResultsPath);
                    } else {
                        executionBatch.createNewCommand(querySignature, ctequery, cte.batchGroupName(), cte.createName(), cte.cacheFile());
                    }
                    eventLogger.commandCreated(cte.createName(), firstLevelBlock.groupName(), querySignature, cte.query());
                }
                if (!suggestName) continue;
                cAllUsedFiles.addAll(usedFiles.stream().filter(x -> !x.startsWith("[")).collect(Collectors.toList()));
            }
            this.executionBlocks.putAll(dependentExecutionBlocks);
        });
        Collections.sort(allUsedFiles);
        return Tuple2.apply((Object)gorCommand[0], allUsedFiles);
    }
}

