/*
 * Decompiled with CFR 0.152.
 */
package gorsat.external.plink;

import gorsat.external.plink.AdjustedGORLine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.Row;
import org.gorpipe.model.gor.RowObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlinkAdjustment
implements Callable<Stream<Row>> {
    private static final Logger log = LoggerFactory.getLogger(PlinkAdjustment.class);
    private final String pheno;
    private final String test;
    private final String columns;
    private final String filepath;
    private final boolean sort;
    private final String[] plinkExecutable;

    public PlinkAdjustment(String[] plinkExecutable, Path filepath, String pheno, String test, String columns, boolean sort) {
        this.pheno = pheno;
        this.test = test;
        this.columns = columns;
        this.filepath = filepath.toString();
        this.sort = sort;
        this.plinkExecutable = plinkExecutable;
    }

    @Override
    public Stream<Row> call() throws Exception {
        String fileToBeAdjusted = this.filepath;
        String adjustedFile = Files.createTempFile("plinkadjust-", "", new FileAttribute[0]).toString();
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(this.plinkExecutable));
        String[] plinkArgs = new String[]{"--adjust-file", fileToBeAdjusted, "test=" + this.test, "cols=" + this.columns, "--out", adjustedFile};
        command.addAll(Arrays.asList(plinkArgs));
        ProcessBuilder plinkProcessBuilder = new ProcessBuilder(command);
        Process plinkProcess = plinkProcessBuilder.start();
        StringBuilder sb = new StringBuilder();
        final StringBuilder esb = new StringBuilder();
        final InputStream es = plinkProcess.getErrorStream();
        Thread eThread = new Thread(){

            @Override
            public void run() {
                try {
                    int r = es.read();
                    while (r != -1) {
                        esb.append((char)r);
                        r = es.read();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        eThread.start();
        InputStream is = plinkProcess.getInputStream();
        int r = is.read();
        while (r != -1) {
            sb.append((char)r);
            r = is.read();
        }
        eThread.join();
        log.debug(sb.toString());
        int exitValue = plinkProcess.waitFor();
        if (exitValue != 0) {
            throw new GorSystemException("Error running plink2: " + esb.toString(), null);
        }
        Path origPath = Paths.get(fileToBeAdjusted, new String[0]);
        if (Files.exists(origPath, new LinkOption[0])) {
            Files.delete(origPath);
        }
        Path res = Paths.get(adjustedFile + ".adjusted", new String[0]);
        Path log = Paths.get(adjustedFile + ".log", new String[0]);
        if (Files.exists(log, new LinkOption[0])) {
            Files.delete(log);
        }
        BufferedReader br = Files.newBufferedReader(res);
        Stream<AdjustedGORLine> lines = br.lines().skip(1L).map(AdjustedGORLine::new);
        if (this.sort) {
            lines = lines.sorted();
        }
        Stream<Row> sstr = lines.map(s -> s.toString() + "\t" + this.test + "\t" + this.pheno).map(RowObj::apply);
        sstr.onClose(() -> {
            try {
                if (Files.exists(res, new LinkOption[0])) {
                    Files.delete(res);
                }
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        return sstr;
    }
}

