/*
 * Decompiled with CFR 0.152.
 */
package gorsat.external.plink;

import gorsat.Commands.Analysis;
import gorsat.external.plink.GORLine;
import gorsat.external.plink.PlinkArguments;
import gorsat.external.plink.PlinkThread;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.gorpipe.base.config.ConfigManager;
import org.gorpipe.exceptions.GorDataException;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.driver.GorDriverConfig;
import org.gorpipe.gor.driver.pgen.PGenWriter;
import org.gorpipe.gor.driver.pgen.PGenWriterFactory;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.model.gor.RowObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlinkProcessAdaptor
extends Analysis {
    private static final Logger log = LoggerFactory.getLogger(PlinkProcessAdaptor.class);
    static final String PGEN_ENDING = ".pgen";
    static final String PVAR_ENDING = ".pvar";
    static final String PSAM_ENDING = ".psam";
    static final int MAXIMUM_NUMBER_OF_LINES = 100;
    private final String[] pgenFiles;
    private PGenWriter writer;
    final String psamFile;
    int pfnIdx = 0;
    GorSession session;
    int linesWrittenToCurrentFile = 0;
    String[] plinkExecutable;
    boolean first;
    ExecutorService es;
    Future<Boolean> plinkFuture;
    final Path writeDir;
    final PlinkArguments args;
    private final float threshold;
    private final String phenoFile;
    private final int refIdx;
    private final int altIdx;
    private final int rsIdIdx;
    private final int valueIdx;
    private final boolean hardCalls;
    private String lastChr = "";
    private int lastPos = -1;
    private final String expectedHeader;
    private boolean checkedHeaderFromPlink = false;

    public PlinkProcessAdaptor(GorSession session, PlinkArguments plinkArguments, int refIdx, int altIdx, int rsIdx, int valueIdx, boolean hc, float th, boolean vcf, String header) throws IOException {
        GorDriverConfig cfg = (GorDriverConfig)ConfigManager.getPrefixConfig((String)"gor", GorDriverConfig.class, (Map[])new Map[0]);
        this.plinkExecutable = cfg.plinkExecutable().split(" ");
        this.session = session;
        this.expectedHeader = header;
        this.es = Executors.newSingleThreadExecutor();
        try {
            this.writeDir = Files.createTempDirectory("plinkregression", new FileAttribute[0]);
            this.writeDir.toFile().deleteOnExit();
        }
        catch (IOException e) {
            throw new GorSystemException("Could not create temp directory.", (Throwable)e);
        }
        this.pgenFiles = new String[]{this.writeDir.resolve(UUID.randomUUID().toString()).toString(), this.writeDir.resolve(UUID.randomUUID().toString()).toString()};
        this.psamFile = this.writeDir.resolve(UUID.randomUUID().toString() + PSAM_ENDING).toString();
        this.phenoFile = plinkArguments.pheno;
        this.refIdx = refIdx;
        this.altIdx = altIdx;
        this.rsIdIdx = rsIdx;
        this.valueIdx = valueIdx;
        this.hardCalls = hc;
        this.threshold = th;
        this.args = plinkArguments;
    }

    void nextGorLine(PriorityQueue<GORLine> pq, GORLine gorline) {
        try {
            gorline = gorline.next();
        }
        catch (IOException e) {
            try {
                gorline.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new GorSystemException("unable to read from process", (Throwable)e);
        }
        if (gorline != null) {
            pq.add(gorline);
        }
    }

    void sendLine(PriorityQueue<GORLine> pq) {
        while (pq.size() > 0) {
            String header;
            GORLine gorline = pq.poll();
            if (!this.checkedHeaderFromPlink && (header = gorline.getHeader()) != null && header.length() > 0) {
                if (this.expectedHeader.split("\t").length - 1 != header.split("\t").length) {
                    throw new GorDataException("Unexpected number of columns in plink2 result, expected " + this.expectedHeader + " got " + header);
                }
                this.checkedHeaderFromPlink = true;
            }
            super.process(RowObj.apply((CharSequence)gorline.toString()));
            this.nextGorLine(pq, gorline);
        }
    }

    boolean isWriterInitialized() {
        return this.writer != null;
    }

    void prepareAndRunPlink(String pgenFilePath) throws ExecutionException, InterruptedException {
        try {
            if (this.isWriterInitialized()) {
                this.writer.close();
            }
        }
        catch (Exception e) {
            throw new GorSystemException((Throwable)e);
        }
        if (this.plinkFuture != null) {
            this.first = this.plinkFuture.get();
        }
        Path pgenPath = Paths.get(pgenFilePath + PGEN_ENDING, new String[0]);
        Path rootPath = this.session.getProjectContext().getRealProjectRootPath();
        if (pgenPath.isAbsolute() && Files.exists(pgenPath, new LinkOption[0]) || Files.exists(rootPath.resolve(pgenPath), new LinkOption[0])) {
            PlinkThread plinkThread = new PlinkThread(rootPath.toFile(), this.writeDir, this.plinkExecutable, pgenFilePath, this.psamFile, this.first, this, this.args, false);
            this.plinkFuture = this.es.submit(plinkThread);
        } else {
            this.plinkFuture = null;
        }
    }

    void processRow(Row row) throws IOException, ExecutionException, InterruptedException {
        if (!(this.linesWrittenToCurrentFile <= 100 || this.lastChr.equals(row.chr) && this.lastPos == row.pos)) {
            this.prepareAndRunPlink(this.getCurrentInputFile());
            this.setNewPGenStream();
            this.linesWrittenToCurrentFile = 0;
        }
        this.writer.write(row);
        this.lastChr = row.chr;
        this.lastPos = row.pos;
        ++this.linesWrittenToCurrentFile;
    }

    public void setup() {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.psamFile));
             BufferedReader br = new BufferedReader(this.session.getProjectContext().getFileReader().getReader(this.phenoFile));){
            String currLine;
            String phenoHeader = br.readLine();
            String phenoHeaderCutOff = phenoHeader.substring(phenoHeader.indexOf(9) + 1);
            bw.write("#IID\tSID\tPAT\tMAT\tSEX\t" + phenoHeaderCutOff + "\n");
            while ((currLine = br.readLine()) != null) {
                int tabIdx = currLine.indexOf(9);
                String pn = currLine.substring(0, tabIdx);
                String phenos = currLine.substring(tabIdx + 1);
                bw.write(pn + "\t" + pn + "\t0\t0\tNA\t" + phenos + "\n");
            }
            this.setNewPGenStream();
        }
        catch (IOException e) {
            throw new GorSystemException((Throwable)e);
        }
    }

    public void process(Row row) {
        try {
            this.processRow(row);
        }
        catch (IOException | ExecutionException e) {
            this.isInErrorState_$eq(true);
            throw new GorSystemException("Error when running plink2", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.isInErrorState_$eq(true);
            throw new GorSystemException("plink2 interrupted", (Throwable)e);
        }
    }

    private void setNewPGenStream() throws IOException {
        this.pfnIdx = this.pfnIdx + 1 & 1;
        FileReader fileReader = this.session.getProjectContext().getSystemFileReader();
        this.writer = PGenWriterFactory.getPGenWriter((String)(this.getCurrentInputFile() + PGEN_ENDING), (int)this.refIdx, (int)this.altIdx, (int)this.rsIdIdx, (int)this.valueIdx, (boolean)this.hardCalls, (!this.hardCalls ? 1 : 0) != 0, (float)this.threshold, (FileReader)fileReader);
    }

    String getCurrentInputFile() {
        return this.pgenFiles[this.pfnIdx];
    }

    public void finish() {
        try {
            if (this.isWriterInitialized()) {
                this.prepareAndRunPlink(this.getCurrentInputFile());
            }
            if (this.plinkFuture != null) {
                this.plinkFuture.get();
            }
        }
        catch (ExecutionException e) {
            this.isInErrorState_$eq(true);
            throw new GorSystemException("Error when running plink2", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.isInErrorState_$eq(true);
            throw new GorSystemException("Error plink2 interrupted", (Throwable)e);
        }
        finally {
            this.es.shutdown();
            try {
                FileUtils.deleteDirectory((File)this.writeDir.toFile());
            }
            catch (IOException e) {
                log.warn("Could not delete working directory {}", (Object)this.writeDir);
            }
        }
    }
}

