/*
 * Decompiled with CFR 0.152.
 */
package gorsat.external.plink;

import gorsat.external.plink.PlinkArguments;
import gorsat.external.plink.PlinkProcessAdaptor;
import gorsat.external.plink.PlinkThread;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.session.GorSession;

public class PlinkVcfProcessAdaptor
extends PlinkProcessAdaptor {
    static final String VCF_ENDING = ".vcf";
    private FileWriter vcf;
    private String vcfHeader;

    public PlinkVcfProcessAdaptor(GorSession session, PlinkArguments plinkArguments, int refIdx, int altIdx, int rsIdx, int valueIdx, boolean hc, float th, boolean vcf, String header, String expectedHeader) throws IOException {
        super(session, plinkArguments, refIdx, altIdx, rsIdx, valueIdx, hc, th, vcf, expectedHeader);
        if (vcf) {
            this.vcfHeader = "#" + header + "\n";
        }
    }

    private void dumpToVcf(Writer fw, String vcfHeader) throws IOException {
        fw.write("##fileformat=VCFv4.2\n");
        fw.write("##FORMAT=<ID=GT,Type=String,Number=1,Description=\"Threshholded genotype call\">\n");
        fw.write("##FORMAT=<ID=GP,Type=Float,Number=G,Description=\"Genotype call probabilities\">\n");
        fw.write("##FORMAT=<ID=HP,Type=Float,Number=.,Description=\"Haplotype call probabilities\">\n");
        fw.write(vcfHeader);
    }

    @Override
    boolean isWriterInitialized() {
        return this.vcf != null;
    }

    @Override
    void prepareAndRunPlink(String vcfFilePath) throws ExecutionException, InterruptedException {
        try {
            if (this.isWriterInitialized()) {
                this.vcf.close();
            }
        }
        catch (Exception e) {
            throw new GorSystemException((Throwable)e);
        }
        Path vcfPath = Paths.get(vcfFilePath + VCF_ENDING, new String[0]);
        Path rootPath = this.session.getProjectContext().getRealProjectRootPath();
        if (vcfPath.isAbsolute() && Files.exists(vcfPath, new LinkOption[0]) || Files.exists(rootPath.resolve(vcfPath), new LinkOption[0])) {
            if (this.plinkFuture != null) {
                this.first = (Boolean)this.plinkFuture.get();
            }
            PlinkThread plinkThread = new PlinkThread(this.session.getProjectContext().getRealProjectRootPath().toFile(), this.writeDir, this.plinkExecutable, vcfFilePath, this.psamFile, this.first, this, this.args, true);
            this.plinkFuture = this.es.submit(plinkThread);
        } else {
            this.plinkFuture = null;
        }
    }

    @Override
    public void setup() {
        try {
            this.setNewVcfStream();
        }
        catch (IOException e) {
            throw new GorSystemException((Throwable)e);
        }
    }

    private void setNewVcfStream() throws IOException {
        this.pfnIdx = this.pfnIdx + 1 & 1;
        this.vcf = new FileWriter(this.getCurrentInputFile() + VCF_ENDING);
        this.dumpToVcf(this.vcf, this.vcfHeader);
    }

    @Override
    void processRow(Row row) throws IOException, ExecutionException, InterruptedException {
        if (this.linesWrittenToCurrentFile > 100) {
            this.prepareAndRunPlink(this.getCurrentInputFile());
            this.setNewVcfStream();
            this.linesWrittenToCurrentFile = 0;
        }
        row.writeRow((Writer)this.vcf);
        this.vcf.write(10);
        ++this.linesWrittenToCurrentFile;
    }
}

