/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.BatchedReadSourceConfig;
import gorsat.process.CLIGorExecutionEngine;
import gorsat.process.GorPipeFirstOrderCommands;
import gorsat.process.PipeOptions;
import java.util.Map;
import org.gorpipe.base.config.ConfigManager;
import org.gorpipe.exceptions.ExceptionUtilities;
import org.gorpipe.exceptions.GorException;
import org.gorpipe.gor.model.DbSource;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.servers.GorConfig;
import org.gorpipe.gor.session.ProjectContext;
import org.gorpipe.logging.GorLogbackUtil;
import org.gorpipe.util.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.Tuple2;

public final class GorPipe$
implements GorPipeFirstOrderCommands {
    public static GorPipe$ MODULE$;
    private final Logger consoleLogger;
    private String version;
    private final BatchedReadSourceConfig brsConfig;
    private final GorConfig gorConfig;

    static {
        new GorPipe$();
    }

    @Override
    public void helpCommand(String[] args, FileReader fileReader) {
        GorPipeFirstOrderCommands.helpCommand$(this, args, fileReader);
    }

    @Override
    public Tuple2<String, String[]> helpFileOpt(String[] args, FileReader fileReader) {
        return GorPipeFirstOrderCommands.helpFileOpt$(this, args, fileReader);
    }

    @Override
    public String[] getHelpListFromFiles() {
        return GorPipeFirstOrderCommands.getHelpListFromFiles$(this);
    }

    private Logger consoleLogger() {
        return this.consoleLogger;
    }

    public String version() {
        return this.version;
    }

    public void version_$eq(String x$1) {
        this.version = x$1;
    }

    public BatchedReadSourceConfig brsConfig() {
        return this.brsConfig;
    }

    public GorConfig gorConfig() {
        return this.gorConfig;
    }

    public void main(String[] args) {
        if (args.length < 1 || args[0].isEmpty() || args[0].toUpperCase().startsWith("HELP")) {
            this.helpCommand(args, ProjectContext.DEFAULT_READER);
            System.exit(0);
        }
        PipeOptions commandlineOptions = new PipeOptions();
        commandlineOptions.parseOptions(args);
        ExceptionUtilities.setShowStackTrace((Boolean)Predef$.MODULE$.boolean2Boolean(commandlineOptions.showStackTrace()));
        if (commandlineOptions.version()) {
            this.printOutGORPipeVersion();
            System.exit(0);
        }
        GorLogbackUtil.initLog((String)"gorpipe");
        ConfigUtil.loadConfig((String)"gor");
        DbSource.initInConsoleApp();
        int exitCode = 0;
        CLIGorExecutionEngine executionEngine = new CLIGorExecutionEngine(commandlineOptions, null, null);
        try {
            executionEngine.execute();
        }
        catch (GorException ge) {
            this.consoleLogger().error(ExceptionUtilities.gorExceptionToString((Throwable)ge));
            exitCode = -1;
        }
        catch (Throwable ex) {
            this.consoleLogger().error(new StringBuilder(49).append("Unexpected error, please report if you see this.\n").append(ex.getMessage()).toString(), ex);
            exitCode = -1;
        }
        System.exit(exitCode);
    }

    private void printOutGORPipeVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        System.out.println(version != null ? version : "No implementation version found.");
    }

    private GorPipe$() {
        MODULE$ = this;
        GorPipeFirstOrderCommands.$init$(this);
        this.consoleLogger = LoggerFactory.getLogger((String)new StringBuilder(8).append("console.").append(this.getClass()).toString());
        this.version = this.getClass().getPackage().getImplementationVersion();
        if (this.version() == null) {
            this.version_$eq("Unknown");
        }
        this.brsConfig = (BatchedReadSourceConfig)ConfigManager.getPrefixConfig((String)"gor", BatchedReadSourceConfig.class, (Map[])new Map[0]);
        this.gorConfig = (GorConfig)ConfigManager.getPrefixConfig((String)"gor", GorConfig.class, (Map[])new Map[0]);
    }
}

