/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import java.util.concurrent.ExecutionException;
import org.gorpipe.base.config.converters.DurationConverter;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.session.GorSessionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GorSessionCacheManager {
    private static final Logger log = LoggerFactory.getLogger(GorSessionCacheManager.class);
    private static final Cache<String, GorSessionCache> gorCache = GorSessionCacheManager.createCache();

    private GorSessionCacheManager() {
    }

    private static Cache<String, GorSessionCache> createCache() {
        DurationConverter converter = new DurationConverter();
        RemovalListener removalNotifier = notification -> log.info("Removing from gor session cache, key: {}, cause: {}.  Remaining entries: {}", new Object[]{notification.getKey(), notification.getCause(), gorCache.size()});
        CacheBuilder builder = CacheBuilder.newBuilder().removalListener(removalNotifier).weakValues();
        return builder.build();
    }

    public static synchronized GorSessionCache getCache(String requestId) {
        try {
            log.debug("Acquiring gor session cache for request id: {}", (Object)requestId);
            return (GorSessionCache)gorCache.get((Object)requestId, () -> GorSessionCacheManager.createCache(requestId));
        }
        catch (ExecutionException e) {
            throw new GorSystemException("Failed to create got session cache for request id: " + requestId, (Throwable)e);
        }
    }

    public static void invalidateCache(String requestId) {
        gorCache.invalidate((Object)requestId);
    }

    private static GorSessionCache createCache(String requestId) {
        log.debug("Creating gor session cache for request id: {}", (Object)requestId);
        return new GorSessionCache();
    }
}

