/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.table;

import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.table.Table;
import org.gorpipe.gor.table.dictionary.DictionaryTable;
import org.gorpipe.gor.table.files.DictionaryLinkTable;
import org.gorpipe.gor.table.files.GorTable;
import org.gorpipe.gor.table.files.NorTable;

public class TableFactory {
    private TableFactory() {
    }

    public static Table getTable(String tablePath, FileReader fileReader) {
        Object table = switch (FilenameUtils.getExtension((String)tablePath).toLowerCase()) {
            case "gord", "gort" -> new DictionaryTable(tablePath);
            case "gor", "gorz", "vcf" -> new GorTable(URI.create(tablePath));
            case "link" -> {
                if (tablePath.toLowerCase().endsWith("gord.link")) {
                    yield new DictionaryLinkTable(URI.create(tablePath), fileReader);
                }
                throw new GorSystemException("Unsupported table type " + tablePath, null);
            }
            default -> fileReader.isDirectory(tablePath) ? new DictionaryTable(tablePath) : new NorTable(URI.create(tablePath));
        };
        table.setFileReader(fileReader);
        return table;
    }

    public static boolean isDictionary(String tablePath, FileReader fileReader) {
        String extension;
        if (fileReader.isDirectory(tablePath)) {
            return true;
        }
        switch (extension = FilenameUtils.getExtension((String)tablePath).toLowerCase()) {
            case "gord": 
            case "gort": {
                return true;
            }
        }
        return false;
    }
}

