/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.table.files;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Stream;
import org.gorpipe.exceptions.GorResourceException;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.table.Table;
import org.gorpipe.gor.table.dictionary.DictionaryTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryLinkTable
implements Table {
    private static final Logger log = LoggerFactory.getLogger(DictionaryLinkTable.class);
    private URI linkUri;
    private URI linkedTableURI;
    private URI replacementUri;
    private DictionaryTable linkedTable;
    private FileReader fileReader;

    public DictionaryLinkTable(URI uri, FileReader inputFileReader) {
        this.linkUri = uri;
        this.setFileReader(inputFileReader);
        this.linkedTableURI = DictionaryLinkTable.readLinkContent(uri, inputFileReader);
        if (this.linkedTableURI != null) {
            this.linkedTable = new DictionaryTable(this.linkedTableURI, this.fileReader);
        }
    }

    public void link(URI uri) {
        this.replacementUri = uri;
    }

    public void deleteUnderlying() {
        this.linkedTable.delete();
    }

    public String getName() {
        return null;
    }

    public String getPath() {
        return this.linkedTable.getPath();
    }

    public String getFolderPath() {
        return this.linkedTable.getFolderPath();
    }

    public String[] getColumns() {
        return this.linkedTable.getColumns();
    }

    public String getProperty(String key) {
        return this.linkedTable.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.linkedTable.setProperty(key, value);
    }

    public boolean containsProperty(String key) {
        return this.linkedTable.containsProperty(key);
    }

    public Stream<String> getLines() {
        return this.linkedTable.getLines();
    }

    public void insert(Collection lines) {
        throw new GorSystemException("Can not insert entries into DictionaryLinkTable, use replace(new dict)", null);
    }

    public void insert(String ... lines) {
        throw new GorSystemException("Can not insert entries into DictionaryLinkTable, use replace(new dict)", null);
    }

    public void delete(Collection lines) {
        throw new GorSystemException("Can not insert entries into DictionaryLinkTable, use replace(new dict)", null);
    }

    public void delete(String ... lines) {
        throw new GorSystemException("Can not insert entries into DictionaryLinkTable, use replace(new dict)", null);
    }

    public void reload() {
        this.linkedTable.reload();
    }

    public void save() {
        this.commitRequest();
        this.commit();
    }

    public void delete() {
        this.deleteUnderlying();
        try {
            this.linkedTable.getFileReader().delete(this.linkUri.toString());
        }
        catch (IOException e) {
            throw new GorSystemException((Throwable)e);
        }
    }

    public void deleteEntries(Collection collection) {
        throw new GorSystemException("Can not insert entries into DictionaryLinkTable, use replace(new dict)", null);
    }

    public void insertEntries(Collection collection) {
        throw new GorSystemException("Can not insert entries into DictionaryLinkTable, use replace(new dict)", null);
    }

    public void commitRequest() {
    }

    public void commit() {
        if (this.replacementUri != null) {
            this.writeLink(this.replacementUri.toString());
            this.deleteUnderlying();
            this.linkedTableURI = this.replacementUri;
            this.replacementUri = null;
            this.linkedTable = new DictionaryTable(this.linkedTableURI, this.fileReader);
        }
    }

    private void writeLink(String content) {
        try (OutputStreamWriter os = new OutputStreamWriter(this.linkedTable.getFileReader().getOutputStream(this.linkUri.toString(), false));){
            os.write(content);
        }
        catch (IOException e) {
            throw new GorResourceException("Could not update", content, (Throwable)e);
        }
    }

    public void initialize() {
        this.linkedTable.initialize();
        if (!this.fileReader.exists(this.linkUri.toString())) {
            this.writeLink(this.linkedTableURI.toString());
        }
    }

    public String getRootPath() {
        return this.linkedTable.getRootPath();
    }

    public String getSecurityContext() {
        return this.linkedTable.getSecurityContext();
    }

    public void setColumns(String[] columns) {
        this.linkedTable.setColumns(columns);
    }

    public void setFileReader(FileReader fileReader) {
        this.fileReader = fileReader;
    }

    private static URI readLinkContent(URI uri, FileReader fileReader) {
        try {
            return URI.create(fileReader.readLinkContent(uri.toString()));
        }
        catch (Exception e) {
            return URI.create(String.format("/tmp/dummy_%s.gord", UUID.randomUUID()));
        }
    }
}

