/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.table.files;

import java.net.URI;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.files.FileTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GorTable<T extends Row>
extends FileTable<T> {
    private static final Logger log = LoggerFactory.getLogger(GorTable.class);

    public GorTable(BaseTable.Builder builder) {
        super(builder);
    }

    public GorTable(URI uri, FileReader inputFileReader) {
        super(uri, inputFileReader);
    }

    public GorTable(URI uri) {
        this(uri, null);
    }

    @Override
    protected String getInputTempFileEnding() {
        return ".gor";
    }

    @Override
    protected String getGorCommand() {
        return "gor";
    }

    @Override
    protected String createInsertTempFileCommand(String mainFile, String outFile, String ... insertFiles) {
        String mainFileString = this.fileReader.exists(mainFile) ? mainFile : "";
        return String.format("%s %s %s %s | write %s", this.getGorCommand(), mainFileString, String.join((CharSequence)" ", insertFiles), this.getPostProcessing(), outFile);
    }
}

