/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.table.files;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.model.RowBase;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.files.FileTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NorTable<T extends Row>
extends FileTable<T> {
    public static final String HEADER_PRIMARY_KEY_KEY = "PRIMARY_KEY";
    private static final Logger log = LoggerFactory.getLogger(NorTable.class);

    public NorTable(BaseTable.Builder builder) {
        super(builder);
    }

    public NorTable(URI uri, FileReader inputFileReader) {
        super(uri, inputFileReader);
    }

    public NorTable(URI uri) {
        this(uri, null);
    }

    @Override
    protected String getInputTempFileEnding() {
        return ".nor";
    }

    @Override
    protected String getGorCommand() {
        return "nor";
    }

    @Override
    protected T createRow(String line) {
        return (T)new RowBase((CharSequence)("chrN\t0\t" + line));
    }

    @Override
    protected void writeRowToStream(Row r, OutputStream os) throws IOException {
        r.writeNorRowToStream(os);
    }

    @Override
    protected String createInsertTempFileCommand(String mainFile, String outFile, String ... insertFiles) {
        if (insertFiles.length != 1) {
            throw new GorSystemException("Insert into nor table only supports 1 file at time", null);
        }
        String insertFile = insertFiles[0];
        String key = this.getProperty(HEADER_PRIMARY_KEY_KEY);
        String postProcessing = this.getPostProcessing();
        if (key == null) {
            if (this.fileReader.exists(mainFile)) {
                return String.format("%s %s | merge %s %s | write %s", this.getGorCommand(), mainFile, insertFile, postProcessing, outFile);
            }
            return String.format("%s %s %s | write %s", this.getGorCommand(), insertFile, postProcessing, outFile);
        }
        if (this.fileReader.exists(mainFile)) {
            return String.format("%s %s | map <(%s %s) -c %s -n %s -m 'Include' | where %sx = 'Include' | hide %sx | merge %s | sort -c %s %s | write %s", this.getGorCommand(), mainFile, this.getGorCommand(), insertFile, key, key, key, key, insertFile, key, postProcessing, outFile);
        }
        return String.format("%s %s | sort -c %s %s | write %s", this.getGorCommand(), insertFile, key, postProcessing, outFile);
    }
}

