/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.argument;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.gorpipe.gor.model.QueryEvaluator;
import org.gorpipe.querydialogs.ArgumentDescription;
import org.gorpipe.querydialogs.ArgumentType;
import org.gorpipe.querydialogs.argument.FormatArgument;
import org.gorpipe.querydialogs.util.ValueFormatter;

public class QueryArgument
extends FormatArgument {
    private final QueryEvaluator queryEvaluator;
    private final String query;

    public QueryArgument(ArgumentDescription argDescr, boolean quoted, ValueFormatter formatter, Boolean optional, Object defaultValue, String query, List<String> operators, Boolean advanced, Integer displayWidth, QueryEvaluator queryEvaluator) {
        super(ArgumentType.QUERY, argDescr, optional, defaultValue, (List<?>)DEFERRED_LIST, (URI)null, operators, advanced, displayWidth);
        this.queryEvaluator = queryEvaluator;
        this.query = query;
        this.setFormattingParameters(formatter, quoted, "values");
    }

    public QueryArgument(QueryArgument arg) {
        super(arg);
        this.queryEvaluator = arg.queryEvaluator;
        this.query = arg.query;
        this.setFormattingParameters(arg.formatter, arg.quoted, arg.format);
    }

    @Override
    public QueryArgument copyArgument() {
        return new QueryArgument(this);
    }

    @Override
    public void loadDeferredValues(boolean checkForHeader, Function<String, BufferedReader> fileResolver) throws IOException {
        ArrayList<Object> values = new ArrayList<Object>();
        List queryResults = this.queryEvaluator.asList(this.query);
        this.setValuesHeader(this.queryEvaluator.getHeader());
        for (String line : queryResults) {
            values.add(this.parseValue(line));
        }
        this.allowedValues = values;
        this.fireContentsChanged(0, this.allowedValues.size());
    }

    @Override
    public boolean hasDeferredValues() {
        return true;
    }

    @Override
    protected void checkAllowed(Object theValue) {
    }
}

