/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.argument;

import java.net.URI;
import java.util.List;
import org.gorpipe.querydialogs.ArgumentDescription;
import org.gorpipe.querydialogs.ArgumentType;
import org.gorpipe.querydialogs.FilteringColumnDefinition;
import org.gorpipe.querydialogs.argument.FormatArgument;
import org.gorpipe.querydialogs.util.SubjectLists;
import org.gorpipe.querydialogs.util.ValueFormatter;

public class StringArgument
extends FormatArgument {
    private final boolean singleSelection;
    private FilteringColumnDefinition helpDefinition;
    private SubjectLists persistingValueObject;

    public StringArgument(ArgumentDescription argDescr, boolean quoted, Boolean optional, Object defaultValue, List<? extends Object> allowedValues, URI valuesPath, ValueFormatter formatter, List<String> operators, Boolean advanced, Integer displayWidth, ArgumentType argType, Boolean singleSelection) {
        super(argType, argDescr, optional, defaultValue, (List<?>)allowedValues, valuesPath, operators, advanced, displayWidth);
        this.singleSelection = singleSelection != null && singleSelection != false;
        this.setFormattingParameters(formatter, quoted, "values");
    }

    public StringArgument(StringArgument arg) {
        super(arg);
        this.singleSelection = arg.singleSelection;
        this.setFormattingParameters(arg.formatter, arg.quoted, arg.format);
        if (arg.persistingValueObject != null) {
            this.persistingValueObject = new SubjectLists(arg.persistingValueObject);
        }
    }

    public FilteringColumnDefinition getHelpDefinition() {
        return this.helpDefinition;
    }

    public void setHelpDefinition(FilteringColumnDefinition helpDefinition) {
        this.helpDefinition = helpDefinition;
    }

    public Object getPersistingValueObject() {
        return this.persistingValueObject;
    }

    public void setPersistingValueObject(SubjectLists persistingValueObject) {
        this.persistingValueObject = persistingValueObject;
    }

    @Override
    public StringArgument copyArgument() {
        return new StringArgument(this);
    }

    public boolean isSingleSelection() {
        return this.singleSelection;
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == null || this.getValue().toString().trim().isEmpty();
    }
}

