/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SubjectLists {
    private List<String> listsNames;
    private List<String[]> listsContent;
    private List<String> defaultListsNames;
    private List<String[]> defaultListsContent;
    private String[] listsColumnHeaders;
    private boolean useDefaultLists;

    public SubjectLists() {
        this.listsNames = new ArrayList<String>();
        this.listsContent = new ArrayList<String[]>();
    }

    public SubjectLists(SubjectLists subjectLists) {
        this.listsNames = new ArrayList<String>(subjectLists.listsNames);
        this.listsContent = new ArrayList<String[]>();
        for (String[] listCont : subjectLists.listsContent) {
            this.listsContent.add(Arrays.copyOf(listCont, listCont.length));
        }
        if (subjectLists.defaultListsNames != null) {
            this.defaultListsNames = new ArrayList<String>(subjectLists.defaultListsNames);
        }
        if (subjectLists.defaultListsContent != null) {
            this.defaultListsContent = new ArrayList<String[]>();
            for (String[] defListCont : subjectLists.defaultListsContent) {
                this.defaultListsContent.add(Arrays.copyOf(defListCont, defListCont.length));
            }
        }
        this.useDefaultLists = subjectLists.useDefaultLists;
    }

    public void setData(List<String> inpListsNames, List<String[]> inpListsContent) {
        this.listsNames = inpListsNames;
        this.listsContent = inpListsContent;
        this.useDefaultLists = false;
    }

    public void setDefaultListsData(List<String> inpDefaultListsNames, List<String[]> inpDefaultListsContent, String[] inpListsColumnHeaders) {
        this.defaultListsNames = inpDefaultListsNames;
        this.defaultListsContent = inpDefaultListsContent;
        this.listsColumnHeaders = inpListsColumnHeaders;
        this.useDefaultLists = true;
    }

    public boolean useDefaultLists() {
        return this.useDefaultLists;
    }

    public String toString() {
        String subjects = null;
        if (this.useDefaultLists && this.defaultListsContent.size() > 0) {
            subjects = this.joinSubjects(this.defaultListsContent);
        } else if (this.listsContent.size() > 0) {
            subjects = this.joinSubjects(this.listsContent);
        }
        return subjects;
    }

    public String[] getListsSubjectContent() {
        if (this.useDefaultLists) {
            return this.getListsSubjectContent(this.defaultListsContent);
        }
        return this.getListsSubjectContent(this.listsContent);
    }

    public String[][] getListsContent() {
        if (this.useDefaultLists) {
            return this.getListsContent(this.defaultListsContent);
        }
        return this.getListsContent(this.listsContent);
    }

    public String[] getListsColumnHeaders() {
        return this.listsColumnHeaders;
    }

    public String[] getListsNamesExcludeDefaultLists() {
        return this.listsNames.toArray(new String[this.listsNames.size()]);
    }

    public String getListsNamesJoined() {
        if (this.useDefaultLists) {
            return String.join((CharSequence)",", this.defaultListsNames);
        }
        return String.join((CharSequence)",", this.listsNames);
    }

    private String joinSubjects(List<String[]> content) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < content.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(content.get(i)[0]);
        }
        return sb.toString();
    }

    private String[] getListsSubjectContent(List<String[]> content) {
        String[] subjects = new String[content.size()];
        for (int i = 0; i < subjects.length; ++i) {
            subjects[i] = content.get(i)[0];
        }
        return subjects;
    }

    private String[][] getListsContent(List<String[]> content) {
        return (String[][])content.toArray((T[])new String[content.size()][]);
    }
}

