/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CustomObjectsApi;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gorpipe.gor.driver.DataSource;
import org.gorpipe.gor.model.DriverBackedFileReader;

public class SparkOperatorRunner {
    CustomObjectsApi apiInstance;
    ObjectMapper objectMapper;
    String jobName;

    public SparkOperatorRunner() throws IOException {
        ApiClient client = Config.defaultClient();
        Configuration.setDefaultApiClient((ApiClient)client);
        this.apiInstance = new CustomObjectsApi();
        this.objectMapper = new ObjectMapper();
    }

    Map<String, Object> loadBody(String query, String project, String result_dir, Map<String, Object> parameters) throws IOException {
        Map body = (Map)this.objectMapper.readValue(query, Map.class);
        Map metadata = (Map)body.get("metadata");
        this.jobName = metadata.get("name").toString();
        if (body.containsKey("yaml")) {
            this.objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            String yamlPathString = body.get("yaml").toString();
            Path queryRoot = Paths.get(project, new String[0]);
            Path yamlPath = Paths.get(yamlPathString, new String[0]);
            DriverBackedFileReader driverBackedGorServerFileReader = new DriverBackedFileReader("", project, null);
            DataSource yamlDataSource = driverBackedGorServerFileReader.resolveUrl((yamlPath = queryRoot.resolve(yamlPath)).toString());
            String yamlContent = driverBackedGorServerFileReader.readFile(yamlDataSource.getSourceReference().getUrl()).collect(Collectors.joining("\n"));
            Map yaml = (Map)this.objectMapper.readValue(yamlContent, Map.class);
            Map md = (Map)yaml.get("metadata");
            String name = (String)md.get("name");
            if (name.equals("${name.val}")) {
                md.put("name", this.jobName);
            }
            Map specMap = (Map)body.get("spec");
            List arguments = (List)specMap.get("arguments");
            Map spec = (Map)yaml.get("spec");
            Object args = spec.get("arguments");
            if (args.toString().equals("${arguments.val}")) {
                spec.put("arguments", arguments);
            }
            if (name.equals("${name.val}")) {
                md.put("name", this.jobName);
            }
            yamlContent = this.objectMapper.writeValueAsString((Object)yaml).substring(4);
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                yamlContent = yamlContent.replace("${" + entry.getKey() + ".val}", entry.getValue().toString());
            }
            body = (Map)this.objectMapper.readValue(yamlContent, Map.class);
        }
        if (body.containsKey("spec")) {
            List arguments;
            int i;
            Map specMap = (Map)body.get("spec");
            if (specMap.containsKey("arguments") && (i = (arguments = (List)specMap.get("arguments")).indexOf("#{result_dir}")) != -1) {
                arguments.set(i, result_dir);
            }
            if (specMap.containsKey("executor")) {
                Object instances;
                Map executor = (Map)specMap.get("executor");
                Object cores = executor.get("cores");
                if (cores instanceof String) {
                    executor.put("cores", Integer.parseInt(cores.toString()));
                }
                if ((instances = executor.get("instances")) instanceof String) {
                    executor.put("instances", Integer.parseInt(instances.toString()));
                }
            }
        }
        return body;
    }

    public void run(String yaml, String projectroot) throws IOException, ApiException {
        if (projectroot == null || projectroot.length() == 0) {
            projectroot = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        }
        Map<String, Object> body = this.loadBody(yaml, projectroot, "", new HashMap<String, Object>());
        this.apiInstance.createNamespacedCustomObject("sparkoperator.k8s.io", "v1beta2", "spark", "sparkapplications", body, "true", null, null);
    }
}

